/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.jdbc;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.ArrayList;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DataSourceConfig {
    @Autowired
    private Environment env;

    @Bean
    @Primary
    public DataSource getDataSource() throws Exception {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setDriverClassName(this.env.getProperty("jdbc.driverClassName"));
        datasource.setUrl(this.env.getProperty("jdbc.url"));
        datasource.setUsername(this.env.getProperty("jdbc.username"));
        datasource.setPassword(this.env.getProperty("jdbc.password"));
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(this.setWallFilter());
        filters.add(this.setStatFilter());
        datasource.setProxyFilters(filters);
        return datasource;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource ds) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(ds);
        sessionFactoryBean.setTypeAliasesPackage(this.env.getProperty("mybatis.type-aliases-package"));
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setConfigLocation(resourcePatternResolver.getResource(this.env.getProperty("mybatis.config-location")));
        sessionFactoryBean.setMapperLocations(resourcePatternResolver.getResources(this.env.getProperty("mybatis.mapper-locations")));
        return sessionFactoryBean.getObject();
    }

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new StatViewServlet());
        servletRegistrationBean.addUrlMappings(new String[]{"/druid/*"});
        return servletRegistrationBean;
    }

    public WallFilter setWallFilter() {
        WallFilter wallFilter = new WallFilter();
        WallConfig config = new WallConfig();
        config.setMultiStatementAllow(true);
        wallFilter.setConfig(config);
        return wallFilter;
    }

    public StatFilter setStatFilter() {
        StatFilter statFilter = new StatFilter();
        statFilter.setLogSlowSql(true);
        statFilter.setMergeSql(true);
        statFilter.setSlowSqlMillis(1000L);
        return statFilter;
    }
}

