/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.utils;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.iartisan.runtime.utils.SSLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtil {
    public static Logger logger = LoggerFactory.getLogger(HttpRequestUtil.class);
    private static OkHttpClient client = null;

    public static Response sendPost(String url, String data, Map<String, String> headers) throws RemoteException {
        Request.Builder builder = new Request.Builder();
        if (null != headers && !headers.isEmpty()) {
            headers.forEach((k, v) -> builder.addHeader(k, v));
        }
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)data);
        try {
            Request request = builder.url(url).post(requestBody).build();
            Response response = client.newCall(request).execute();
            return response;
        }
        catch (IOException e) {
            logger.error("send IOException:", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        catch (Exception e) {
            logger.error("send Exception:", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static Response sendPost(String url, String data) throws RemoteException {
        return HttpRequestUtil.sendPost(url, data, null);
    }

    public static String sendGet(String url, Map<String, String> headers) throws RemoteException {
        Request.Builder builder = new Request.Builder();
        if (null != headers && !headers.isEmpty()) {
            headers.forEach((k, v) -> builder.addHeader(k, v));
        }
        Request request = builder.url(url).build();
        try {
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
        catch (Exception e) {
            logger.error("send Exception:", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static String sendGet(String url) throws RemoteException {
        return HttpRequestUtil.sendGet(url, null);
    }

    static {
        try {
            client = new OkHttpClient.Builder().sslSocketFactory(SSLUtil.getSSLSocketFactory(), SSLUtil.getTrustManager()).hostnameVerifier(SSLUtil.getHostnameVerifier()).build();
        }
        catch (Exception e) {
            logger.error("Exception:", (Throwable)e);
        }
    }
}

