/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.web.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Map;
import org.iartisan.runtime.env.EnvContextConfig;

public class JwtUtil {
    private static final String SECRET = "XX#$%()(#*!()!KL<><MQLMNQNQJQK sdfkjsdrow32234545fdf>?N<:{LWPW";
    private static final String ISSUER = "system";

    private static Algorithm getHS256() {
        return Algorithm.HMAC256((String)EnvContextConfig.get("jwt.secert", SECRET));
    }

    private static String getIssuer() {
        return EnvContextConfig.get("jwt.issuer", ISSUER);
    }

    public static String encode(Map<String, String> claims, long exp) {
        Date date = new Date(System.currentTimeMillis() + exp);
        Algorithm algorithm = JwtUtil.getHS256();
        JWTCreator.Builder builder = JWT.create();
        claims.forEach((v, k) -> builder.withClaim(v, k));
        return builder.withIssuer(JwtUtil.getIssuer()).withExpiresAt(date).sign(algorithm);
    }

    public static Map<String, Claim> decode(String token) {
        Algorithm algorithm = JwtUtil.getHS256();
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer(JwtUtil.getIssuer()).build();
        DecodedJWT result = verifier.verify(token);
        Map claims = result.getClaims();
        return claims;
    }
}

