package org.iartisan.runtime.api.aspect;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.reflect.MethodSignature;
import org.iartisan.runtime.api.code.ResCodeEnum;
import org.iartisan.runtime.api.res.BaseRes;
import org.iartisan.runtime.api.validator.ValidatorUtil;
import org.iartisan.runtime.env.EnvContextConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.Method;

/**
 * <p>
 * biz层 切面类
 * 主要完成接口入参验证 和 日志打印
 *
 * @author King
 * @since 2016/12/30
 */
public class BizAspect {

    private Logger logger = LoggerFactory.getLogger(getClass());

    public void doAspect() {

    }

    @Around("doAspect()")
    public Object around(ProceedingJoinPoint point) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        long start = System.currentTimeMillis();
        Signature signature = point.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method targetMethod = methodSignature.getMethod();
        Class clazz = methodSignature.getReturnType();
        Object[] args = point.getArgs();
        //打印请求参数日志
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                logger.info("{}{}.{}{}{}", Constants.LOG_FACADE_RECIVE, targetMethod.getDeclaringClass().getName(), targetMethod.getName(), Constants.LOG_SYMBOL, arg.toString());
            }
        }
        Object object;
        try {
            //进行接口验证，默认进行验证
            if (EnvContextConfig.get("api.validation", "on").toUpperCase().equals("ON")) {
                for (Object arg : args) {
                    ValidatorUtil.validate(arg);
                }
            }
            object = point.proceed();
            //输出返回日志
            logger.info("{}{}.{}{}{}", Constants.LOG_FACADE_BACK, targetMethod.getDeclaringClass().getName(), targetMethod.getName(), Constants.LOG_SYMBOL, object.toString());
            //输出性能日志
            if (EnvContextConfig.get("performance.log", "OFF").toUpperCase().equals("ON")) {
                logger.info("===>接口{}.{}耗时:{}毫秒", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), (System.currentTimeMillis() - start));
            }
            return object;
        } catch (Throwable throwable) {
            //打印异常信息日志
            logger.error("{}{}", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), throwable);
            object = Class.forName(clazz.getName()).newInstance();
            BaseRes res = (BaseRes) object;
            if (throwable instanceof IllegalArgumentException) {
                res.setCode(ResCodeEnum.IllegalArgument.getCode());
                res.setMsg(throwable.getMessage());
            } else {
                res.setSystemErrorRes();
            }
            logger.info("{}{}.{}{}{}", Constants.LOG_FACADE_BACK, targetMethod.getDeclaringClass().getName(), targetMethod.getName(), Constants.LOG_SYMBOL, res.toString());
            if (EnvContextConfig.get("performance.log", "OFF").equals("ON")) {
                logger.info("===>接口{}.{}耗时:{}毫秒", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), (System.currentTimeMillis() - start));
            }
            return res;
        }
    }
}
