package org.iartisan.runtime.api.req;

import org.iartisan.runtime.bean.Pagination;

/**
 * 分页查询
 *
 * @author King  2019/2/25
 */
public class BasePageReq extends BaseReq {

    /**
     * 页条数大小
     */
    private int pageSize = 10;

    /**
     * 当前页
     */
    private int pageIndex = 1;


    public Pagination getPagination() {
        return new Pagination(pageIndex, pageSize);
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }
}
