package org.iartisan.runtime.api.utils;


import org.iartisan.runtime.api.code.ResCodeEnum;
import org.iartisan.runtime.api.res.*;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.exception.ApiRemoteException;

import java.util.List;

/**
 * <p>
 * res util
 *
 * @author King
 * @since 2018/1/23
 */
public class ApiResUtil {


    public static void getResult(BaseRes t) throws ApiRemoteException {
        if (!t.getCode().equals(ResCodeEnum.succcess.getCode())) {
            throw new ApiRemoteException(t);
        }
    }

    public static boolean check(BaseCheckRes t) throws ApiRemoteException {
        if (!t.getCode().equals(ResCodeEnum.succcess.getCode())) {
            throw new ApiRemoteException(t);
        }
        return t.isResult();
    }

    public static <T> T getBean(BaseOneRes<T> t) throws ApiRemoteException {
        if (t.getCode().equals(ResCodeEnum.succcess.getCode())) {
            return t.getDataObject();
        } else {
            throw new ApiRemoteException(t);
        }
    }

    public static <T> List<T> getDataList(BaseListRes<T> t) throws ApiRemoteException {
        if (t.getCode().equals(ResCodeEnum.succcess.getCode())) {
            return t.getDataList();
        } else {
            throw new ApiRemoteException(t);
        }
    }

    public static <T> PageWrapper<T> getDataPage(BasePageRes<T> t) throws ApiRemoteException {
        if (t.getCode().equals(ResCodeEnum.succcess.getCode())) {
            return t.getDataPage();
        } else {
            throw new ApiRemoteException(t);
        }
    }
}
