package org.iartisan.runtime.bean;

import java.io.Serializable;
import java.util.List;

/**
 * 分页包装对象
 *
 */
public class PageWrapper<T> implements Serializable {

    private int pageIndex;
    private int pageSize;
    private long totalPage;
    private List<T> rows;

    private Pagination page;

    public PageWrapper(Pagination page) {
        this.page = page;
        this.pageIndex = page.getPageIndex();
        this.pageSize = page.getPageSize();
        this.totalPage = page.getTotalPage();
    }

    public PageWrapper(int pageIndex, int pageSize, long total) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.totalPage = total;
    }

    public int getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(long totalPage) {
        this.totalPage = totalPage;
    }

    public List<T> getRows() {
        return rows;
    }

    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    public Pagination getPage() {
        return page;
    }

    public void setPage(Pagination page) {
        this.page = page;
    }
}
