package org.iartisan.runtime.jdbc;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.bean.Pagination;

/**
 * @author King
 * @since 2018/2/26
 */
public class PageHelper {

    public static <T> PageWrapper<T> getAllPageData(MybatisBaseMapper baseMapper, Pagination page) {
        return getPageDataByWrapper(baseMapper, page, Wrappers.emptyWrapper());
    }

    public static <T> PageWrapper<T> getPageData(MybatisBaseMapper baseMapper, Pagination page, T paramter) {
        return getPageDataByWrapper(baseMapper, page, new QueryWrapper(paramter));
    }

    public static <T> PageWrapper<T> getPageDataByWrapper(MybatisBaseMapper baseMapper, Pagination page, Wrapper wrapper) {
        IPage<T> dbPage = new Page(page.getPageIndex(), page.getPageSize());
        IPage dbResult = baseMapper.selectPage(dbPage, wrapper);
        page.setPageIndex((int) dbResult.getCurrent());
        page.setPageSize((int) dbPage.getSize());
        page.setTotalRecords((int) dbPage.getTotal());
        page.setTotalPage((int) dbPage.getPages());
        PageWrapper<T> paginationBean = new PageWrapper(page);
        paginationBean.setRows(dbPage.getRecords());
        return paginationBean;
    }
}
