package org.iartisan.runtime.utils;

import java.util.Date;
import java.util.UUID;

/**
 * @author King  2019-8-21
 */
public class IdUtil {

    public static String timeBaseId(int length) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DateUtils.formatDate(new Date(), DateUtils.YYYYMMDD));
        UUID uuid = UUID.randomUUID();
        stringBuilder.append(Math.abs(uuid.getMostSignificantBits()));
        stringBuilder.append(Math.abs(uuid.getLeastSignificantBits()));
        stringBuilder.setLength(length);
        return stringBuilder.toString();
    }

    public static String shortId() {
        return timeBaseId(12);
    }

    public static String random() {
        return UUID.randomUUID().toString().replace("-", "");
    }
}
