package org.iartisan.runtime.web;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Web 返回前端的值
 *
 * @author King  2019-8-21
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ResBody {

    private static final String SUCCESS_CODE = "000000";

    private static final String SUCCESS_MSG = "成功";

    private static final String ERROR_CODE = "E00000";

    /**
     * 无记录
     */
    private static final String BUSINESS_NO_RECORD_ERROR_CODE = "B00001";

    private static final String BUSINESS_ILLEGAL_ARGUMENT = "B00003";

    /**
     * 不允许的操作
     */
    private static final String BUSINESS_NOT_ALLOWED_ERROR_CODE = "B00002";

    /**
     * 未认证异常
     */
    private static final String NO_AUTH_ERROR_CODE = "A00001";

    /**
     * 返回码
     */
    private String rtnCode;

    /**
     * 返回信息
     */
    private String rtnMsg;

    private Object rtnData;

    public ResBody() {
        this.rtnCode = SUCCESS_CODE;
        this.rtnMsg = SUCCESS_MSG;
    }

    /**
     * 置为失败
     *
     * @param message
     */
    public void isError(String message) {
        setRtnCode(ERROR_CODE);
        setRtnMsg(message);
    }

    public void businessNoRecordError(String message) {
        setRtnCode(BUSINESS_NO_RECORD_ERROR_CODE);
        setRtnMsg(message);
    }

    public void businessNotAllowedError(String message) {
        setRtnCode(BUSINESS_NOT_ALLOWED_ERROR_CODE);
        setRtnMsg(message);
    }

    public void businessIllegalArgument(String message) {
        setRtnCode(BUSINESS_ILLEGAL_ARGUMENT);
        setRtnMsg(message);
    }

    /**
     * 未认证异常
     *
     * @param message
     */
    public void noAuthError(String message) {
        setRtnCode(NO_AUTH_ERROR_CODE);
        setRtnMsg(message);
    }

    /**
     * 置为成功
     *
     * @param message
     */
    public void isSuccess(String message) {
        setRtnCode(SUCCESS_CODE);
        setRtnMsg(SUCCESS_MSG);
    }

    public String getRtnCode() {
        return rtnCode;
    }

    public void setRtnCode(String rtnCode) {
        this.rtnCode = rtnCode;
    }

    public String getRtnMsg() {
        return rtnMsg;
    }

    public void setRtnMsg(String rtnMsg) {
        this.rtnMsg = rtnMsg;
    }

    public Object getRtnData() {
        return rtnData;
    }

    public void setRtnData(Object rtnData) {
        this.rtnData = rtnData;
    }
}
