package org.iartisan.runtime.web;

import org.iartisan.runtime.bean.PageWrapper;
import org.iartisan.runtime.bean.Pagination;

import java.io.Serializable;

/**
 * <p>
 * 后台返回前端对象
 *
 * @author King
 * @since 2017/4/27
 */
public class WebR implements Serializable {

    private static final String SUCCESS_CODE = "000000";

    private static final String SUCCESS_MSG = "成功";

    private static final String ERROR_CODE = "E00000";

    private String code;

    private String message;

    private Object data;

    private int pageSize = 10;

    private int totalPage;

    private int pageIndex = 1;

    private int totalRecords;

    //初始化默认成功
    public WebR() {
        this.code = SUCCESS_CODE;
        this.message = SUCCESS_MSG;
    }

    public WebR(PageWrapper<?> pageWrapper) {
        this.code = SUCCESS_CODE;
        this.message = SUCCESS_MSG;
        this.pageSize = pageWrapper.getPage().getPageSize();
        this.totalPage = pageWrapper.getPage().getTotalPage();
        this.pageIndex = pageWrapper.getPage().getPageIndex();
        this.totalRecords = pageWrapper.getPage().getTotalRecords();
        this.data = pageWrapper.getRows();
    }

    //分页返回初始化
    public WebR(Pagination page) {
        this.code = SUCCESS_CODE;
        this.message = SUCCESS_MSG;
        this.pageSize = page.getPageSize();
        this.totalPage = page.getTotalPage();
        this.pageIndex = page.getPageIndex();
        this.totalRecords = page.getTotalRecords();
    }

    //置为失败
    public void isError(String message) {
        setCode(ERROR_CODE);
        setMessage(message);
    }

    //置为成功
    public void isSuccess(String message) {
        setCode(SUCCESS_CODE);
        setMessage(SUCCESS_MSG);
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public int getPageSize() {
        return pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalPage() {
        return totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getPageIndex() {
        return pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public int getTotalRecords() {
        return totalRecords;
    }

    public void setTotalRecords(int totalRecords) {
        this.totalRecords = totalRecords;
    }
}
