package org.iartisan.runtime.web.controller;

import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.iartisan.runtime.web.authentication.RealmBean;
import org.iartisan.runtime.web.contants.WebConstants;
import org.iartisan.runtime.web.utils.WebUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;


/**
 * <p>
 * base controller
 *
 * @author King
 * @since 2017/12/19
 */
public abstract class BaseController {

    protected final static String _data = "data";

    protected final static String _redirect = "redirect:";

    protected Logger logger = LoggerFactory.getLogger(getClass());

    protected String getCustId() {
        RealmBean realmBean = getRealmBean();
        if (null != realmBean) {
            return realmBean.getUserId();
        }
        return "";
    }

    protected RealmBean getRealmBean() {
        RealmBean realmBean = (RealmBean) WebUtil.getShiroSession().getAttribute(WebConstants._USER);
        return realmBean;
    }

    public void exportExcel(HttpServletResponse response, HSSFWorkbook wb) throws IOException {
        OutputStream out = null;
        try {
            out = response.getOutputStream();
            wb.write(out);
        } finally {
            out.flush();
            out.close();
        }
    }
}
