/*
 * Decompiled with CFR 0.152.
 */
package org.iartisan.runtime.jdbc;

import com.alibaba.druid.filter.stat.StatFilter;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.support.http.StatViewServlet;
import com.alibaba.druid.wall.WallConfig;
import com.alibaba.druid.wall.WallFilter;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.iartisan.runtime.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DataSourceConfig {
    @Autowired
    private Environment env;
    private static final String mybatis_mapper_locations_key = "mybatis.mapper-locations";

    @Bean
    @Primary
    public DataSource getDataSource() throws Exception {
        DruidDataSource datasource = new DruidDataSource();
        datasource.setDriverClassName(this.env.getProperty("jdbc.driverClassName"));
        datasource.setUrl(this.env.getProperty("jdbc.url"));
        datasource.setUsername(this.env.getProperty("jdbc.username"));
        datasource.setPassword(this.env.getProperty("jdbc.password"));
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(this.setWallFilter());
        filters.add(this.setStatFilter());
        datasource.setProxyFilters(filters);
        return datasource;
    }

    @Bean
    public SqlSessionFactory sqlSessionFactory(DataSource ds) throws Exception {
        MybatisSqlSessionFactoryBean sessionFactoryBean = new MybatisSqlSessionFactoryBean();
        sessionFactoryBean.setDataSource(ds);
        sessionFactoryBean.setTypeAliasesPackage(this.env.getProperty("mybatis.type-aliases-package"));
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        sessionFactoryBean.setConfigLocation(resourcePatternResolver.getResource(this.env.getProperty("mybatis.config-location")));
        if (StringUtils.isNotEmpty(this.env.getProperty(mybatis_mapper_locations_key))) {
            String[] locals = this.env.getProperty(mybatis_mapper_locations_key).split(",");
            ArrayList<Resource> resourceList = new ArrayList<Resource>();
            for (String local : locals) {
                Resource[] resources = resourcePatternResolver.getResources(local);
                resourceList.addAll(Arrays.asList(resources));
            }
            sessionFactoryBean.setMapperLocations(resourceList.toArray(new Resource[0]));
        }
        Properties configProperties = new Properties();
        configProperties.put("prefix", "");
        configProperties.put("blobType", this.env.getProperty("flowable.mybatis.JdbcType.blobType"));
        configProperties.put("boolValue", this.env.getProperty("flowable.mybatis.JdbcType.boolValue"));
        sessionFactoryBean.setConfigurationProperties(configProperties);
        return sessionFactoryBean.getObject();
    }

    @Bean
    public ServletRegistrationBean druidServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean();
        servletRegistrationBean.setServlet((Servlet)new StatViewServlet());
        servletRegistrationBean.addUrlMappings(new String[]{"/druid/*"});
        return servletRegistrationBean;
    }

    public WallFilter setWallFilter() {
        WallFilter wallFilter = new WallFilter();
        WallConfig config = new WallConfig();
        config.setMultiStatementAllow(true);
        wallFilter.setConfig(config);
        return wallFilter;
    }

    public StatFilter setStatFilter() {
        StatFilter statFilter = new StatFilter();
        statFilter.setLogSlowSql(true);
        statFilter.setMergeSql(true);
        statFilter.setSlowSqlMillis(1000L);
        return statFilter;
    }
}

