/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.frankframework.frankdoc.AttributeReuseManagerCallback;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.util.XmlBuilder;

class AttributeReuseManager {
    private List<Object> attributeSequence = new ArrayList<Object>();
    private Map<String, ReferencedFrankAttributeNameGroup> groupedAttributeReferences = new HashMap<String, ReferencedFrankAttributeNameGroup>();
    private Set<FrankAttribute> definedReusableAttributes = new HashSet<FrankAttribute>();

    AttributeReuseManager() {
    }

    void addAttribute(FrankAttribute frankAttribute, XmlBuilder xsdGroup, String xsdGroupName) {
        AttributeReference attributeReference = new AttributeReference(frankAttribute, xsdGroup, xsdGroupName);
        this.attributeSequence.add(attributeReference);
        if (this.groupedAttributeReferences.containsKey(frankAttribute.getName())) {
            this.groupedAttributeReferences.get(frankAttribute.getName()).add(attributeReference);
        } else {
            this.groupedAttributeReferences.put(frankAttribute.getName(), new ReferencedFrankAttributeNameGroup(attributeReference));
        }
    }

    void addAttribute(XmlBuilder attributeBuilder, XmlBuilder group) {
        this.attributeSequence.add(new AttributeToInsert(attributeBuilder, group));
    }

    void buildAttributes(AttributeReuseManagerCallback callback) {
        this.classifyAttributesToBuild();
        this.buildClassifiedAttributes(callback);
    }

    private void classifyAttributesToBuild() {
        this.groupedAttributeReferences.values().stream().forEach(this::classifyAttributesHavingNameInCommon);
    }

    private void classifyAttributesHavingNameInCommon(ReferencedFrankAttributeNameGroup nameGroup) {
        if (nameGroup.hasMultipleReusedAttributes()) {
            nameGroup.setNoAttributeReferenceReuses();
        } else {
            nameGroup.getAttributesReferencedOnce().forEach(ReferencedFrankAttribute::setNoAttributeReferenceReuses);
        }
    }

    private void buildClassifiedAttributes(AttributeReuseManagerCallback callback) {
        for (Object item : this.attributeSequence) {
            if (item instanceof AttributeReference) {
                this.buildAttribute((AttributeReference)item, callback);
                continue;
            }
            AttributeToInsert attributeToInsert = (AttributeToInsert)item;
            attributeToInsert.parentBuilder.addSubElement(attributeToInsert.attributeBuilder);
        }
    }

    private void buildAttribute(AttributeReference attributeReference, AttributeReuseManagerCallback callback) {
        if (attributeReference.reused) {
            if (!this.definedReusableAttributes.contains(attributeReference.frankAttribute)) {
                callback.addReusableAttribute(attributeReference.frankAttribute);
                this.definedReusableAttributes.add(attributeReference.frankAttribute);
            }
            callback.addReusedAttributeReference(attributeReference.frankAttribute, attributeReference.xsdGroup, attributeReference.xsdGroupName);
        } else {
            callback.addAttributeInline(attributeReference.frankAttribute, attributeReference.xsdGroup, attributeReference.xsdGroupName);
        }
    }

    private static class ReferencedFrankAttributeNameGroup {
        private Map<FrankAttribute, ReferencedFrankAttribute> referencedFrankAttributes = new HashMap<FrankAttribute, ReferencedFrankAttribute>();

        ReferencedFrankAttributeNameGroup(AttributeReference first) {
            ReferencedFrankAttribute referencedFrankAttribute = new ReferencedFrankAttribute(first);
            this.referencedFrankAttributes.put(first.frankAttribute, referencedFrankAttribute);
        }

        private String getName() {
            return this.referencedFrankAttributes.values().iterator().next().getAttributeName();
        }

        void add(AttributeReference item) {
            if (!item.frankAttribute.getName().equals(this.getName())) {
                throw new IllegalArgumentException("FrankAttribute name mismatch");
            }
            if (this.referencedFrankAttributes.containsKey(item.frankAttribute)) {
                this.referencedFrankAttributes.get(item.frankAttribute).add(item);
            } else {
                ReferencedFrankAttribute referencedFrankAttribute = new ReferencedFrankAttribute(item);
                this.referencedFrankAttributes.put(item.frankAttribute, referencedFrankAttribute);
            }
        }

        List<ReferencedFrankAttribute> getAttributesReferencedOnce() {
            return this.referencedFrankAttributes.values().stream().filter(ReferencedFrankAttribute::isFrankAttributeReferencedOnce).collect(Collectors.toList());
        }

        boolean hasMultipleReusedAttributes() {
            return this.referencedFrankAttributes.values().stream().filter(g -> !g.isFrankAttributeReferencedOnce()).skip(1L).findAny().isPresent();
        }

        void setNoAttributeReferenceReuses() {
            this.referencedFrankAttributes.values().forEach(ReferencedFrankAttribute::setNoAttributeReferenceReuses);
        }
    }

    private static class ReferencedFrankAttribute {
        private List<AttributeReference> itemsThatShareFrankAttribute = new ArrayList<AttributeReference>();

        ReferencedFrankAttribute(AttributeReference first) {
            this.itemsThatShareFrankAttribute.add(first);
        }

        void add(AttributeReference item) {
            if (item.frankAttribute != this.itemsThatShareFrankAttribute.get((int)0).frankAttribute) {
                throw new IllegalArgumentException("Referenced FrankAttribute does not match");
            }
            this.itemsThatShareFrankAttribute.add(item);
        }

        boolean isFrankAttributeReferencedOnce() {
            return this.itemsThatShareFrankAttribute.size() == 1;
        }

        String getAttributeName() {
            return this.itemsThatShareFrankAttribute.get((int)0).frankAttribute.getName();
        }

        void setNoAttributeReferenceReuses() {
            this.itemsThatShareFrankAttribute.stream().forEach(item -> {
                item.reused = false;
            });
        }
    }

    private static class AttributeToInsert {
        XmlBuilder attributeBuilder;
        XmlBuilder parentBuilder;

        AttributeToInsert(XmlBuilder attributeBuilder, XmlBuilder parentBuilder) {
            this.attributeBuilder = attributeBuilder;
            this.parentBuilder = parentBuilder;
        }
    }

    private static class AttributeReference {
        FrankAttribute frankAttribute;
        XmlBuilder xsdGroup;
        String xsdGroupName;
        boolean reused = true;

        AttributeReference(FrankAttribute frankAttribute, XmlBuilder xsdGroup, String xsdGroupName) {
            this.frankAttribute = frankAttribute;
            this.xsdGroup = xsdGroup;
            this.xsdGroupName = xsdGroupName;
        }
    }
}

