/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.DocWriterNewXmlUtils;
import org.frankframework.frankdoc.model.AttributeEnum;
import org.frankframework.frankdoc.model.AttributeEnumValue;
import org.frankframework.frankdoc.model.AttributeType;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.util.XmlBuilder;

public enum AttributeTypeStrategy {
    ALLOW_PROPERTY_REF(new DelegateAllowPropertyRefEnumDocumentedCaseSensitive()),
    ALLOW_PROPERTY_REF_ENUM_VALUES_IGNORE_CASE(new DelegateAllowPropertyRefEnumIgnoreCase());

    private static Logger log;
    static final String ATTRIBUTE_ACTIVE_NAME = "active";
    private static final String PATTERN_REF = "$\\{[^\\}]+\\}";
    private static final String FRANK_BOOLEAN = "frankBoolean";
    private static final String FRANK_INT = "frankInt";
    private static final String PATTERN_FRANK_BOOLEAN;
    private static final String PATTERN_FRANK_INT;
    private final Delegate delegate;

    private AttributeTypeStrategy(Delegate delegate) {
        this.delegate = delegate;
    }

    XmlBuilder createAttribute(String name, AttributeType modelAttributeType) {
        return this.delegate.createAttribute(name, modelAttributeType);
    }

    XmlBuilder createRestrictedAttribute(FrankAttribute attribute, Consumer<XmlBuilder> documenter) {
        return this.delegate.createRestrictedAttribute(attribute, documenter);
    }

    static XmlBuilder createAttributeActive() {
        return DocWriterNewXmlUtils.createAttributeRef(ATTRIBUTE_ACTIVE_NAME);
    }

    List<XmlBuilder> createHelperTypes() {
        return this.delegate.createHelperTypes();
    }

    XmlBuilder createAttributeEnumType(AttributeEnum attributeEnum) {
        return this.delegate.createAttributeEnumType(attributeEnum);
    }

    static {
        log = LogUtil.getLogger(AttributeTypeStrategy.class);
        PATTERN_FRANK_BOOLEAN = String.format("(true|false)|(%s)", PATTERN_REF);
        PATTERN_FRANK_INT = String.format("((\\+|-)?[0-9]+)|(%s)", PATTERN_REF);
    }

    private static class DelegateAllowPropertyRefEnumIgnoreCase
    extends Delegate {
        private DelegateAllowPropertyRefEnumIgnoreCase() {
        }

        @Override
        void addEnumValue(XmlBuilder restriction, AttributeEnumValue v) {
            DocWriterNewXmlUtils.addPattern(restriction, this.getCaseInsensitivePattern(v.getLabel()));
        }
    }

    private static class DelegateAllowPropertyRefEnumDocumentedCaseSensitive
    extends Delegate {
        private DelegateAllowPropertyRefEnumDocumentedCaseSensitive() {
        }

        @Override
        void addEnumValue(XmlBuilder restriction, AttributeEnumValue v) {
            if (!v.isDeprecated()) {
                XmlBuilder valueBuilder = DocWriterNewXmlUtils.addEnumeration(restriction, v.getLabel());
                if (v.getDescription() != null) {
                    DocWriterNewXmlUtils.addDocumentation(valueBuilder, v.getDescription());
                }
            }
        }
    }

    private static abstract class Delegate {
        private Delegate() {
        }

        XmlBuilder createAttribute(String name, AttributeType modelAttributeType) {
            return this.createAttribute(name, modelAttributeType, AttributeTypeStrategy.FRANK_BOOLEAN, AttributeTypeStrategy.FRANK_INT);
        }

        private final XmlBuilder createAttribute(String name, AttributeType modelAttributeType, String boolType, String intType) {
            XmlBuilder attribute = DocWriterNewXmlUtils.createAttributeWithType(name);
            String typeName = null;
            switch (modelAttributeType) {
                case BOOL: {
                    typeName = boolType;
                    break;
                }
                case INT: {
                    typeName = intType;
                    break;
                }
                case STRING: {
                    typeName = "xs:string";
                }
            }
            attribute.addAttribute("type", typeName);
            return attribute;
        }

        final XmlBuilder createRestrictedAttribute(FrankAttribute attribute, Consumer<XmlBuilder> documenter) {
            AttributeEnum attributeEnum = attribute.getAttributeEnum();
            XmlBuilder attributeBuilder = DocWriterNewXmlUtils.createAttributeWithType(attribute.getName());
            documenter.accept(attributeBuilder);
            XmlBuilder simpleType = DocWriterNewXmlUtils.addSimpleType(attributeBuilder);
            DocWriterNewXmlUtils.addUnion(simpleType, attributeEnum.getUniqueName("AttributeValuesType"), "variableRef");
            return attributeBuilder;
        }

        final XmlBuilder createAttributeEnumType(AttributeEnum attributeEnum) {
            XmlBuilder simpleType = DocWriterNewXmlUtils.createSimpleType(attributeEnum.getUniqueName("AttributeValuesType"));
            XmlBuilder restriction = DocWriterNewXmlUtils.addRestriction(simpleType, "xs:string");
            attributeEnum.getValues().forEach(v -> this.addEnumValue(restriction, (AttributeEnumValue)v));
            return simpleType;
        }

        abstract void addEnumValue(XmlBuilder var1, AttributeEnumValue var2);

        final List<XmlBuilder> createHelperTypes() {
            log.trace("Adding helper types for boolean and integer attributes, allowing ${...} references");
            ArrayList<XmlBuilder> result = new ArrayList<XmlBuilder>();
            result.add(Delegate.createTypeFrankBoolean());
            result.add(Delegate.createTypeFrankInteger());
            result.add(this.createAttributeForAttributeActive());
            result.add(Delegate.createTypeVariableReference("variableRef"));
            return result;
        }

        private static XmlBuilder createTypeFrankBoolean() {
            return Delegate.createStringRestriction(AttributeTypeStrategy.FRANK_BOOLEAN, PATTERN_FRANK_BOOLEAN);
        }

        private static XmlBuilder createTypeFrankInteger() {
            return Delegate.createStringRestriction(AttributeTypeStrategy.FRANK_INT, PATTERN_FRANK_INT);
        }

        private static XmlBuilder createTypeVariableReference(String name) {
            return Delegate.createStringRestriction(name, AttributeTypeStrategy.PATTERN_REF);
        }

        private static XmlBuilder createStringRestriction(String name, String pattern) {
            XmlBuilder simpleType = new XmlBuilder("simpleType", "xs", "http://www.w3.org/2001/XMLSchema");
            simpleType.addAttribute("name", name);
            XmlBuilder restriction = new XmlBuilder("restriction", "xs", "http://www.w3.org/2001/XMLSchema");
            simpleType.addSubElement(restriction);
            restriction.addAttribute("base", "xs:string");
            DocWriterNewXmlUtils.addPattern(restriction, pattern);
            return simpleType;
        }

        private XmlBuilder createAttributeForAttributeActive() {
            XmlBuilder attribute = new XmlBuilder("attribute", "xs", "http://www.w3.org/2001/XMLSchema");
            attribute.addAttribute("name", AttributeTypeStrategy.ATTRIBUTE_ACTIVE_NAME);
            DocWriterNewXmlUtils.addDocumentation(attribute, "If defined and empty or false, then this element and all its children are ignored");
            XmlBuilder simpleType = DocWriterNewXmlUtils.addSimpleType(attribute);
            XmlBuilder restriction = DocWriterNewXmlUtils.addRestriction(simpleType, "xs:string");
            DocWriterNewXmlUtils.addPattern(restriction, this.getPattern());
            return attribute;
        }

        private String getPattern() {
            return "!?(" + this.getPatternThatMightBeNegated() + ")";
        }

        private String getPatternThatMightBeNegated() {
            String patternTrue = this.getCaseInsensitivePattern(Boolean.valueOf(true).toString());
            String patternFalse = this.getCaseInsensitivePattern(Boolean.valueOf(false).toString());
            return Arrays.asList(AttributeTypeStrategy.PATTERN_REF, patternTrue, patternFalse).stream().map(s -> "(" + s + ")").collect(Collectors.joining("|"));
        }

        final String getCaseInsensitivePattern(String word) {
            return IntStream.range(0, word.length()).mapToObj(i -> Character.valueOf(word.charAt(i))).map(c -> "[" + Character.toLowerCase(c.charValue()) + Character.toUpperCase(c.charValue()) + "]").collect(Collectors.joining(""));
        }
    }
}

