/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.frankframework.frankdoc.AttributeReuseManager;
import org.frankframework.frankdoc.AttributeReuseManagerCallback;
import org.frankframework.frankdoc.AttributeTypeStrategy;
import org.frankframework.frankdoc.DocWriterNewXmlUtils;
import org.frankframework.frankdoc.ElementGroupManager;
import org.frankframework.frankdoc.GenericOptionAttributeTask;
import org.frankframework.frankdoc.GroupCreator;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.XsdVersion;
import org.frankframework.frankdoc.model.AttributeEnum;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ConfigChildGroupKind;
import org.frankframework.frankdoc.model.ConfigChildSet;
import org.frankframework.frankdoc.model.CumulativeChildHandler;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.model.ElementType;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.model.FrankDocModel;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.model.TextConfigChild;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.util.XmlBuilder;

public class DocWriterNew
implements AttributeReuseManagerCallback {
    private static Logger log = LogUtil.getLogger(DocWriterNew.class);
    private static Map<XsdVersion, String> outputFileNames = new HashMap<XsdVersion, String>();
    private static final String CONFIGURATION = "nl.nn.adapterframework.configuration.Configuration";
    private static final String ELEMENT_ROLE = "elementRole";
    private static final String CLASS_NAME = "className";
    private static final String ELEMENT_GROUP_BASE = "ElementGroupBase";
    static final String ATTRIBUTE_VALUES_TYPE = "AttributeValuesType";
    static final String VARIABLE_REFERENCE = "variableRef";
    private FrankDocModel model;
    private String startClassName;
    private XsdVersion version;
    private final AttributeReuseManager attributeReuseManager = new AttributeReuseManager();
    private List<XmlBuilder> xsdElements = new ArrayList<XmlBuilder>();
    private List<XmlBuilder> xsdComplexItems = new ArrayList<XmlBuilder>();
    private List<XmlBuilder> xsdReusedAttributes = new ArrayList<XmlBuilder>();
    private Set<String> namesCreatedFrankElements = new HashSet<String>();
    private Set<ElementRole.Key> idsCreatedElementGroups = new HashSet<ElementRole.Key>();
    private ElementGroupManager elementGroupManager;
    private Set<String> definedAttributeEnumInstances = new HashSet<String>();
    private AttributeTypeStrategy attributeTypeStrategy;
    private final String frankFrameworkVersion;

    public DocWriterNew(FrankDocModel model, AttributeTypeStrategy attributeTypeStrategy, String frankFrameworkVersion) {
        this.model = model;
        this.attributeTypeStrategy = attributeTypeStrategy;
        this.frankFrameworkVersion = frankFrameworkVersion;
    }

    public void init(XsdVersion version) {
        this.init(CONFIGURATION, version);
    }

    void init(String startClassName, XsdVersion version) {
        this.startClassName = startClassName;
        this.version = version;
        log.trace("Initialized DocWriterNew with start element name [{}], version [{}] and output file [{}]", () -> startClassName, () -> version.toString(), () -> outputFileNames.get((Object)version));
        this.elementGroupManager = new ElementGroupManager(version.getChildSelector(), version.getChildRejector());
    }

    public String getSchema() {
        XmlBuilder xsdRoot = DocWriterNewXmlUtils.getXmlSchema(this.frankFrameworkVersion);
        log.trace("Going to create XmlBuilder objects that will be added to the schema root builder afterwards");
        FrankElement startElement = this.model.findFrankElement(this.startClassName);
        this.defineElements(startElement);
        this.finishLeftoverGenericOptionsAttributes();
        log.trace("Creating the attributes");
        this.attributeReuseManager.buildAttributes(this);
        log.trace("Creating helper types");
        List<XmlBuilder> xsdHelperTypes = this.attributeTypeStrategy.createHelperTypes();
        log.trace("Have the XmlBuilder objects. Going to add them in the right order to the schema root builder");
        this.xsdElements.forEach(xsdRoot::addSubElement);
        this.xsdComplexItems.forEach(xsdRoot::addSubElement);
        this.xsdReusedAttributes.forEach(xsdRoot::addSubElement);
        xsdHelperTypes.forEach(xsdRoot::addSubElement);
        log.trace("Populating schema root builder is done. Going to create the XML string to return");
        return xsdRoot.toXML(true);
    }

    private void defineElements(FrankElement startElement) {
        switch (this.version) {
            case STRICT: {
                this.addStartElementAsTypeReference(startElement);
                this.addReferencedEntityRoot(startElement);
                this.recursivelyDefineReusableFrankElementType(startElement);
                break;
            }
            case COMPATIBILITY: {
                this.recursivelyDefineRootFrankElement(startElement);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot happen - all case labels should be in switch");
            }
        }
    }

    private void addStartElementAsTypeReference(FrankElement startElement) {
        log.trace("Adding element [{}] as type reference", () -> startElement.getSimpleName());
        XmlBuilder startElementBuilder = DocWriterNewXmlUtils.createElementWithType(startElement.getSimpleName());
        this.xsdElements.add(startElementBuilder);
        this.addDocumentationFrom(startElementBuilder, startElement);
        XmlBuilder complexType = DocWriterNewXmlUtils.addComplexType(startElementBuilder);
        XmlBuilder complexContent = DocWriterNewXmlUtils.addComplexContent(complexType);
        DocWriterNewXmlUtils.addExtension(complexContent, this.xsdElementType(startElement));
    }

    private void addReferencedEntityRoot(FrankElement startElement) {
        log.trace("Adding element [{}] using type [{}]", () -> "Module", () -> this.xsdElementType(startElement));
        XmlBuilder startElementBuilder = DocWriterNewXmlUtils.createElementWithType("Module");
        this.xsdElements.add(startElementBuilder);
        DocWriterNewXmlUtils.addDocumentation(startElementBuilder, "Wrapper element to help split up large configuration files into smaller valid XML files. It may be used as root tag when an XML file contains multiple adapters and/or jobs. The Module element itself does not influence the behavior of Frank configurations.");
        XmlBuilder complexType = DocWriterNewXmlUtils.addComplexType(startElementBuilder);
        String declaredChildGroup = this.getConfigChildGroupOf(startElement);
        if (declaredChildGroup != null) {
            DocWriterNewXmlUtils.addGroupRef(complexType, declaredChildGroup);
        }
        log.trace("Adding attribute active explicitly to [{}] and also any attribute in another namespace", () -> "Module");
        XmlBuilder attributeActive = AttributeTypeStrategy.createAttributeActive();
        this.attributeReuseManager.addAttribute(attributeActive, complexType);
        XmlBuilder anyOther = DocWriterNewXmlUtils.createAnyOtherNamespaceAttribute();
        this.attributeReuseManager.addAttribute(anyOther, complexType);
    }

    private String getConfigChildGroupOf(FrankElement frankElement) {
        if (frankElement.getCumulativeConfigChildren(this.version.getChildSelector(), this.version.getChildRejector()).isEmpty()) {
            return null;
        }
        if (frankElement.hasOrInheritsPluralConfigChildren(this.version.getChildSelector(), this.version.getChildRejector())) {
            return DocWriterNew.xsdPluralGroupNameForChildren(frankElement);
        }
        return DocWriterNew.xsdDeclaredGroupNameForChildren(frankElement);
    }

    private void recursivelyDefineRootFrankElement(FrankElement frankElement) {
        log.trace("Enter root FrankElement [{}]", () -> frankElement.getFullName());
        if (this.checkNotDefined(frankElement)) {
            String xsdElementName = frankElement.getSimpleName();
            XmlBuilder elementBuilder = DocWriterNewXmlUtils.createElement(xsdElementName, this.getTypeName(xsdElementName));
            this.xsdElements.add(elementBuilder);
            XmlBuilder attributeBuilder = this.recursivelyDefineSimpleFrankElementTypeUnchecked(frankElement, this.getTypeName(xsdElementName));
            log.trace("Adding any attribute in another namespace to root element [{}]", () -> frankElement.getFullName());
            XmlBuilder anyOther = DocWriterNewXmlUtils.createAnyOtherNamespaceAttribute();
            this.attributeReuseManager.addAttribute(anyOther, attributeBuilder);
        }
        log.trace("Leave root FrankElement [{}]", () -> frankElement.getFullName());
    }

    private String getTypeName(String elementName) {
        return elementName + "Type";
    }

    private XmlBuilder recursivelyDefineSimpleFrankElementTypeUnchecked(FrankElement frankElement, String xsdElementTypeName) {
        log.trace("Defining [{}] for FrankElement [{}], no groups for attributes or config children", () -> xsdElementTypeName, () -> frankElement.getFullName());
        XmlBuilder complexType = DocWriterNewXmlUtils.createComplexType(xsdElementTypeName);
        this.xsdElements.add(complexType);
        this.addDocumentationFrom(complexType, frankElement);
        log.trace("Adding cumulative config chidren of FrankElement [{}] to XSD type [{}]", () -> frankElement.getFullName(), () -> xsdElementTypeName);
        if (frankElement.hasOrInheritsPluralConfigChildren(this.version.getChildSelector(), this.version.getChildRejector())) {
            log.trace("FrankElement [{}] has plural config children", () -> frankElement.getFullName());
            XmlBuilder sequence = DocWriterNewXmlUtils.addSequence(complexType);
            XmlBuilder choice = DocWriterNewXmlUtils.addChoice(sequence, "0", "unbounded");
            for (ConfigChildSet configChildSet : frankElement.getCumulativeConfigChildSets()) {
                this.addPluralConfigChild(choice, configChildSet, frankElement);
            }
        } else {
            log.trace("FrankElement [{}] does not have plural config children", () -> frankElement.getFullName());
            List<ConfigChild> cumulativeConfigChildren = frankElement.getCumulativeConfigChildren(this.version.getChildSelector(), this.version.getChildRejector());
            if (cumulativeConfigChildren.isEmpty()) {
                log.trace("There are no config children, not adding <sequence><choice>");
            } else {
                XmlBuilder sequence = DocWriterNewXmlUtils.addSequence(complexType);
                XmlBuilder childContext = this.version.configChildBuilderWithinSequence(sequence);
                cumulativeConfigChildren.forEach(c -> this.addConfigChild(childContext, (ConfigChild)c));
            }
        }
        log.trace("Adding cumulative attributes of FrankElement [{}] to XSD element type [{}]", () -> frankElement.getFullName(), () -> xsdElementTypeName);
        this.addAttributeList(complexType, frankElement.getCumulativeAttributes(this.version.getChildSelector(), this.version.getChildRejector()), xsdElementTypeName);
        log.trace("Adding attribute className for FrankElement [{}]", () -> frankElement.getFullName());
        XmlBuilder classNameAttribute = DocWriterNewXmlUtils.createAttribute(CLASS_NAME, DocWriterNewXmlUtils.AttributeValueStatus.FIXED, frankElement.getFullName(), this.version.getClassNameAttributeUse(frankElement));
        this.attributeReuseManager.addAttribute(classNameAttribute, complexType);
        log.trace("Adding attribute active for FrankElement [{}]", () -> frankElement.getFullName());
        XmlBuilder attributeActive = AttributeTypeStrategy.createAttributeActive();
        this.attributeReuseManager.addAttribute(attributeActive, complexType);
        return complexType;
    }

    private void recursivelyDefineReusableFrankElementType(FrankElement frankElement) {
        if (log.isTraceEnabled()) {
            log.trace("XML Schema needs reusable type definition (or only groups for config children or attributes) for FrankElement [{}]", () -> frankElement == null ? "null" : frankElement.getFullName());
        }
        if (this.checkNotDefined(frankElement)) {
            ElementBuildingStrategy elementBuildingStrategy = this.getElementBuildingStrategy(frankElement);
            log.trace("Visiting config children for FrankElement [{}]", () -> frankElement.getFullName());
            this.addConfigChildren(elementBuildingStrategy, frankElement);
            log.trace("Visiting attributes for FrankElement [{}]", () -> frankElement.getFullName());
            this.addAttributes(elementBuildingStrategy, frankElement);
            if (!frankElement.isAbstract()) {
                log.trace("Adding attribute className to the element type of [{}]", () -> frankElement.getFullName());
                XmlBuilder classNameAttribute = DocWriterNewXmlUtils.createAttribute(CLASS_NAME, DocWriterNewXmlUtils.AttributeValueStatus.FIXED, frankElement.getFullName(), this.version.getClassNameAttributeUse(frankElement));
                this.attributeReuseManager.addAttribute(classNameAttribute, elementBuildingStrategy.getElementTypeBuilder());
            }
            if (elementBuildingStrategy.needsSpecialAttributesInElementType()) {
                log.trace("Adding attribute active and anyAttribute in another namespace to the element type of [{}], because there are no attribute groups to put this in", () -> frankElement.toString());
                XmlBuilder attributeActive = AttributeTypeStrategy.createAttributeActive();
                this.attributeReuseManager.addAttribute(attributeActive, elementBuildingStrategy.getElementTypeBuilder());
                XmlBuilder anyOther = DocWriterNewXmlUtils.createAnyOtherNamespaceAttribute();
                this.attributeReuseManager.addAttribute(anyOther, elementBuildingStrategy.getElementTypeBuilder());
            }
            log.trace("Creating reusable type definitions (or only groups) for Java ancestors of FrankElement [{}]", () -> frankElement.getFullName());
            this.recursivelyDefineReusableFrankElementType(frankElement.getNextAncestorThatHasOrRejectsConfigChildren(this.version.getChildSelector(), this.version.getChildRejector()));
            this.recursivelyDefineReusableFrankElementType(frankElement.getNextAncestorThatHasOrRejectsAttributes(this.version.getChildSelector(), this.version.getChildRejector()));
            log.trace("Done with reusable XSD type definitions for ancestors of FrankElement [{}]", () -> frankElement.getFullName());
        } else {
            log.trace("Reusable type definition was already included");
        }
    }

    private boolean checkNotDefined(FrankElement frankElement) {
        if (frankElement == null) {
            return false;
        }
        if (this.namesCreatedFrankElements.contains(frankElement.getFullName())) {
            return false;
        }
        this.namesCreatedFrankElements.add(frankElement.getFullName());
        return true;
    }

    private ElementBuildingStrategy getElementBuildingStrategy(FrankElement element) {
        if (element.isAbstract()) {
            log.trace("FrankElement [{}] is abstract, so we do not actually create an XSD type definition. We only create config child or attribute groups to be referenced from other XSD types", () -> element.getFullName());
            return new ElementOmitter();
        }
        log.trace("FrankElement [{}] is not abstract. We really make the XSD type definition", () -> element.getFullName());
        return new ElementAdder(element);
    }

    private void addConfigChildren(ElementBuildingStrategy elementBuildingStrategy, FrankElement frankElement) {
        if (frankElement.hasOrInheritsPluralConfigChildren(this.version.getChildSelector(), this.version.getChildRejector())) {
            this.addConfigChildrenWithPluralConfigChildSets(elementBuildingStrategy, frankElement);
        } else {
            this.addConfigChildrenNoPluralConfigChildSets(elementBuildingStrategy, frankElement);
        }
    }

    private void addConfigChildrenNoPluralConfigChildSets(final ElementBuildingStrategy elementBuildingStrategy, final FrankElement frankElement) {
        Consumer cumulativeGroupTrigger = ca -> frankElement.walkCumulativeConfigChildren((CumulativeChildHandler<ConfigChild>)ca, this.version.getChildSelector(), this.version.getChildRejector());
        new GroupCreator<ConfigChild>(frankElement, this.version.getHasRelevantChildrenPredicate(ConfigChild.class), cumulativeGroupTrigger, new GroupCreator.Callback<ConfigChild>(){
            private XmlBuilder cumulativeBuilder;
            private String cumulativeGroupName;

            @Override
            public void noChildren() {
            }

            @Override
            public void addDeclaredGroupRef(FrankElement referee) {
                elementBuildingStrategy.addGroupRef(DocWriterNew.xsdDeclaredGroupNameForChildren(referee));
            }

            @Override
            public void addCumulativeGroupRef(FrankElement referee) {
                elementBuildingStrategy.addGroupRef(DocWriterNew.xsdCumulativeGroupNameForChildren(referee));
            }

            @Override
            public void addTopLevelDeclaredGroup() {
                this.addDeclaredGroup();
            }

            @Override
            public void addDeclaredGroup() {
                String groupName = DocWriterNew.xsdDeclaredGroupNameForChildren(frankElement);
                log.trace("Creating XSD group [{}]", (Object)groupName);
                XmlBuilder group = DocWriterNewXmlUtils.createGroup(groupName);
                DocWriterNew.this.xsdComplexItems.add(group);
                XmlBuilder sequence = DocWriterNewXmlUtils.addSequence(group);
                DocWriterNew.this.addReferencedEntityRootChildIfApplicable(sequence, frankElement);
                frankElement.getConfigChildren(DocWriterNew.this.version.getChildSelector()).forEach(c -> DocWriterNew.this.addConfigChild(sequence, c));
                log.trace("Done creating XSD group [{}] on behalf of FrankElement [{}]", () -> groupName, () -> frankElement.getFullName());
            }

            @Override
            public void addCumulativeGroup() {
                this.cumulativeGroupName = DocWriterNew.xsdCumulativeGroupNameForChildren(frankElement);
                log.trace("Start creating XSD group [{}]", (Object)this.cumulativeGroupName);
                XmlBuilder group = DocWriterNewXmlUtils.createGroup(this.cumulativeGroupName);
                DocWriterNew.this.xsdComplexItems.add(group);
                this.cumulativeBuilder = DocWriterNewXmlUtils.addSequence(group);
            }

            @Override
            public void handleSelectedChildren(List<ConfigChild> children, FrankElement owner) {
                log.trace("Appending some of the config children of FrankElement [{}] to XSD group [{}]", () -> owner.getFullName(), () -> this.cumulativeGroupName);
                children.forEach(c -> DocWriterNew.this.addConfigChild(this.cumulativeBuilder, c));
            }

            @Override
            public void handleSelectedChildrenOfTopLevel(List<ConfigChild> children, FrankElement owner) {
                this.handleSelectedChildren(children, owner);
            }

            @Override
            public void handleChildrenOf(FrankElement elem) {
                String referencedGroupName = DocWriterNew.xsdDeclaredGroupNameForChildren(elem);
                log.trace("Appending XSD group [{}] with reference to [{}]", () -> this.cumulativeGroupName, () -> referencedGroupName);
                DocWriterNewXmlUtils.addGroupRef(this.cumulativeBuilder, referencedGroupName);
            }

            @Override
            public void handleCumulativeChildrenOf(FrankElement elem) {
                String referencedGroupName = DocWriterNew.xsdCumulativeGroupNameForChildren(elem);
                log.trace("Appending XSD group [{}] with reference to [{}]", () -> this.cumulativeGroupName, () -> referencedGroupName);
                DocWriterNewXmlUtils.addGroupRef(this.cumulativeBuilder, referencedGroupName);
            }
        }).run();
    }

    private void addConfigChild(XmlBuilder context, ConfigChild child) {
        log.trace("Adding config child [{}]", () -> child.toString());
        this.version.checkForMissingDescription(child);
        if (child instanceof ObjectConfigChild) {
            this.addObjectConfigChild(context, (ObjectConfigChild)child);
        } else if (child instanceof TextConfigChild) {
            this.addTextConfigChild(context, (TextConfigChild)child);
        } else {
            throw new IllegalArgumentException("Cannot happen, there are no other ConfigChild subclasses than ObjectConfigChild or TextConfigChild");
        }
        log.trace("Done adding config child [{}]", () -> child.toString());
    }

    private void addObjectConfigChild(XmlBuilder context, ObjectConfigChild child) {
        ElementRole theRole = this.model.findElementRole(child);
        if (this.isNoElementTypeNeeded(theRole)) {
            this.addConfigChildSingleReferredElement(context, child);
        } else {
            this.addConfigChildWithElementGroup(context, child);
        }
    }

    private boolean isNoElementTypeNeeded(ElementRole role) {
        ElementType elementType = role.getElementType();
        return !elementType.isFromJavaInterface();
    }

    private void addConfigChildSingleReferredElement(XmlBuilder context, ObjectConfigChild child) {
        ElementRole role = this.model.findElementRole(child);
        FrankElement elementInType = this.singleElementOf(role);
        if (elementInType == null) {
            log.trace("Omitting config child [{}] because of name conflict", () -> child.toString());
            return;
        }
        String referredXsdElementName = elementInType.getXsdElementName(role);
        log.trace("Config child appears as element reference to FrankElement [{}], XSD element [{}]", () -> elementInType.getFullName(), () -> referredXsdElementName);
        DocWriterNewXmlUtils.addElement(context, referredXsdElementName, this.getTypeName(referredXsdElementName), this.getMinOccurs(child), DocWriterNew.getMaxOccurs(child));
        this.recursivelyDefineSimpleFrankElementType(elementInType, role);
    }

    private FrankElement singleElementOf(ElementRole elementRole) {
        List<FrankElement> members = elementRole.getMembers();
        if (members.isEmpty()) {
            return null;
        }
        return members.iterator().next();
    }

    private void recursivelyDefineSimpleFrankElementType(FrankElement frankElement, ElementRole role) {
        log.trace("FrankElement [{}] is needed in XML Schema", () -> frankElement.getFullName());
        if (this.checkNotDefined(frankElement)) {
            log.trace("Not yet defined in XML Schema, going to define a type for it without reusable config children or attribute groups");
            String xsdElementName = frankElement.getXsdElementName(role);
            XmlBuilder attributeBuilder = this.recursivelyDefineSimpleFrankElementTypeUnchecked(frankElement, this.getTypeName(xsdElementName));
            log.trace("Adding attribute [{}] for FrankElement [{}]", () -> ELEMENT_ROLE, () -> frankElement.getFullName());
            XmlBuilder attributeElementRole = DocWriterNewXmlUtils.createAttribute(ELEMENT_ROLE, DocWriterNewXmlUtils.AttributeValueStatus.FIXED, role.getRoleName(), this.version.getRoleNameAttributeUse());
            this.attributeReuseManager.addAttribute(attributeElementRole, attributeBuilder);
            log.trace("Adding any attribute in another namespace to FrankElement [{}]", () -> frankElement.getFullName());
            XmlBuilder anyOther = DocWriterNewXmlUtils.createAnyOtherNamespaceAttribute();
            this.attributeReuseManager.addAttribute(anyOther, attributeBuilder);
            log.trace("Done defining type for FrankElement [{}], XSD element [{}]", () -> frankElement.getFullName(), () -> xsdElementName);
        } else {
            log.trace("Already defined in XML Schema");
        }
    }

    private XmlBuilder addConfigChildWithElementGroup(XmlBuilder context, ObjectConfigChild child) {
        log.trace("Config child appears as element group reference");
        ConfigChildSet configChildSet = child.getOwningElement().getConfigChildSet(child.getRoleName());
        if (log.isTraceEnabled()) {
            ThreadContext.push(String.format("Owning element [%s], ConfigChildSet [%s]", child.getOwningElement().getSimpleName(), configChildSet.toString()));
        }
        List<ElementRole> roles = configChildSet.getFilteredElementRoles(this.version.getChildSelector(), this.version.getChildRejector());
        this.requestElementGroupForConfigChildSet(configChildSet, roles);
        if (log.isTraceEnabled()) {
            ThreadContext.pop();
        }
        return DocWriterNewXmlUtils.addGroupRef(context, this.elementGroupManager.getGroupName(roles), this.getMinOccurs(child), DocWriterNew.getMaxOccurs(child));
    }

    private void requestElementGroupForConfigChildSet(ConfigChildSet configChildSet, List<ElementRole> roles) {
        this.requestElementGroup(roles);
        log.trace("Checking whether generic element option has its attributes");
        if (this.elementGroupManager.hasGenericOptionAttributeTask(configChildSet)) {
            log.trace("Finishing generic element option with its attributes");
            XmlBuilder builder = this.elementGroupManager.doGenericOptionAttributeTask(configChildSet);
            this.addGenericElementOptionAttributes(builder, configChildSet);
        } else {
            log.trace("Generic element option already has its attributes");
        }
        log.trace("Done with generic element option attributes");
    }

    private void requestElementGroup(List<ElementRole> roles) {
        log.trace("Doing requestElementGroup");
        Set<ElementRole.Key> key = ConfigChildSet.getKey(roles);
        log.trace("Element group needed for ElementRole-s [{}]", () -> ElementRole.Key.describeCollection(key));
        if (!this.elementGroupManager.groupExists(key)) {
            log.trace("Element group does not exist, creating it");
            String groupName = this.elementGroupManager.addGroup(key);
            XmlBuilder group = DocWriterNewXmlUtils.createGroup(groupName);
            this.xsdComplexItems.add(group);
            XmlBuilder choice = DocWriterNewXmlUtils.addChoice(group);
            this.addElementGroupGenericOption(choice, roles);
            this.addElementGroupOptions(choice, roles);
        } else {
            log.trace("Element group already exists");
        }
        log.trace("Done requestElementGroup");
    }

    private void addElementGroupOptions(XmlBuilder context, List<ElementRole> roles) {
        for (ElementRole role : roles) {
            if (this.isNoElementTypeNeeded(role)) {
                log.trace("ElementRole [{}] is not interface-based, nothing to do for this role", () -> role.toString());
                continue;
            }
            String groupName = role.createXsdElementName(ELEMENT_GROUP_BASE);
            log.trace("Adding group [{}] of role [{}] to element group", () -> groupName, () -> role.toString());
            DocWriterNewXmlUtils.addGroupRef(context, groupName);
            if (!this.idsCreatedElementGroups.contains(role.getKey())) {
                this.idsCreatedElementGroups.add(role.getKey());
                log.trace("Creating group [{}] for role [{}]", () -> groupName, () -> role.toString());
                this.defineElementGroupBaseUnchecked(role);
                log.trace("Done creating group [{}] for role [{}]", () -> groupName, () -> role.toString());
                continue;
            }
            log.trace("Group [{}] of role [{}] exists, no need to create it again", () -> groupName, () -> role.toString());
        }
    }

    private void defineElementGroupBaseUnchecked(ElementRole role) {
        XmlBuilder group = DocWriterNewXmlUtils.createGroup(role.createXsdElementName(ELEMENT_GROUP_BASE));
        this.xsdComplexItems.add(group);
        XmlBuilder choice = DocWriterNewXmlUtils.addChoice(group);
        List frankElementOptions = role.getMembers().stream().filter(this.version.getElementFilter()).filter(f -> f != role.getDefaultElementOptionConflict()).collect(Collectors.toList());
        for (FrankElement frankElement : frankElementOptions) {
            log.trace("Append ElementGroup with FrankElement [{}]", () -> frankElement.getFullName());
            this.addElementToElementGroup(choice, frankElement, role);
        }
    }

    private void addElementToElementGroup(XmlBuilder context, FrankElement frankElement, ElementRole role) {
        String referredXsdElementName = frankElement.getXsdElementName(role);
        if (this.isNoElementTypeNeeded(role)) {
            log.error("Expected ElementRole [{}] to be interface-based", (Object)role.toString());
        } else {
            log.trace("FrankElement [{}] in role [{}] appears as type reference, XSD element [{}]", () -> frankElement.getFullName(), () -> role.toString(), () -> referredXsdElementName);
            this.addElementTypeRefToElementGroup(context, frankElement, role);
            this.recursivelyDefineReusableFrankElementType(frankElement);
        }
    }

    private void addElementTypeRefToElementGroup(XmlBuilder context, FrankElement frankElement, ElementRole role) {
        XmlBuilder element = DocWriterNewXmlUtils.addElementWithType(context, frankElement.getXsdElementName(role));
        this.addDocumentationFrom(element, frankElement);
        XmlBuilder complexType = DocWriterNewXmlUtils.addComplexType(element);
        XmlBuilder complexContent = DocWriterNewXmlUtils.addComplexContent(complexType);
        XmlBuilder extension = DocWriterNewXmlUtils.addExtension(complexContent, this.xsdElementType(frankElement));
        log.trace("Adding attribute [{}] for FrankElement [{}]", () -> ELEMENT_ROLE, () -> frankElement.getFullName());
        XmlBuilder attributeElementRole = DocWriterNewXmlUtils.createAttribute(ELEMENT_ROLE, DocWriterNewXmlUtils.AttributeValueStatus.FIXED, role.getRoleName(), this.version.getRoleNameAttributeUse());
        this.attributeReuseManager.addAttribute(attributeElementRole, extension);
    }

    private void addDocumentationFrom(XmlBuilder element, FrankElement frankElement) {
        String elementDescription;
        if (this.version == XsdVersion.STRICT && !StringUtils.isBlank(elementDescription = frankElement.getDescription())) {
            DocWriterNewXmlUtils.addDocumentation(element, elementDescription);
        }
    }

    private void addElementGroupGenericOption(XmlBuilder context, List<ElementRole> roles) {
        log.trace("Doing the generic element option, role group [{}]", () -> ElementRole.describeCollection(roles));
        String roleName = ElementGroupManager.getRoleName(roles);
        XmlBuilder genericElementOption = DocWriterNewXmlUtils.addElementWithType(context, Utils.toUpperCamelCase(roleName));
        XmlBuilder complexType = DocWriterNewXmlUtils.addComplexType(genericElementOption);
        this.fillGenericOption(complexType, roles);
        this.elementGroupManager.addGenericOptionAttributeTask(roles, complexType);
        log.trace("Done with the generic element option, role group [{}]", () -> ElementRole.describeCollection(roles));
    }

    private void addGenericElementOptionAttributes(XmlBuilder complexType, ConfigChildSet configChildSet) {
        log.trace("Enter for ConfigChildSet [{}]", () -> configChildSet.toString());
        log.trace("Adding attribute [{}] to generic element option", (Object)"active");
        XmlBuilder attributeActive = AttributeTypeStrategy.createAttributeActive();
        this.attributeReuseManager.addAttribute(attributeActive, complexType);
        log.trace("Adding attribute [{}] to generic element option", (Object)ELEMENT_ROLE);
        XmlBuilder attributeElementRole = DocWriterNewXmlUtils.createAttribute(ELEMENT_ROLE, DocWriterNewXmlUtils.AttributeValueStatus.FIXED, configChildSet.getRoleName(), this.version.getRoleNameAttributeUse());
        this.attributeReuseManager.addAttribute(attributeElementRole, complexType);
        Optional<String> defaultFrankElementName = configChildSet.getGenericElementOptionDefault(this.version.getElementFilter());
        XmlBuilder attributeClassName = null;
        if (defaultFrankElementName.isPresent()) {
            log.trace("Adding attribute [{}] with default [{}]", () -> CLASS_NAME, () -> (String)defaultFrankElementName.get());
            attributeClassName = DocWriterNewXmlUtils.createAttribute(CLASS_NAME, DocWriterNewXmlUtils.AttributeValueStatus.DEFAULT, defaultFrankElementName.get(), DocWriterNewXmlUtils.AttributeUse.OPTIONAL);
        } else {
            log.trace("Adding attribute [{}] without default", () -> CLASS_NAME);
            attributeClassName = DocWriterNewXmlUtils.createAttribute(CLASS_NAME, DocWriterNewXmlUtils.AttributeValueStatus.DEFAULT, null, DocWriterNewXmlUtils.AttributeUse.REQUIRED);
        }
        this.attributeReuseManager.addAttribute(attributeClassName, complexType);
        log.trace("Adding any attribute in another namespace");
        XmlBuilder anyAttribute = DocWriterNewXmlUtils.createAnyAttribute();
        this.attributeReuseManager.addAttribute(anyAttribute, complexType);
    }

    private void finishLeftoverGenericOptionsAttributes() {
        log.trace("Setting attributes of leftover nested generic elements");
        for (GenericOptionAttributeTask task : this.elementGroupManager.doLeftoverGenericOptionAttributeTasks()) {
            log.trace("Have to do element group [{}]", () -> task.getRolesKey().toString());
            this.addGenericElementOptionAttributes(task.getBuilder(), task.getRolesKey().iterator().next().getRoleName());
        }
        log.trace("Done setting attributes of leftover nested generic elements");
    }

    private void addGenericElementOptionAttributes(XmlBuilder complexType, String roleName) {
        XmlBuilder attributeElementRole = DocWriterNewXmlUtils.createAttribute(ELEMENT_ROLE, DocWriterNewXmlUtils.AttributeValueStatus.FIXED, roleName, this.version.getRoleNameAttributeUse());
        this.attributeReuseManager.addAttribute(attributeElementRole, complexType);
        XmlBuilder attributeClassName = DocWriterNewXmlUtils.createAttribute(CLASS_NAME, DocWriterNewXmlUtils.AttributeValueStatus.DEFAULT, null, DocWriterNewXmlUtils.AttributeUse.REQUIRED);
        this.attributeReuseManager.addAttribute(attributeClassName, complexType);
        XmlBuilder anyAttribute = DocWriterNewXmlUtils.createAnyAttribute();
        this.attributeReuseManager.addAttribute(anyAttribute, complexType);
    }

    private void fillGenericOption(XmlBuilder context, List<ElementRole> parents) {
        Map<String, List<ConfigChild>> memberChildrenByRoleName = ConfigChildSet.getMemberChildren(parents, this.version.getChildSelector(), this.version.getChildRejector(), this.version.getElementFilter());
        ArrayList<String> names = new ArrayList<String>(memberChildrenByRoleName.keySet());
        Collections.sort(names);
        XmlBuilder choice = null;
        for (String name : names) {
            if (choice == null) {
                XmlBuilder sequence = DocWriterNewXmlUtils.addSequence(context);
                choice = DocWriterNewXmlUtils.addChoice(sequence, "0", "unbounded");
            }
            this.addConfigChildrenOfRoleNameToGenericOption(choice, memberChildrenByRoleName.get(name));
        }
    }

    private void addConfigChildrenOfRoleNameToGenericOption(XmlBuilder context, List<ConfigChild> configChildren) {
        String roleName = configChildren.get(0).getRoleName();
        switch (ConfigChildGroupKind.groupKind(configChildren)) {
            case TEXT: {
                this.addTextConfigChildToGenericOption(context, roleName);
                break;
            }
            case MIXED: {
                log.error("Encountered group of config children that mixes TextConfigChild and ObjectConfigChild, not supported: [{}]", (Object)ConfigChild.toString(configChildren));
            }
            case OBJECT: {
                this.addObjectConfigChildrenToGenericOption(context, configChildren);
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not come here because switch should cover all enum values");
            }
        }
    }

    private void addObjectConfigChildrenToGenericOption(XmlBuilder context, List<ConfigChild> configChildren) {
        String roleName = configChildren.get(0).getRoleName();
        List<ElementRole> childRoles = ElementRole.promoteIfConflict(ConfigChild.getElementRoleStream(configChildren).collect(Collectors.toList()));
        if (childRoles.size() == 1 && this.isNoElementTypeNeeded(childRoles.get(0))) {
            log.trace("A single ElementRole [{}] that appears as element reference", () -> ((ElementRole)childRoles.get(0)).toString());
            this.addElementRoleAsElement(context, childRoles.get(0));
        } else {
            if (log.isTraceEnabled()) {
                ThreadContext.push(String.format("nest [%s]", roleName));
            }
            this.requestElementGroup(childRoles);
            if (log.isTraceEnabled()) {
                ThreadContext.pop();
            }
            DocWriterNewXmlUtils.addGroupRef(context, this.elementGroupManager.getGroupName(childRoles));
        }
    }

    private void addElementRoleAsElement(XmlBuilder context, ElementRole elementRole) {
        FrankElement elementInType = this.singleElementOf(elementRole);
        if (elementInType == null) {
            log.trace("Omitting ElementRole [{}] from group because of conflict", () -> elementRole.toString());
            return;
        }
        String referredXsdElementName = elementInType.getXsdElementName(elementRole);
        DocWriterNewXmlUtils.addElement(context, referredXsdElementName, this.getTypeName(referredXsdElementName));
        this.recursivelyDefineSimpleFrankElementType(elementInType, elementRole);
    }

    private void addTextConfigChild(XmlBuilder context, TextConfigChild child) {
        DocWriterNewXmlUtils.addElement(context, Utils.toUpperCamelCase(child.getRoleName()), "xs:string", this.getMinOccurs(child), DocWriterNew.getMaxOccurs(child));
    }

    private void addTextConfigChildToGenericOption(XmlBuilder context, String roleName) {
        DocWriterNewXmlUtils.addElement(context, Utils.toUpperCamelCase(roleName), "xs:string", "0", "unbounded");
    }

    private void addReferencedEntityRootChildIfApplicable(XmlBuilder context, FrankElement declaredGroupOwner) {
        if (this.version == XsdVersion.STRICT && declaredGroupOwner.getFullName().equals(this.model.getRootClassName())) {
            log.trace("Adding referenced entity file root [{}] as config child", (Object)"Module");
            DocWriterNewXmlUtils.addElementRef(context, "Module", "0", "unbounded");
        }
    }

    void addConfigChildrenWithPluralConfigChildSets(ElementBuildingStrategy elementBuildingStrategy, FrankElement frankElement) {
        log.trace("Applying algorithm for plural config children for FrankElement [{}]", () -> frankElement.getFullName());
        if (!frankElement.hasFilledConfigChildSets(this.version.getChildSelector(), this.version.getChildRejector())) {
            FrankElement ancestor = frankElement.getNextPluralConfigChildrenAncestor(this.version.getChildSelector(), this.version.getChildRejector());
            log.trace("No config children, inheriting from [{}]", () -> ancestor.getFullName());
            elementBuildingStrategy.addThePluralConfigChildGroup(DocWriterNew.xsdPluralGroupNameForChildren(ancestor));
        } else {
            log.trace("Adding new group for plural config children for FrankElement [{}]", () -> frankElement.getFullName());
            this.addConfigChildrenWithPluralConfigChildSetsUnchecked(elementBuildingStrategy, frankElement);
        }
        log.trace("Done applying algorithm for plural config children for FrankElement [{}]", () -> frankElement.getFullName());
    }

    private void addConfigChildrenWithPluralConfigChildSetsUnchecked(ElementBuildingStrategy elementBuildingStrategy, FrankElement frankElement) {
        String groupName = DocWriterNew.xsdPluralGroupNameForChildren(frankElement);
        elementBuildingStrategy.addThePluralConfigChildGroup(groupName);
        XmlBuilder builder = DocWriterNewXmlUtils.createGroup(groupName);
        this.xsdComplexItems.add(builder);
        XmlBuilder sequence = DocWriterNewXmlUtils.addSequence(builder);
        XmlBuilder choice = DocWriterNewXmlUtils.addChoice(sequence, "0", "unbounded");
        this.addReferencedEntityRootChildIfApplicable(choice, frankElement);
        List<ConfigChildSet> configChildSets = frankElement.getCumulativeConfigChildSets();
        for (ConfigChildSet configChildSet : configChildSets) {
            this.addPluralConfigChild(choice, configChildSet, frankElement);
        }
    }

    private void addPluralConfigChild(XmlBuilder choice, ConfigChildSet configChildSet, FrankElement frankElement) {
        if (log.isTraceEnabled()) {
            log.trace("Adding ConfigChildSet [{}]", () -> configChildSet.toString());
            ThreadContext.push(String.format("Owning element [%s], ConfigChildSet [%s]", frankElement.getSimpleName(), configChildSet.toString()));
        }
        configChildSet.getConfigChildren().forEach(this.version::checkForMissingDescription);
        switch (configChildSet.getConfigChildGroupKind()) {
            case MIXED: 
            case OBJECT: {
                this.addPluralObjectConfigChild(choice, configChildSet);
                break;
            }
            case TEXT: {
                this.addPluralTextConfigChild(choice, configChildSet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot happen, switch should cover all enum values");
            }
        }
        if (log.isTraceEnabled()) {
            ThreadContext.pop();
            log.trace("Done adding ConfigChildSet with ElementRoleSet [{}]", () -> configChildSet.toString());
        }
    }

    private void addPluralObjectConfigChild(XmlBuilder choice, ConfigChildSet configChildSet) {
        List<ElementRole> roles = configChildSet.getFilteredElementRoles(this.version.getChildSelector(), this.version.getChildRejector());
        if (roles.size() == 1 && this.isNoElementTypeNeeded(roles.get(0))) {
            log.trace("Config child set appears as element reference");
            this.addElementRoleAsElement(choice, roles.get(0));
        } else {
            log.trace("Config child set appears as group reference");
            this.requestElementGroupForConfigChildSet(configChildSet, roles);
            DocWriterNewXmlUtils.addGroupRef(choice, this.elementGroupManager.getGroupName(roles));
        }
    }

    private void addPluralTextConfigChild(XmlBuilder choice, ConfigChildSet configChildSet) {
        DocWriterNewXmlUtils.addElement(choice, Utils.toUpperCamelCase(configChildSet.getRoleName()), "xs:string", "0", "unbounded");
    }

    private void addAttributes(final ElementBuildingStrategy elementBuildingStrategy, final FrankElement frankElement) {
        Consumer cumulativeGroupTrigger = ca -> frankElement.walkCumulativeAttributes((CumulativeChildHandler<FrankAttribute>)ca, this.version.getChildSelector(), this.version.getChildRejector());
        new GroupCreator<FrankAttribute>(frankElement, this.version.getHasRelevantChildrenPredicate(FrankAttribute.class), cumulativeGroupTrigger, new GroupCreator.Callback<FrankAttribute>(){
            private XmlBuilder cumulativeBuilder;
            private String cumulativeGroupName;

            @Override
            public void noChildren() {
                elementBuildingStrategy.onNoAttributes();
            }

            @Override
            public void addDeclaredGroupRef(FrankElement referee) {
                elementBuildingStrategy.addAttributeGroupRef(DocWriterNew.xsdDeclaredGroupNameForAttributes(referee));
            }

            @Override
            public void addCumulativeGroupRef(FrankElement referee) {
                elementBuildingStrategy.addAttributeGroupRef(DocWriterNew.xsdCumulativeGroupNameForAttributes(referee));
            }

            @Override
            public void addTopLevelDeclaredGroup() {
                XmlBuilder attributeGroup = this.commonAddAttributeGroup();
                log.trace("Adding attribute active");
                XmlBuilder attributeActive = AttributeTypeStrategy.createAttributeActive();
                DocWriterNew.this.attributeReuseManager.addAttribute(attributeActive, attributeGroup);
                log.trace("Adding any attribute in another namespace");
                XmlBuilder anyOther = DocWriterNewXmlUtils.createAnyOtherNamespaceAttribute();
                DocWriterNew.this.attributeReuseManager.addAttribute(anyOther, attributeGroup);
            }

            @Override
            public void addDeclaredGroup() {
                this.commonAddAttributeGroup();
            }

            private XmlBuilder commonAddAttributeGroup() {
                String groupName = DocWriterNew.xsdDeclaredGroupNameForAttributes(frankElement);
                log.trace("Creating XSD group [{}]", (Object)groupName);
                XmlBuilder attributeGroup = DocWriterNewXmlUtils.createAttributeGroup(groupName);
                DocWriterNew.this.xsdComplexItems.add(attributeGroup);
                DocWriterNew.this.addAttributeList(attributeGroup, frankElement.getAttributes(DocWriterNew.this.version.getChildSelector()), groupName);
                log.trace("Done creating XSD group [{}] on behalf of FrankElement [{}]", () -> groupName, () -> frankElement.getFullName());
                return attributeGroup;
            }

            @Override
            public void addCumulativeGroup() {
                this.cumulativeGroupName = DocWriterNew.xsdCumulativeGroupNameForAttributes(frankElement);
                log.trace("Start creating XSD group [{}]", (Object)this.cumulativeGroupName);
                this.cumulativeBuilder = DocWriterNewXmlUtils.createAttributeGroup(this.cumulativeGroupName);
                DocWriterNew.this.xsdComplexItems.add(this.cumulativeBuilder);
            }

            @Override
            public void handleSelectedChildren(List<FrankAttribute> children, FrankElement owner) {
                log.trace("Appending some of the attributes of FrankElement [{}] to XSD group [{}]", () -> owner.getFullName(), () -> this.cumulativeGroupName);
                DocWriterNew.this.addAttributeList(this.cumulativeBuilder, children, this.cumulativeGroupName);
            }

            @Override
            public void handleSelectedChildrenOfTopLevel(List<FrankAttribute> children, FrankElement owner) {
                this.handleSelectedChildren(children, owner);
                log.trace("Adding attribute active because [{}] has no ancestors with children", () -> owner.getFullName());
                XmlBuilder attributeActive = AttributeTypeStrategy.createAttributeActive();
                DocWriterNew.this.attributeReuseManager.addAttribute(attributeActive, this.cumulativeBuilder);
                log.trace("Adding any attribute in another namespace");
                XmlBuilder anyAttribute = DocWriterNewXmlUtils.createAnyOtherNamespaceAttribute();
                DocWriterNew.this.attributeReuseManager.addAttribute(anyAttribute, this.cumulativeBuilder);
            }

            @Override
            public void handleChildrenOf(FrankElement elem) {
                String referencedGroupName = DocWriterNew.xsdDeclaredGroupNameForAttributes(elem);
                log.trace("Appending XSD group [{}] with reference to [{}]", (Object)this.cumulativeGroupName, (Object)referencedGroupName);
                XmlBuilder builder = DocWriterNewXmlUtils.createAttributeGroupRef(referencedGroupName);
                DocWriterNew.this.attributeReuseManager.addAttribute(builder, this.cumulativeBuilder);
            }

            @Override
            public void handleCumulativeChildrenOf(FrankElement elem) {
                String referencedGroupName = DocWriterNew.xsdCumulativeGroupNameForAttributes(elem);
                log.trace("Appending XSD group [{}] with reference to [{}]", (Object)this.cumulativeGroupName, (Object)referencedGroupName);
                XmlBuilder builder = DocWriterNewXmlUtils.createAttributeGroupRef(referencedGroupName);
                DocWriterNew.this.attributeReuseManager.addAttribute(builder, this.cumulativeBuilder);
            }
        }).run();
    }

    private void addAttributeList(XmlBuilder context, List<FrankAttribute> frankAttributes, String groupName) {
        frankAttributes.forEach(this.version::checkForMissingDescription);
        for (FrankAttribute frankAttribute : frankAttributes) {
            log.trace("Group [{}] has attribute [{}], will decide later whether to add it inline or to reuse it", () -> groupName, () -> frankAttribute.getName());
            this.attributeReuseManager.addAttribute(frankAttribute, context, groupName);
        }
    }

    @Override
    public void addAttributeInline(FrankAttribute attribute, XmlBuilder group, String targetName) {
        log.trace("Attribute [{}] in FrankElement [{}] for group [{}] is inline", () -> attribute.toString(), () -> attribute.getOwningElement().toString(), () -> targetName);
        XmlBuilder attributeBuilder = this.createAttribute(attribute);
        if (this.version.childIsMandatory(attribute)) {
            log.trace("It is mandatory, adding \"use=required\"");
            attributeBuilder.addAttribute("use", "required");
        }
        group.addSubElement(attributeBuilder);
    }

    @Override
    public void addReusableAttribute(FrankAttribute attribute) {
        log.trace("Attribute [{}] of FrankElement [{}] is reused, creating it for reference from elsewhere", (Object)attribute.toString(), (Object)attribute.getOwningElement().toString());
        this.xsdReusedAttributes.add(this.createAttribute(attribute));
    }

    @Override
    public void addReusedAttributeReference(FrankAttribute attribute, XmlBuilder group, String targetName) {
        log.trace("Reference reused attribute [{}] of FrankElement [{}] for group [{}]", () -> attribute.toString(), () -> attribute.getOwningElement().toString(), () -> targetName);
        XmlBuilder attributeBuilder = DocWriterNewXmlUtils.createAttributeRef(attribute.getName());
        if (this.version.childIsMandatory(attribute)) {
            log.trace("It is mandatory, adding \"use=required\" with the reference, not the referee");
            attributeBuilder.addAttribute("use", "required");
        }
        group.addSubElement(attributeBuilder);
    }

    private XmlBuilder createAttribute(FrankAttribute frankAttribute) {
        XmlBuilder attribute = null;
        if (frankAttribute.getAttributeEnum() == null) {
            attribute = this.attributeTypeStrategy.createAttribute(frankAttribute.getName(), frankAttribute.getAttributeType());
            this.documentAttributeIfNeeded(frankAttribute, attribute);
        } else {
            log.trace("Attribute is restricted by enum [{}]", (Object)frankAttribute.getAttributeEnum().getFullName());
            attribute = this.createRestrictedAttribute(frankAttribute, a -> this.documentAttributeIfNeeded(frankAttribute, (XmlBuilder)a));
        }
        return attribute;
    }

    private void documentAttributeIfNeeded(FrankAttribute frankAttribute, XmlBuilder attributeBuilder) {
        if (this.needsDocumentation(frankAttribute)) {
            log.trace("Attribute has documentation");
            DocWriterNewXmlUtils.addDocumentation(attributeBuilder, this.getDocumentationText(frankAttribute));
        }
    }

    private XmlBuilder createRestrictedAttribute(FrankAttribute attribute, Consumer<XmlBuilder> documenter) {
        XmlBuilder result = this.attributeTypeStrategy.createRestrictedAttribute(attribute, documenter);
        AttributeEnum attributeEnum = attribute.getAttributeEnum();
        if (!this.definedAttributeEnumInstances.contains(attributeEnum.getFullName())) {
            log.trace("Defining type for the values of enum [{}]", (Object)attributeEnum.getFullName());
            this.definedAttributeEnumInstances.add(attributeEnum.getFullName());
            this.xsdComplexItems.add(this.attributeTypeStrategy.createAttributeEnumType(attributeEnum));
        }
        return result;
    }

    private boolean needsDocumentation(ElementChild elementChild) {
        return !StringUtils.isEmpty(elementChild.getDescription()) || !StringUtils.isEmpty(elementChild.getDefaultValue());
    }

    private String getDocumentationText(ElementChild elementChild) {
        StringBuilder result = new StringBuilder();
        if (!StringUtils.isEmpty(elementChild.getDescription())) {
            result.append(elementChild.getDescription());
        }
        if (!StringUtils.isEmpty(elementChild.getDefaultValue())) {
            if (result.length() >= 1) {
                result.append(" ");
            }
            result.append("Default: ");
            result.append(elementChild.getDefaultValue());
        }
        return result.toString();
    }

    private String xsdElementType(FrankElement frankElement) {
        return frankElement.getTypeNameBase() + "Type";
    }

    private static String xsdDeclaredGroupNameForChildren(FrankElement element) {
        return element.getTypeNameBase() + "DeclaredChildGroup";
    }

    private static String xsdCumulativeGroupNameForChildren(FrankElement element) {
        return element.getTypeNameBase() + "CumulativeChildGroup";
    }

    private static String xsdPluralGroupNameForChildren(FrankElement element) {
        return element.getTypeNameBase() + "PluralConfigChildGroup";
    }

    private static String xsdDeclaredGroupNameForAttributes(FrankElement element) {
        return element.getTypeNameBase() + "DeclaredAttributeGroup";
    }

    private static String xsdCumulativeGroupNameForAttributes(FrankElement element) {
        return element.getTypeNameBase() + "CumulativeAttributeGroup";
    }

    private String getMinOccurs(ConfigChild child) {
        if (this.version.childIsMandatory(child)) {
            return "1";
        }
        return "0";
    }

    private static String getMaxOccurs(ConfigChild child) {
        if (child.isAllowMultiple()) {
            return "unbounded";
        }
        return "1";
    }

    static {
        outputFileNames.put(XsdVersion.STRICT, "strict.xsd");
        outputFileNames.put(XsdVersion.COMPATIBILITY, "compatibility.xsd");
    }

    private class ElementOmitter
    extends ElementBuildingStrategy {
        private ElementOmitter() {
        }

        @Override
        void onNoAttributes() {
        }

        @Override
        boolean needsSpecialAttributesInElementType() {
            return false;
        }

        @Override
        XmlBuilder getElementTypeBuilder() {
            return null;
        }

        @Override
        void addGroupRef(String referencedGroupName) {
        }

        @Override
        void addAttributeGroupRef(String referencedGroupName) {
        }

        @Override
        void addThePluralConfigChildGroup(String referencedGroupName) {
        }
    }

    private class ElementAdder
    extends ElementBuildingStrategy {
        private final XmlBuilder elementTypeBuilder;
        private XmlBuilder configChildBuilder;
        private final FrankElement addingTo;
        private boolean noAttributes;

        ElementAdder(FrankElement frankElement) {
            this.noAttributes = false;
            this.elementTypeBuilder = DocWriterNewXmlUtils.createComplexType(DocWriterNew.this.xsdElementType(frankElement));
            DocWriterNew.this.xsdComplexItems.add(this.elementTypeBuilder);
            this.addingTo = frankElement;
        }

        @Override
        void onNoAttributes() {
            this.noAttributes = true;
        }

        @Override
        boolean needsSpecialAttributesInElementType() {
            return this.noAttributes;
        }

        @Override
        XmlBuilder getElementTypeBuilder() {
            return this.elementTypeBuilder;
        }

        @Override
        void addGroupRef(String referencedGroupName) {
            log.trace("Appending XSD type def of [{}] with reference to XSD group [{}]", () -> this.addingTo.getFullName(), () -> referencedGroupName);
            if (this.configChildBuilder == null) {
                log.trace("Create <sequence><choice> to wrap the config children in");
                this.configChildBuilder = DocWriterNew.this.version.configChildBuilder(this.elementTypeBuilder);
            } else {
                log.trace("Already have <sequence><choice> for the config children");
            }
            DocWriterNewXmlUtils.addGroupRef(this.configChildBuilder, referencedGroupName);
        }

        @Override
        void addAttributeGroupRef(String referencedGroupName) {
            log.trace("Appending XSD type def of [{}] with reference to XSD group [{}]", () -> this.addingTo.getFullName(), () -> referencedGroupName);
            XmlBuilder builder = DocWriterNewXmlUtils.createAttributeGroupRef(referencedGroupName);
            DocWriterNew.this.attributeReuseManager.addAttribute(builder, this.elementTypeBuilder);
        }

        @Override
        void addThePluralConfigChildGroup(String referencedGroupName) {
            log.trace("Appending XSD type def of [{}] with reference to XSD group [{}], without adding <sequence><choice>", () -> this.addingTo.getFullName(), () -> referencedGroupName);
            DocWriterNewXmlUtils.addGroupRef(this.elementTypeBuilder, referencedGroupName);
        }
    }

    private abstract class ElementBuildingStrategy {
        private ElementBuildingStrategy() {
        }

        abstract void onNoAttributes();

        abstract boolean needsSpecialAttributesInElementType();

        abstract XmlBuilder getElementTypeBuilder();

        abstract void addGroupRef(String var1);

        abstract void addAttributeGroupRef(String var1);

        abstract void addThePluralConfigChildGroup(String var1);
    }
}

