/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.frankframework.frankdoc.GenericOptionAttributeTask;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.ConfigChildSet;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.util.XmlBuilder;

class ElementGroupManager {
    private static final String ELEMENT_GROUP = "ElementGroup";
    private final Map<Set<ElementRole.Key>, Integer> genericGroupKeyToSeq = new HashMap<Set<ElementRole.Key>, Integer>();
    private final Map<Set<ElementRole.Key>, GenericOptionAttributeTask> genericOptionAttributeTasks = new LinkedHashMap<Set<ElementRole.Key>, GenericOptionAttributeTask>();
    private final Predicate<ElementChild> childSelector;
    private final Predicate<ElementChild> childRejector;

    ElementGroupManager(Predicate<ElementChild> childSelector, Predicate<ElementChild> childRejector) {
        this.childSelector = childSelector;
        this.childRejector = childRejector;
    }

    boolean groupExists(Set<ElementRole.Key> key) {
        return this.genericGroupKeyToSeq.containsKey(key);
    }

    private Set<ElementRole.Key> keyOf(ConfigChildSet configChildSet) {
        return ConfigChildSet.getKey(configChildSet.getFilteredElementRoles(this.childSelector, this.childRejector));
    }

    String addGroup(Set<ElementRole.Key> key) {
        String roleName = this.getRoleName(key);
        List shared = this.genericGroupKeyToSeq.keySet().stream().filter(rs -> this.getRoleName((Set<ElementRole.Key>)rs).equals(roleName)).collect(Collectors.toList());
        int seq = shared.stream().map(this.genericGroupKeyToSeq::get).collect(Collectors.maxBy(Integer::compare)).orElse(0) + 1;
        this.genericGroupKeyToSeq.put(key, seq);
        return this.getGroupName(key, roleName);
    }

    static String getRoleName(List<ElementRole> roles) {
        return roles.get(0).getRoleName();
    }

    private String getRoleName(Set<ElementRole.Key> key) {
        return key.iterator().next().getRoleName();
    }

    String getGroupName(Set<ElementRole.Key> key) {
        String roleName = this.getRoleName(key);
        return this.getGroupName(key, roleName);
    }

    String getGroupName(List<ElementRole> roles) {
        Set<ElementRole.Key> key = ConfigChildSet.getKey(roles);
        String roleName = roles.iterator().next().getRoleName();
        return this.getGroupName(key, roleName);
    }

    private String getGroupName(Set<ElementRole.Key> key, String roleName) {
        return Utils.toUpperCamelCase(roleName) + ELEMENT_GROUP + ElementGroupManager.disambiguation(this.genericGroupKeyToSeq.get(key));
    }

    static String disambiguation(int seq) {
        String result = "";
        if (seq != 1) {
            result = String.format("_%d", seq);
        }
        return result;
    }

    void addGenericOptionAttributeTask(List<ElementRole> roles, XmlBuilder builder) {
        Set<ElementRole.Key> key = ConfigChildSet.getKey(roles);
        this.genericOptionAttributeTasks.put(key, new GenericOptionAttributeTask(key, builder));
    }

    boolean hasGenericOptionAttributeTask(ConfigChildSet configChildSet) {
        return this.genericOptionAttributeTasks.containsKey(this.keyOf(configChildSet));
    }

    XmlBuilder doGenericOptionAttributeTask(ConfigChildSet configChildSet) {
        return this.genericOptionAttributeTasks.remove(this.keyOf(configChildSet)).getBuilder();
    }

    List<GenericOptionAttributeTask> doLeftoverGenericOptionAttributeTasks() {
        ArrayList<GenericOptionAttributeTask> result = new ArrayList<GenericOptionAttributeTask>(this.genericOptionAttributeTasks.values());
        this.genericOptionAttributeTasks.clear();
        return result;
    }
}

