/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.frankframework.frankdoc.model.FrankDocModel;
import org.frankframework.frankdoc.model.FrankElement;

public class FrankDocElementSummaryFactory {
    private static final int MAX_NUM_PACKAGE_COMPONENTS_EXPECTED = 100;
    private FrankDocModel model;

    public FrankDocElementSummaryFactory(FrankDocModel model) {
        this.model = model;
    }

    public String getText() {
        HashMap<String, Integer> numComponentsMap = new HashMap<String, Integer>();
        Map<String, List<FrankElement>> elementsBySimpleName = this.model.getAllElements().values().stream().collect(Collectors.groupingBy(FrankElement::getSimpleName));
        for (String string : elementsBySimpleName.keySet()) {
            List<String> fullNames = elementsBySimpleName.get(string).stream().map(FrankElement::getFullName).collect(Collectors.toList());
            numComponentsMap.put(string, this.getNumComponentsForUnique(fullNames));
        }
        ArrayList<SummaryElement> summaryElements = new ArrayList<SummaryElement>();
        for (FrankElement frankElement : this.model.getAllElements().values()) {
            String simpleName = frankElement.getSimpleName();
            int numComponents = (Integer)numComponentsMap.get(simpleName);
            String label = this.getAbbreviation(frankElement.getFullName(), numComponents);
            String xmlElements = frankElement.getXmlElementNames().stream().collect(Collectors.joining(", "));
            summaryElements.add(new SummaryElement(label, xmlElements, frankElement.isAbstract()));
        }
        int n = (Integer)summaryElements.stream().map(se -> se.label).map(String::length).collect(Collectors.maxBy(Comparator.naturalOrder())).get();
        Map<String, SummaryElement> summaryElementsByLabel = summaryElements.stream().collect(Collectors.toMap(se -> se.label, se -> se));
        ArrayList<String> sortedLabels = new ArrayList<String>(summaryElementsByLabel.keySet());
        Collections.sort(sortedLabels);
        StringBuilder b = new StringBuilder();
        for (String label : sortedLabels) {
            SummaryElement e = summaryElementsByLabel.get(label);
            if (e.isAbstract) {
                b.append(String.format("%s: (abstract)\n", StringUtils.leftPad(label, n)));
                continue;
            }
            b.append(String.format("%s: %s\n", StringUtils.leftPad(label, n), e.xmlElements));
        }
        return b.toString();
    }

    private int getNumComponentsForUnique(List<String> fullNames) {
        int result = 0;
        while (result < 100) {
            int numComponents = result++;
            int numUnique = (int)fullNames.stream().map(n -> this.getAbbreviation((String)n, numComponents)).distinct().collect(Collectors.counting()).longValue();
            if (numUnique < fullNames.size()) continue;
            return result;
        }
        throw new IllegalArgumentException(String.format("Names are not unique: %s", fullNames.stream().collect(Collectors.joining(", "))));
    }

    private String getAbbreviation(String fullName, int numPackageComponents) {
        List<String> components = Arrays.asList(fullName.split("\\."));
        Collections.reverse(components);
        int stopAt = 0;
        while (Character.isUpperCase(components.get(stopAt).charAt(0))) {
            ++stopAt;
        }
        stopAt = Math.min(stopAt + numPackageComponents, components.size());
        ArrayList<String> result = new ArrayList<String>(components.subList(0, stopAt));
        String head = (String)result.get(0);
        ArrayList remainder = new ArrayList(result.subList(1, result.size()));
        Collections.reverse(remainder);
        if (remainder.isEmpty()) {
            return head;
        }
        return head + String.format(" (from %s)", remainder.stream().collect(Collectors.joining(".")));
    }

    static class SummaryElement {
        String label;
        String xmlElements;
        boolean isAbstract;

        SummaryElement(String label, String xmlElements, boolean isAbstract) {
            this.label = label;
            this.xmlElements = xmlElements;
            this.isAbstract = isAbstract;
        }
    }
}

