/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.AttributeEnum;
import org.frankframework.frankdoc.model.AttributeEnumValue;
import org.frankframework.frankdoc.model.AttributeType;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementType;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.model.FrankDocGroup;
import org.frankframework.frankdoc.model.FrankDocModel;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.MandatoryStatus;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.model.ParsedJavaDocTag;
import org.frankframework.frankdoc.util.LogUtil;

public class FrankDocJsonFactory {
    private static Logger log = LogUtil.getLogger(FrankDocJsonFactory.class);
    private static final String DESCRIPTION = "description";
    private FrankDocModel model;
    private JsonBuilderFactory bf;
    List<FrankElement> elementsOutsideChildren;
    private final String frankFrameworkVersion;

    public FrankDocJsonFactory(FrankDocModel model, String frankFrameworkVersion) {
        this.model = model;
        this.elementsOutsideChildren = new ArrayList<FrankElement>(model.getElementsOutsideConfigChildren());
        this.bf = Json.createBuilderFactory(null);
        this.frankFrameworkVersion = frankFrameworkVersion;
    }

    public JsonObject getJson() {
        try {
            JsonObjectBuilder result = this.bf.createObjectBuilder();
            if (this.frankFrameworkVersion != null) {
                result.add("metadata", this.getMetadata());
            }
            result.add("groups", this.getGroups());
            result.add("types", this.getTypes());
            result.add("elements", this.getElements());
            result.add("enums", this.getEnums());
            return result.build();
        }
        catch (JsonException e) {
            log.error("Error producing JSON", (Throwable)e);
            return null;
        }
    }

    private JsonObject getMetadata() {
        JsonObjectBuilder metadata = this.bf.createObjectBuilder();
        metadata.add("version", this.frankFrameworkVersion);
        return metadata.build();
    }

    private JsonArray getGroups() throws JsonException {
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        for (FrankDocGroup group : this.model.getGroups()) {
            result.add(this.getGroup(group));
        }
        return result.build();
    }

    private JsonObject getGroup(FrankDocGroup group) throws JsonException {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", group.getName());
        JsonArrayBuilder types = this.bf.createArrayBuilder();
        group.getElementTypes().stream().map(ElementType::getFullName).forEach(types::add);
        if (group.getName().equals(FrankDocGroup.GROUP_NAME_OTHER)) {
            this.elementsOutsideChildren.forEach(f -> types.add(f.getFullName()));
            types.add("Module");
        }
        result.add("types", types);
        return result.build();
    }

    private JsonArray getTypes() {
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        ArrayList<ElementType> sortedTypes = new ArrayList<ElementType>(this.model.getAllTypes().values());
        Collections.sort(sortedTypes);
        for (ElementType elementType : sortedTypes) {
            result.add(this.getType(elementType));
        }
        this.elementsOutsideChildren.forEach(f -> result.add(this.getNonChildType((FrankElement)f)));
        result.add(this.getTypeReferencedEntityRoot());
        return result.build();
    }

    private JsonObject getTypeReferencedEntityRoot() {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", "Module");
        JsonArrayBuilder members = this.bf.createArrayBuilder();
        members.add("Module");
        result.add("members", members);
        return result.build();
    }

    private JsonObject getType(ElementType elementType) {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", elementType.getFullName());
        JsonArrayBuilder members = this.bf.createArrayBuilder();
        elementType.getSyntax2Members().forEach(f -> members.add(f.getFullName()));
        result.add("members", members);
        return result.build();
    }

    private JsonObject getNonChildType(FrankElement frankElement) {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", frankElement.getFullName());
        JsonArrayBuilder members = this.bf.createArrayBuilder();
        members.add(frankElement.getFullName());
        result.add("members", members);
        return result.build();
    }

    private JsonArray getElements() throws JsonException {
        Map<String, List<FrankElement>> elementsByName = this.model.getAllElements().values().stream().collect(Collectors.groupingBy(f -> this.getElementNameForJson((FrankElement)f)));
        ArrayList<String> sortKeys = new ArrayList<String>(elementsByName.keySet());
        sortKeys.add("Module");
        Collections.sort(sortKeys);
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        for (String sortKey : sortKeys) {
            if (sortKey.equals("Module")) {
                result.add(this.getElementReferencedEntityRoot());
                continue;
            }
            elementsByName.get(sortKey).stream().map(f -> this.getElement((FrankElement)f)).forEach(result::add);
        }
        return result.build();
    }

    private String getElementNameForJson(FrankElement f) {
        boolean useXmlElementName;
        boolean bl = useXmlElementName = !f.isInterfaceBased() && f.hasOnePossibleXmlElementName();
        if (useXmlElementName) {
            return f.getTheSingleXmlElementName();
        }
        return f.getSimpleName();
    }

    private JsonObject getElementReferencedEntityRoot() {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", "Module");
        result.add("fullName", "Module");
        this.addDescription(result, "Wrapper element to help split up large configuration files into smaller valid XML files. It may be used as root tag when an XML file contains multiple adapters and/or jobs. The Module element itself does not influence the behavior of Frank configurations.");
        JsonArrayBuilder xmlElementNames = this.bf.createArrayBuilder();
        xmlElementNames.add("Module");
        result.add("elementNames", xmlElementNames.build());
        return result.build();
    }

    private JsonObject getElement(FrankElement frankElement) throws JsonException {
        Object b;
        JsonArray configChildren;
        List<FrankAttribute> nonInheritedAttributes;
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", this.getElementNameForJson(frankElement));
        result.add("fullName", frankElement.getFullName());
        if (frankElement.isAbstract()) {
            result.add("abstract", frankElement.isAbstract());
        }
        if (frankElement.isDeprecated()) {
            result.add("deprecated", frankElement.isDeprecated());
        }
        this.addDescription(result, frankElement.getDescription());
        this.addIfNotNull(result, "parent", FrankDocJsonFactory.getParentOrNull(frankElement));
        JsonArrayBuilder xmlElementNames = this.bf.createArrayBuilder();
        frankElement.getXmlElementNames().forEach(xmlElementNames::add);
        result.add("elementNames", xmlElementNames);
        JsonArray attributes = this.getAttributes(frankElement, FrankDocJsonFactory.getParentOrNull(frankElement) == null);
        if (!attributes.isEmpty()) {
            result.add("attributes", attributes);
        }
        if (!(nonInheritedAttributes = frankElement.getChildrenOfKind(ElementChild.JSON_NOT_INHERITED, FrankAttribute.class)).isEmpty()) {
            JsonArrayBuilder b2 = this.bf.createArrayBuilder();
            nonInheritedAttributes.forEach(nia -> b2.add(nia.getName()));
            result.add("nonInheritedAttributes", b2.build());
        }
        if (!(configChildren = this.getConfigChildren(frankElement)).isEmpty()) {
            result.add("children", configChildren);
        }
        if (frankElement.getMeaningOfParameters() != null) {
            result.add("parametersDescription", frankElement.getMeaningOfParameters());
        }
        if (frankElement.getSpecificParameters().size() >= 1) {
            b = this.bf.createArrayBuilder();
            frankElement.getSpecificParameters().forEach(arg_0 -> this.lambda$getElement$6((JsonArrayBuilder)b, arg_0));
            result.add("parameters", b.build());
        }
        if (frankElement.getForwards().size() >= 1) {
            b = this.bf.createArrayBuilder();
            frankElement.getForwards().forEach(arg_0 -> this.lambda$getElement$7((JsonArrayBuilder)b, arg_0));
            result.add("forwards", b.build());
        }
        if (!frankElement.getTags().isEmpty()) {
            b = this.bf.createObjectBuilder();
            for (ParsedJavaDocTag tag : frankElement.getTags()) {
                b.add(tag.getName(), tag.getDescription());
            }
            result.add("tags", b.build());
        }
        return result.build();
    }

    private JsonObject getParsedJavaDocTag(ParsedJavaDocTag parsedJavaDocTag) {
        JsonObjectBuilder b = this.bf.createObjectBuilder();
        b.add("name", parsedJavaDocTag.getName());
        if (parsedJavaDocTag.getDescription() != null) {
            b.add(DESCRIPTION, parsedJavaDocTag.getDescription());
        }
        return b.build();
    }

    private static String getParentOrNull(FrankElement frankElement) {
        FrankElement parent;
        if (frankElement != null && (parent = frankElement.getNextAncestorThatHasChildren(elem -> elem.getAttributes(ElementChild.JSON_RELEVANT).isEmpty() && elem.getConfigChildren(ElementChild.JSON_RELEVANT).isEmpty())) != null) {
            return parent.getFullName();
        }
        return null;
    }

    private JsonArray getAttributes(FrankElement frankElement, boolean addAttributeActive) throws JsonException {
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        for (FrankAttribute attribute : frankElement.getAttributes(ElementChild.IN_COMPATIBILITY_XSD)) {
            result.add(this.getAttribute(attribute));
        }
        if (addAttributeActive) {
            result.add(this.getAttributeActive());
        }
        return result.build();
    }

    private JsonObject getAttribute(FrankAttribute frankAttribute) throws JsonException {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", frankAttribute.getName());
        if (frankAttribute.isDeprecated()) {
            result.add("deprecated", frankAttribute.isDeprecated());
        }
        if (frankAttribute.getMandatoryStatus() != MandatoryStatus.OPTIONAL) {
            result.add("mandatory", true);
        }
        if (frankAttribute.isReintroduced()) {
            result.add("reintroduced", true);
        }
        result.add("describer", frankAttribute.getDescribingElement().getFullName());
        this.addIfNotNull(result, DESCRIPTION, frankAttribute.getDescription());
        this.addIfNotNull(result, "default", frankAttribute.getDefaultValue());
        if (!frankAttribute.getAttributeType().equals((Object)AttributeType.STRING)) {
            result.add("type", frankAttribute.getAttributeType().name().toLowerCase());
        }
        if (frankAttribute.getAttributeEnum() != null) {
            result.add("enum", frankAttribute.getAttributeEnum().getFullName());
        }
        return result.build();
    }

    private JsonObject getAttributeActive() {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", "active");
        result.add(DESCRIPTION, "If defined and empty or false, then this element and all its children are ignored");
        return result.build();
    }

    private void addIfNotNull(JsonObjectBuilder builder, String field, String value) {
        if (value != null) {
            builder.add(field, value);
        }
    }

    private void addDescription(JsonObjectBuilder builder, String value) {
        if (!StringUtils.isBlank(value)) {
            builder.add(DESCRIPTION, value.replaceAll("\"", "\\\\\\\""));
        }
    }

    private JsonArray getConfigChildren(FrankElement frankElement) throws JsonException {
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        if (frankElement.getFullName().equals(this.model.getRootClassName())) {
            result.add(this.getConfigChildReferencedEntityRoot());
        }
        for (ConfigChild child : frankElement.getConfigChildren(ElementChild.IN_COMPATIBILITY_XSD)) {
            result.add(this.getConfigChild(child));
        }
        return result.build();
    }

    private JsonObject getConfigChildReferencedEntityRoot() {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("multiple", true);
        result.add("roleName", "Module".toLowerCase());
        result.add(DESCRIPTION, "Wrapper element to help split up large configuration files into smaller valid XML files. It may be used as root tag when an XML file contains multiple adapters and/or jobs. The Module element itself does not influence the behavior of Frank configurations.");
        result.add("type", "Module");
        return result.build();
    }

    private JsonObject getConfigChild(ConfigChild child) throws JsonException {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        if (child.isDeprecated()) {
            result.add("deprecated", child.isDeprecated());
        }
        if (child.getMandatoryStatus() != MandatoryStatus.OPTIONAL) {
            result.add("mandatory", true);
        }
        if (child.isReintroduced()) {
            result.add("reintroduced", true);
        }
        result.add("multiple", child.isAllowMultiple());
        result.add("roleName", child.getRoleName());
        this.addIfNotNull(result, DESCRIPTION, child.getDescription());
        if (child instanceof ObjectConfigChild) {
            result.add("type", ((ObjectConfigChild)child).getElementType().getFullName());
        }
        return result.build();
    }

    private JsonArray getEnums() {
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        for (AttributeEnum attributeEnum : this.model.getAllAttributeEnumInstances()) {
            result.add(this.getAttributeEnum(attributeEnum));
        }
        return result.build();
    }

    private JsonObject getAttributeEnum(AttributeEnum en) {
        JsonObjectBuilder result = this.bf.createObjectBuilder();
        result.add("name", en.getFullName());
        result.add("values", this.getAttributeEnumValues(en));
        return result.build();
    }

    private JsonArray getAttributeEnumValues(AttributeEnum en) {
        JsonArrayBuilder result = this.bf.createArrayBuilder();
        for (AttributeEnumValue v : en.getValues()) {
            JsonObjectBuilder valueBuilder = this.bf.createObjectBuilder();
            valueBuilder.add("label", v.getLabel());
            if (v.getDescription() != null) {
                valueBuilder.add(DESCRIPTION, v.getDescription());
            }
            if (v.isDeprecated()) {
                valueBuilder.add("deprecated", true);
            }
            result.add(valueBuilder.build());
        }
        return result.build();
    }

    private /* synthetic */ void lambda$getElement$7(JsonArrayBuilder b, ParsedJavaDocTag fw) {
        b.add(this.getParsedJavaDocTag(fw));
    }

    private /* synthetic */ void lambda$getElement$6(JsonArrayBuilder b, ParsedJavaDocTag sp) {
        b.add(this.getParsedJavaDocTag(sp));
    }
}

