/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.frankframework.frankdoc.model.CumulativeChildHandler;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.FrankElement;

class GroupCreator<T extends ElementChild> {
    private FrankElement frankElement;
    private Predicate<FrankElement> hasRelevantChildren;
    private Callback<T> callback;
    private Consumer<Callback<T>> cumulativeGroupTrigger;

    GroupCreator(FrankElement frankElement, Predicate<FrankElement> hasRelevantChildren, Consumer<Callback<T>> cumulativeGroupTrigger, Callback<T> callback) {
        this.frankElement = frankElement;
        this.hasRelevantChildren = hasRelevantChildren;
        this.cumulativeGroupTrigger = cumulativeGroupTrigger;
        this.callback = callback;
    }

    void run() {
        boolean hasNoRelevantChildren = !this.hasRelevantChildren.test(this.frankElement);
        FrankElement ancestor = this.nextAncestor(this.frankElement);
        if (hasNoRelevantChildren) {
            if (ancestor == null) {
                this.callback.noChildren();
            } else {
                FrankElement superAncestor = this.nextAncestor(ancestor);
                if (superAncestor == null) {
                    this.callback.addDeclaredGroupRef(ancestor);
                } else {
                    this.callback.addCumulativeGroupRef(ancestor);
                }
            }
        } else if (ancestor == null) {
            this.callback.addTopLevelDeclaredGroup();
            this.callback.addDeclaredGroupRef(this.frankElement);
        } else {
            this.callback.addDeclaredGroup();
            this.callback.addCumulativeGroupRef(this.frankElement);
            this.addCumulativeChildGroup();
        }
    }

    private FrankElement nextAncestor(FrankElement e) {
        return e.getNextAncestorThatHasChildren(this.hasRelevantChildren.negate());
    }

    private void addCumulativeChildGroup() {
        this.callback.addCumulativeGroup();
        this.cumulativeGroupTrigger.accept(this.callback);
    }

    static interface Callback<T extends ElementChild>
    extends CumulativeChildHandler<T> {
        public void noChildren();

        public void addDeclaredGroup();

        public void addTopLevelDeclaredGroup();

        public void addCumulativeGroup();

        public void addDeclaredGroupRef(FrankElement var1);

        public void addCumulativeGroupRef(FrankElement var1);
    }
}

