/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc;

import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.DocWriterNewXmlUtils;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.MandatoryStatus;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.util.XmlBuilder;

public enum XsdVersion {
    STRICT(ElementChild.IN_XSD, ElementChild.REJECT_DEPRECATED, f -> !f.isDeprecated(), new DelegateStrict()),
    COMPATIBILITY(ElementChild.IN_COMPATIBILITY_XSD, ElementChild.EXCLUDED, f -> true, new DelegateCompatibility());

    private static Logger log;
    private final Predicate<ElementChild> childSelector;
    private final Predicate<ElementChild> childRejector;
    private final Predicate<FrankElement> elementFilter;
    private final Delegate delegate;

    private XsdVersion(Predicate<ElementChild> childSelector, Predicate<ElementChild> childRejector, Predicate<FrankElement> elementFilter, Delegate delegate) {
        this.childSelector = childSelector;
        this.childRejector = childRejector;
        this.elementFilter = elementFilter;
        this.delegate = delegate;
    }

    Predicate<FrankElement> getHasRelevantChildrenPredicate(Class<? extends ElementChild> kind) {
        return f -> !f.getChildrenOfKind(this.childSelector.or(this.childRejector), kind).isEmpty();
    }

    void checkForMissingDescription(FrankAttribute attribute) {
        this.delegate.checkForMissingDescription(attribute);
    }

    void checkForMissingDescription(ConfigChild configChild) {
        this.delegate.checkForMissingDescription(configChild);
    }

    DocWriterNewXmlUtils.AttributeUse getRoleNameAttributeUse() {
        return this.delegate.getRoleNameAttributeUse();
    }

    DocWriterNewXmlUtils.AttributeUse getClassNameAttributeUse(FrankElement frankElement) {
        return this.delegate.getClassNameAttributeUse(frankElement);
    }

    XmlBuilder configChildBuilderWithinSequence(XmlBuilder context) {
        return this.delegate.configChildBuilderWithinSequence(context);
    }

    XmlBuilder configChildBuilder(XmlBuilder context) {
        return this.delegate.configChildBuilder(context);
    }

    boolean childIsMandatory(ElementChild child) {
        return this.delegate.childIsMandatory(child);
    }

    public Predicate<ElementChild> getChildSelector() {
        return this.childSelector;
    }

    public Predicate<ElementChild> getChildRejector() {
        return this.childRejector;
    }

    public Predicate<FrankElement> getElementFilter() {
        return this.elementFilter;
    }

    static {
        log = LogUtil.getLogger(XsdVersion.class);
    }

    private static class DelegateCompatibility
    extends Delegate {
        private DelegateCompatibility() {
        }

        @Override
        void checkForMissingDescription(FrankAttribute attribute) {
        }

        @Override
        void checkForMissingDescription(ConfigChild configChild) {
        }

        @Override
        DocWriterNewXmlUtils.AttributeUse getRoleNameAttributeUse() {
            return DocWriterNewXmlUtils.AttributeUse.OPTIONAL;
        }

        @Override
        DocWriterNewXmlUtils.AttributeUse getClassNameAttributeUse(FrankElement frankElement) {
            if (frankElement.isInterfaceBased()) {
                return DocWriterNewXmlUtils.AttributeUse.OPTIONAL;
            }
            return DocWriterNewXmlUtils.AttributeUse.PROHIBITED;
        }

        @Override
        XmlBuilder configChildBuilderWithinSequence(XmlBuilder context) {
            return DocWriterNewXmlUtils.addChoice(context, "0", "unbounded");
        }

        @Override
        XmlBuilder configChildBuilder(XmlBuilder context) {
            XmlBuilder sequence = DocWriterNewXmlUtils.addSequence(context);
            return DocWriterNewXmlUtils.addChoice(sequence, "0", "unbounded");
        }

        @Override
        boolean childIsMandatory(ElementChild child) {
            return child.getMandatoryStatus() == MandatoryStatus.MANDATORY;
        }
    }

    private static class DelegateStrict
    extends Delegate {
        private DelegateStrict() {
        }

        @Override
        void checkForMissingDescription(FrankAttribute attribute) {
            if (attribute.getDescription() != null) {
                return;
            }
            log.warn("Attribute [{}] lacks description", (Object)attribute.toString());
        }

        @Override
        void checkForMissingDescription(ConfigChild configChild) {
            if (configChild.getDescription() != null) {
                return;
            }
            log.warn("Config child [{}] lacks description", (Object)configChild.toString());
        }

        @Override
        DocWriterNewXmlUtils.AttributeUse getRoleNameAttributeUse() {
            return DocWriterNewXmlUtils.AttributeUse.PROHIBITED;
        }

        @Override
        DocWriterNewXmlUtils.AttributeUse getClassNameAttributeUse(FrankElement frankElement) {
            return DocWriterNewXmlUtils.AttributeUse.PROHIBITED;
        }

        @Override
        XmlBuilder configChildBuilderWithinSequence(XmlBuilder context) {
            return context;
        }

        @Override
        XmlBuilder configChildBuilder(XmlBuilder context) {
            return context;
        }

        @Override
        boolean childIsMandatory(ElementChild child) {
            return child.getMandatoryStatus() != MandatoryStatus.OPTIONAL;
        }
    }

    private static abstract class Delegate {
        private Delegate() {
        }

        abstract void checkForMissingDescription(FrankAttribute var1);

        abstract void checkForMissingDescription(ConfigChild var1);

        abstract DocWriterNewXmlUtils.AttributeUse getRoleNameAttributeUse();

        abstract DocWriterNewXmlUtils.AttributeUse getClassNameAttributeUse(FrankElement var1);

        abstract XmlBuilder configChildBuilderWithinSequence(XmlBuilder var1);

        abstract XmlBuilder configChildBuilder(XmlBuilder var1);

        abstract boolean childIsMandatory(ElementChild var1);
    }
}

