/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.doclet;

import com.sun.javadoc.ClassDoc;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.json.JsonObject;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.AttributeTypeStrategy;
import org.frankframework.frankdoc.DocWriterNew;
import org.frankframework.frankdoc.FrankDocElementSummaryFactory;
import org.frankframework.frankdoc.FrankDocJsonFactory;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.XsdVersion;
import org.frankframework.frankdoc.doclet.FrankDocletOptions;
import org.frankframework.frankdoc.model.FrankDocModel;
import org.frankframework.frankdoc.model.FrankElementFilters;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankClassRepository;
import org.frankframework.frankdoc.wrapper.FrankDocException;

class Doclet {
    private static final Logger log = LogUtil.getLogger(Doclet.class);
    private final FrankDocModel model;
    private final File xsdStrictFile;
    private final File xsdCompatibilityFile;
    private final File jsonFile;
    private final File elementSummaryFile;
    private final String frankFrameworkVersion;

    Doclet(ClassDoc[] classes, FrankDocletOptions options) throws FrankDocException {
        log.info("Output base directory is: [{}]", (Object)options.getOutputBaseDir());
        try {
            FrankClassRepository repository = FrankClassRepository.getDocletInstance(classes, FrankElementFilters.getIncludeFilter(), FrankElementFilters.getExcludeFilter(), FrankElementFilters.getExcludeFiltersForSuperclass());
            this.model = FrankDocModel.populate(options.getDigesterRulesUrl(), options.getRootClass(), repository);
            File outputBaseDir = new File(options.getOutputBaseDir());
            outputBaseDir.mkdirs();
            this.xsdStrictFile = new File(outputBaseDir, options.getXsdStrictPath());
            this.xsdStrictFile.getParentFile().mkdirs();
            this.xsdCompatibilityFile = new File(outputBaseDir, options.getXsdCompatibilityPath());
            this.xsdCompatibilityFile.getParentFile().mkdirs();
            this.jsonFile = new File(outputBaseDir, options.getJsonOutputPath());
            this.jsonFile.getParentFile().mkdirs();
            this.elementSummaryFile = new File(outputBaseDir, options.getElementSummaryPath());
            this.elementSummaryFile.getParentFile().mkdirs();
            this.frankFrameworkVersion = options.getFrankFrameworkVersion();
        }
        catch (SecurityException e) {
            throw new FrankDocException("SecurityException occurred initializing the output directory", e);
        }
    }

    void run() throws FrankDocException {
        if (this.frankFrameworkVersion == null) {
            log.error("No Frank!Framework version set; please configure it in your pom.xml as argument -frankFrameworkVersion");
        }
        this.writeStrictXsd();
        this.writeCompatibilityXsd();
        this.writeJson();
        this.writeElementSummary();
    }

    void writeStrictXsd() throws FrankDocException {
        log.info("Calculating XSD without deprecated items that allows property references");
        DocWriterNew docWriter = new DocWriterNew(this.model, AttributeTypeStrategy.ALLOW_PROPERTY_REF, this.frankFrameworkVersion);
        docWriter.init(XsdVersion.STRICT);
        String schemaText = docWriter.getSchema();
        log.info("Done calculating XSD without deprecated items that allows property references, writing it to file {}", (Object)this.xsdStrictFile.getAbsolutePath());
        this.writeStringToFile(schemaText, this.xsdStrictFile);
        log.info("Writing output file done");
    }

    void writeStringToFile(String text, File file) throws FrankDocException {
        Writer w = null;
        try {
            w = new BufferedWriter(new FileWriter(file));
            w.append(text);
            w.flush();
        }
        catch (IOException e) {
            throw new FrankDocException(String.format("Could not write file [%s]", file.getPath()), e);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException e) {
                log.error("Failed to close file {}", (Object)file, (Object)e);
            }
        }
    }

    void writeCompatibilityXsd() throws FrankDocException {
        log.info("Calculating XSD with deprecated items that does not allow property references");
        DocWriterNew docWriter = new DocWriterNew(this.model, AttributeTypeStrategy.ALLOW_PROPERTY_REF_ENUM_VALUES_IGNORE_CASE, this.frankFrameworkVersion);
        docWriter.init(XsdVersion.COMPATIBILITY);
        String schemaText = docWriter.getSchema();
        log.info("Done calculating XSD with deprecated items that does not allow property references, writing it to file {}", (Object)this.xsdCompatibilityFile.getAbsolutePath());
        this.writeStringToFile(schemaText, this.xsdCompatibilityFile);
        log.info("Writing output file done");
    }

    void writeJson() throws FrankDocException {
        log.info("Calculating JSON file with documentation of the F!F");
        FrankDocJsonFactory jsonFactory = new FrankDocJsonFactory(this.model, this.frankFrameworkVersion);
        JsonObject jsonObject = jsonFactory.getJson();
        String jsonText = Utils.jsonPretty(jsonObject.toString());
        log.info("Done calculating JSON file with documentation of the F!F, writing the text to file {}", (Object)this.jsonFile.getAbsolutePath());
        this.writeStringToFile(jsonText, this.jsonFile);
        log.info("Writing output file done");
    }

    void writeElementSummary() throws FrankDocException {
        log.info("Calculating element summary");
        FrankDocElementSummaryFactory elementSummaryFactory = new FrankDocElementSummaryFactory(this.model);
        String text = elementSummaryFactory.getText();
        log.info("Done calculating element summary");
        this.writeStringToFile(text, this.elementSummaryFile);
        log.info("Writing output file done");
    }
}

