/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.LanguageVersion;
import com.sun.javadoc.RootDoc;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.doclet.Doclet;
import org.frankframework.frankdoc.doclet.FrankDocletOptions;
import org.frankframework.frankdoc.doclet.InvalidDocletOptionsException;
import org.frankframework.frankdoc.util.ErrorDetectingAppender;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankDocException;

public class DocletBuilder
extends com.sun.javadoc.Doclet {
    private static final Logger log = LogUtil.getLogger(DocletBuilder.class);

    public static boolean start(RootDoc root) {
        DocletBuilder.printOptions(root);
        ClassDoc[] classes = root.classes();
        boolean result = true;
        try {
            FrankDocletOptions options = FrankDocletOptions.getInstance(root.options());
            new Doclet(classes, options).run();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            result = false;
        }
        catch (FrankDocException e) {
            log.error("FrankDocException occurred while running Frank!Doc Doclet", (Throwable)e);
            result = false;
        }
        if (ErrorDetectingAppender.HAVE_ERRORS) {
            log.error("There were log statements with level ERROR or FATAL. Failing");
            result = false;
        }
        return result;
    }

    private static void printOptions(RootDoc root) {
        log.info("Here are the options given to the Frank!Doc doclet");
        String[][] options = root.options();
        for (int i = 0; i < options.length; ++i) {
            String[] curOption = options[i];
            String line = "";
            for (int j = 0; j < curOption.length; ++j) {
                if (j != 0) {
                    line = line + " ";
                }
                line = line + curOption[j];
            }
            log.info(line);
        }
        log.info("End of options given to Frank!Doc doclet");
    }

    public static int optionLength(String option) {
        return FrankDocletOptions.optionLength(option);
    }

    public static boolean validOptions(String[][] options, DocErrorReporter reporter) {
        try {
            FrankDocletOptions.validateOptions(options);
            return true;
        }
        catch (InvalidDocletOptionsException e) {
            reporter.printError(e.getMessage());
            return false;
        }
    }

    public static LanguageVersion languageVersion() {
        log.trace("Method languageVersion() called");
        return LanguageVersion.JAVA_1_5;
    }
}

