/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.doclet;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.doclet.InvalidDocletOptionsException;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankDocException;

class FrankDocletOptions {
    private static final Logger log = LogUtil.getLogger(FrankDocletOptions.class);
    private static Map<String, Option> optionsByName = Arrays.asList(Option.values()).stream().collect(Collectors.toMap(Option::getMavenName, Function.identity()));
    private String outputBaseDir;
    private String xsdStrictPath = "xml/xsd/FrankConfig-strict.xsd";
    private String xsdCompatibilityPath = "xml/xsd/FrankConfig-compatibility.xsd";
    private String jsonOutputPath = "js/frankdoc.json";
    private String elementSummaryPath = "txt/elementSummary.txt";
    private URL digesterRulesUrl;
    private String rootClass;
    private String frankFrameworkVersion;

    FrankDocletOptions() {
    }

    static void validateOptions(String[][] options) throws InvalidDocletOptionsException {
        EnumSet<Option> foundOptions = EnumSet.noneOf(Option.class);
        for (int i = 0; i < options.length; ++i) {
            String[] commandLineOption = options[i];
            String optionMavenName = FrankDocletOptions.getOptionMavenName(commandLineOption);
            if (!optionsByName.keySet().contains(optionMavenName)) continue;
            Option option = optionsByName.get(optionMavenName);
            if (foundOptions.contains((Object)option)) {
                throw new InvalidDocletOptionsException(String.format("Duplicate option [%s]", "-" + option.getMavenName()));
            }
            if (commandLineOption.length != 2) {
                throw new InvalidDocletOptionsException(String.format("Only one value is allowed for option [%s], but got [%s]", Arrays.asList(commandLineOption).subList(1, commandLineOption.length).stream().collect(Collectors.joining(", "))));
            }
            foundOptions.add(option);
        }
    }

    static int optionLength(String option) {
        if (!option.startsWith("-")) {
            return 0;
        }
        String key = option.substring(1);
        if (optionsByName.keySet().contains(key)) {
            return 2;
        }
        return 0;
    }

    private static String getOptionMavenName(String[] commandLineOption) throws InvalidDocletOptionsException {
        String optionString = commandLineOption[0];
        if (!optionString.substring(0, 1).equals("-")) {
            throw new InvalidDocletOptionsException(String.format("Option does not begin with \"-\": [%s]", optionString));
        }
        return optionString.substring(1);
    }

    static FrankDocletOptions getInstance(String[][] options) throws FrankDocException {
        log.info("Creating FrankDocletOptions object");
        FrankDocletOptions result = new FrankDocletOptions();
        result.fill(options);
        log.info("Done creating FrankDocletOptions object");
        return result;
    }

    private void fill(String[][] options) throws FrankDocException {
        for (int i = 0; i < options.length; ++i) {
            String[] opt = options[i];
            String key = opt[0].substring(1);
            if (!optionsByName.containsKey(key)) continue;
            Option option = optionsByName.get(key);
            String value = opt[1];
            log.info("Setting option [{}] to [{}]", (Object)option.getMavenName(), (Object)value);
            this.setOption(option, value);
        }
    }

    private void setOption(Option opt, String value) throws FrankDocException {
        switch (opt) {
            case BASE_OUTPUT_DIR: {
                this.outputBaseDir = value;
                break;
            }
            case STRICT_REL_PATH: {
                this.xsdStrictPath = value;
                break;
            }
            case COMPATIBILITY_REL_PATH: {
                this.xsdCompatibilityPath = value;
                break;
            }
            case JSON_REL_PATH: {
                this.jsonOutputPath = value;
                break;
            }
            case ELEMENT_SUMMARY_PATH: {
                this.elementSummaryPath = value;
                break;
            }
            case DIGESTER_RULES_PATH: {
                this.setDigesterRulesUrl(value);
                break;
            }
            case ROOT_CLASS: {
                this.rootClass = value;
                break;
            }
            case FRANK_FRAMEWORK_VERSION: {
                this.frankFrameworkVersion = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Programming error. Switch over FrankDocletOptions.Option was supposed to cover all cases");
            }
        }
    }

    private void setDigesterRulesUrl(String value) throws FrankDocException {
        try {
            File f = new File(value);
            this.digesterRulesUrl = f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new FrankDocException(String.format("Invalid path to digester rules file: [%s]", value), e);
        }
    }

    public String getOutputBaseDir() {
        return this.outputBaseDir;
    }

    public String getXsdStrictPath() {
        return this.xsdStrictPath;
    }

    public String getXsdCompatibilityPath() {
        return this.xsdCompatibilityPath;
    }

    public String getJsonOutputPath() {
        return this.jsonOutputPath;
    }

    public String getElementSummaryPath() {
        return this.elementSummaryPath;
    }

    public URL getDigesterRulesUrl() {
        return this.digesterRulesUrl;
    }

    public String getRootClass() {
        return this.rootClass;
    }

    public String getFrankFrameworkVersion() {
        return this.frankFrameworkVersion;
    }

    private static enum Option {
        BASE_OUTPUT_DIR("outputDirectory"),
        STRICT_REL_PATH("strictPath"),
        COMPATIBILITY_REL_PATH("compatibilityPath"),
        JSON_REL_PATH("jsonPath"),
        ELEMENT_SUMMARY_PATH("elementSummaryPath"),
        DIGESTER_RULES_PATH("digesterRulesPath"),
        ROOT_CLASS("rootClass"),
        FRANK_FRAMEWORK_VERSION("frankFrameworkVersion");

        private String mavenName;

        private Option(String mavenName) {
            this.mavenName = mavenName;
        }

        public String getMavenName() {
            return this.mavenName;
        }
    }
}

