/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.CumulativeChildHandler;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.util.LogUtil;

class AncestorChildNavigation<T extends ElementChild> {
    private static Logger log = LogUtil.getLogger(AncestorChildNavigation.class);
    private final CumulativeChildHandler<T> handler;
    private final Predicate<ElementChild> childSelector;
    private final Predicate<ElementChild> childRejector;
    private final Class<T> kind;
    private Predicate<FrankElement> noChildren;
    private FrankElement current;
    private Set<ElementChild.AbstractKey> selectedChildKeys;
    private Set<ElementChild.AbstractKey> selectedOrRejectedChildKeys;
    private Map<ElementChild.AbstractKey, FrankElement> overridden;

    AncestorChildNavigation(CumulativeChildHandler<T> handler, Predicate<ElementChild> childSelector, Predicate<ElementChild> childRejector, Class<T> kind) {
        this.handler = handler;
        this.childSelector = childSelector;
        this.childRejector = childRejector;
        this.kind = kind;
        this.noChildren = el -> el.getChildrenOfKind(ElementChild.ALL, kind).stream().noneMatch(childSelector.or(childRejector));
    }

    void run(FrankElement start) {
        log.trace("Enter for FrankElement [{}] and child kind [{}]", () -> start.toString(), () -> this.kind.toString());
        this.enter(start);
        this.overridden = new HashMap<ElementChild.AbstractKey, FrankElement>();
        this.addDeclaredGroupOrRepeatChildrenInXsd();
        while (this.current.getNextAncestorThatHasChildren(this.noChildren) != null) {
            this.enter(this.current.getNextAncestorThatHasChildren(this.noChildren));
            if (!this.getOverriddenChildren().stream().anyMatch(this.childSelector)) {
                this.safeAddCumulative();
                return;
            }
            this.addDeclaredGroupOrRepeatChildrenInXsd();
        }
        log.trace("Leave for FrankElement [{}] and child kind [{}]", () -> start.toString(), () -> this.kind.toString());
    }

    private void enter(FrankElement current) {
        this.current = current;
        this.selectedChildKeys = current.getChildrenOfKind(this.childSelector, this.kind).stream().map(ElementChild::getKey).collect(Collectors.toSet());
        Set<ElementChild.AbstractKey> rejectedChildKeys = current.getChildrenOfKind(this.childRejector, this.kind).stream().map(ElementChild::getKey).collect(Collectors.toSet());
        this.checkSelectedChildKeysAreNotRejected(rejectedChildKeys);
        this.selectedOrRejectedChildKeys = new HashSet<ElementChild.AbstractKey>(this.selectedChildKeys);
        this.selectedOrRejectedChildKeys.addAll(rejectedChildKeys);
        if (log.isTraceEnabled()) {
            this.logEnter();
        }
    }

    private void logEnter() {
        log.trace("current: [{}]", (Object)this.current.toString());
        log.trace("selectedChildKeys: [{}]", (Object)AncestorChildNavigation.keysToString(this.selectedChildKeys));
        log.trace("selectedOrRejectedChildKeys: [{}]", (Object)AncestorChildNavigation.keysToString(this.selectedOrRejectedChildKeys));
    }

    private static String keysToString(Collection<ElementChild.AbstractKey> keys) {
        return keys.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private void checkSelectedChildKeysAreNotRejected(Set<ElementChild.AbstractKey> rejectedChildKeys) {
        HashSet<ElementChild.AbstractKey> offending = new HashSet<ElementChild.AbstractKey>(this.selectedChildKeys);
        offending.retainAll(rejectedChildKeys);
        if (!offending.isEmpty()) {
            String offendingString = offending.stream().map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Children that are both selected and rejected are not supported: [%s]", offendingString));
        }
    }

    private void addDeclaredGroupOrRepeatChildrenInXsd() {
        if (this.selectedChildKeys.isEmpty()) {
            this.updateOverridden();
            return;
        }
        HashSet<ElementChild.AbstractKey> omit = new HashSet<ElementChild.AbstractKey>(this.selectedChildKeys);
        omit.retainAll(this.overridden.keySet());
        if (omit.isEmpty()) {
            this.handler.handleChildrenOf(this.current);
        } else {
            List children = this.current.getChildrenOfKind(this.childSelector, this.kind).stream().filter(c -> !omit.contains(c.getKey())).map(c -> c).collect(Collectors.toList());
            this.handleSelectedChildren(children);
        }
        this.updateOverridden();
    }

    private void handleSelectedChildren(List<T> children) {
        if (this.current.getNextAncestorThatHasChildren(this.noChildren) == null) {
            this.handler.handleSelectedChildrenOfTopLevel(children, this.current);
        } else {
            this.handler.handleSelectedChildren(children, this.current);
        }
    }

    private void updateOverridden() {
        for (ElementChild child : this.current.getChildrenOfKind(ElementChild.ALL, this.kind)) {
            boolean isRenewedOverride = this.selectedOrRejectedChildKeys.contains(child.getKey());
            boolean isExistingOverride = this.overridden.keySet().contains(child.getKey());
            if (!isRenewedOverride && !isExistingOverride) continue;
            ElementChild overriddenFrom = this.getSelectedOrRejectedChildAncestor(child);
            if (overriddenFrom == null) {
                this.overridden.remove(child.getKey());
                continue;
            }
            this.overridden.put(child.getKey(), overriddenFrom.getOwningElement());
        }
        if (log.isTraceEnabled()) {
            this.logOverriddenFrom();
        }
    }

    private void logOverriddenFrom() {
        Map<FrankElement, Set<ElementChild.AbstractKey>> overriddenByOwner = this.getOverriddenByOwner();
        log.trace("Below follows the contents of overridden, grouped by owning FrankElement");
        for (FrankElement element : overriddenByOwner.keySet()) {
            log.trace("  From [{}]: [{}]", (Object)element.toString(), (Object)AncestorChildNavigation.keysToString((Collection<ElementChild.AbstractKey>)overriddenByOwner.get(element)));
        }
    }

    private Map<FrankElement, Set<ElementChild.AbstractKey>> getOverriddenByOwner() {
        return this.overridden.keySet().stream().collect(Collectors.groupingBy(k -> this.overridden.get(k), Collectors.toSet()));
    }

    private ElementChild getSelectedOrRejectedChildAncestor(ElementChild child) {
        FrankElement candidateOwner = child.getOverriddenFrom();
        while (candidateOwner != null) {
            ElementChild candidate = candidateOwner.findElementChildMatch(child);
            if (candidate == null) {
                throw new IllegalStateException("Cannot happen. If this would happen, method getOverriddenFrom() would not work correctly.");
            }
            if (this.childSelector.test(candidate) || this.childRejector.test(candidate)) {
                return candidate;
            }
            child = candidate;
            candidateOwner = child.getOverriddenFrom();
        }
        return null;
    }

    private List<ElementChild> getOverriddenChildren() {
        Map<FrankElement, Set<ElementChild.AbstractKey>> overriddenByOwner = this.getOverriddenByOwner();
        return overriddenByOwner.keySet().stream().flatMap(frankElement -> frankElement.getChildrenOfKind(ElementChild.ALL, this.kind).stream().filter(c -> ((Set)overriddenByOwner.get(frankElement)).contains(c.getKey()))).collect(Collectors.toList());
    }

    private void safeAddCumulative() {
        if (this.current.getNextAncestorThatHasChildren(this.noChildren) == null) {
            this.handler.handleChildrenOf(this.current);
        } else {
            this.handler.handleCumulativeChildrenOf(this.current);
        }
    }
}

