/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.AttributeEnum;
import org.frankframework.frankdoc.model.AttributeEnumValue;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankClass;

class AttributeEnumFactory {
    private static Logger log = LogUtil.getLogger(AttributeEnumFactory.class);
    private Map<String, AttributeEnum> allAttributeEnumInstances = new LinkedHashMap<String, AttributeEnum>();
    private Map<String, Integer> lastAssignedSeq = new HashMap<String, Integer>();

    AttributeEnumFactory() {
    }

    AttributeEnum findOrCreateAttributeEnum(FrankClass clazz) {
        boolean labelsForgotten;
        List<AttributeEnumValue> values = Arrays.asList(clazz.getEnumConstants()).stream().map(AttributeEnumValue::new).collect(Collectors.toList());
        boolean bl = labelsForgotten = values.stream().map(AttributeEnumValue::isExplicitLabel).distinct().collect(Collectors.counting()) >= 2L;
        if (labelsForgotten) {
            log.warn("Some enum values of class [{}] have a label, but not all. Did you forget some?", (Object)clazz.getName());
        }
        return this.findOrCreateAttributeEnum(clazz.getName(), clazz.getSimpleName(), values);
    }

    AttributeEnum findOrCreateAttributeEnum(String fullName, String simpleName, List<AttributeEnumValue> values) {
        if (this.allAttributeEnumInstances.containsKey(fullName)) {
            return this.allAttributeEnumInstances.get(fullName);
        }
        int seq = this.lastAssignedSeq.getOrDefault(simpleName, 0);
        AttributeEnum result = new AttributeEnum(fullName, simpleName, values, ++seq);
        this.lastAssignedSeq.put(simpleName, seq);
        this.allAttributeEnumInstances.put(fullName, result);
        return result;
    }

    AttributeEnum findAttributeEnum(String enumTypeFullName) {
        return this.allAttributeEnumInstances.get(enumTypeFullName);
    }

    List<AttributeEnum> getAll() {
        return new ArrayList<AttributeEnum>(this.allAttributeEnumInstances.values());
    }

    int size() {
        return this.allAttributeEnumInstances.size();
    }
}

