/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.Feature;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankEnumConstant;

public class AttributeEnumValue {
    private static Logger log = LogUtil.getLogger(AttributeEnumValue.class);
    private static final String ENUM_LABEL = "nl.nn.adapterframework.doc.EnumLabel";
    private boolean explicitLabel = false;
    private String javaTag;
    private String label;
    private String description;
    private boolean deprecated = false;

    AttributeEnumValue(FrankEnumConstant c) {
        String javaDoc;
        this.label = this.javaTag = c.getName();
        FrankAnnotation annotation = c.getAnnotation(ENUM_LABEL);
        String annotationValue = null;
        if (annotation != null) {
            try {
                annotationValue = (String)annotation.getValue();
            }
            catch (FrankDocException e) {
                log.error("Could not parse annotation value of {}", (Object)ENUM_LABEL, (Object)e);
            }
        }
        if (!StringUtils.isBlank(annotationValue)) {
            this.explicitLabel = true;
            this.label = annotationValue;
        }
        if (!StringUtils.isBlank(javaDoc = c.getJavaDoc())) {
            this.description = javaDoc;
        }
        try {
            if (Feature.DEPRECATED.isSetOn(c)) {
                this.deprecated = true;
            }
        }
        catch (FrankDocException e) {
            log.error("Could not parse Java annotation or JavaDoc tag for enum constant [{}]", (Object)c.getName(), (Object)e);
        }
    }

    public boolean isExplicitLabel() {
        return this.explicitLabel;
    }

    public String getJavaTag() {
        return this.javaTag;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }
}

