/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public enum AttributeType {
    STRING,
    BOOL,
    INT;

    private static final Map<String, AttributeType> JAVA_TO_TYPE;

    static AttributeType fromJavaType(String javaType) {
        AttributeType result = JAVA_TO_TYPE.get(javaType);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Java type is not one of %s: %s", Arrays.asList(AttributeType.values()).stream().map(Enum::name).collect(Collectors.joining(", ")), javaType));
        }
        return result;
    }

    static {
        JAVA_TO_TYPE = new HashMap<String, AttributeType>();
        JAVA_TO_TYPE.put("int", INT);
        JAVA_TO_TYPE.put("boolean", BOOL);
        JAVA_TO_TYPE.put("long", INT);
        JAVA_TO_TYPE.put("byte", INT);
        JAVA_TO_TYPE.put("short", INT);
        JAVA_TO_TYPE.put("java.lang.String", STRING);
        JAVA_TO_TYPE.put("java.lang.Integer", INT);
        JAVA_TO_TYPE.put("java.lang.Boolean", BOOL);
        JAVA_TO_TYPE.put("java.lang.Long", INT);
        JAVA_TO_TYPE.put("java.lang.Byte", INT);
        JAVA_TO_TYPE.put("java.lang.Short", INT);
    }
}

