/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.XsdVersion;
import org.frankframework.frankdoc.model.ConfigChildKey;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.model.Feature;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankMethod;

public abstract class ConfigChild
extends ElementChild {
    private static Logger log = LogUtil.getLogger(ConfigChild.class);
    private static final Comparator<ConfigChild> SINGLE_ELEMENT_ONLY = Comparator.comparing(c -> !c.isAllowMultiple());
    private static final Comparator<ConfigChild> REMOVE_DUPLICATES_COMPARATOR = SINGLE_ELEMENT_ONLY.thenComparing(ElementChild::getMandatoryStatus);
    private boolean allowMultiple;
    private String methodName;

    ConfigChild(FrankElement owningElement, FrankMethod method) {
        super(owningElement);
        this.setDocumented(ConfigChild.isDocumented(method));
        this.setDeprecated(Feature.DEPRECATED.isSetOn(method));
        this.setReintroduced(Feature.REINTRODUCE.isSetOn(method));
        log.trace("ConfigChild of method {} has documented={}, deprecated={}, reintroduced={}", () -> method.toString(), () -> this.isDocumented(), () -> this.isDeprecated(), () -> this.isReintroduced());
        this.methodName = method.getName();
        this.setJavaDocBasedDescriptionAndDefault(method);
        FrankAnnotation ibisDoc = ConfigChild.getIbisDoc(method);
        if (ibisDoc != null) {
            try {
                this.parseIbisDocAnnotation(ibisDoc);
            }
            catch (FrankDocException e) {
                log.error("Could not parse IbisDoc annotation of method {}", (Object)method.toString(), (Object)e);
            }
        }
    }

    public abstract String getRoleName();

    private static boolean isDocumented(FrankMethod m) {
        return m.getAnnotation("nl.nn.adapterframework.doc.IbisDoc") != null || m.getJavaDoc() != null;
    }

    private static FrankAnnotation getIbisDoc(FrankMethod method) {
        FrankAnnotation result = null;
        try {
            result = method.getAnnotationIncludingInherited("nl.nn.adapterframework.doc.IbisDoc");
        }
        catch (FrankDocException e) {
            log.error("Error getting @IbisDoc annotation for method {}", (Object)method, (Object)e);
        }
        return result;
    }

    @Override
    abstract ConfigChildKey getKey();

    static List<ConfigChild> removeDuplicates(List<ConfigChild> orig) {
        Map<ConfigChildKey, List<ConfigChild>> byKey = orig.stream().collect(Collectors.groupingBy(ConfigChild::getKey));
        ArrayList<ConfigChild> result = new ArrayList<ConfigChild>();
        for (ConfigChildKey key : byKey.keySet()) {
            ArrayList bucket = new ArrayList(byKey.get(key));
            Collections.sort(bucket, REMOVE_DUPLICATES_COMPARATOR);
            ConfigChild selected = (ConfigChild)bucket.get(0);
            result.add(selected);
            if (selected.isDeprecated()) {
                if (bucket.stream().allMatch(ElementChild::isDeprecated)) {
                    log.trace("All config children with key [{}] are deprecated", () -> key.toString());
                } else {
                    log.error("From duplicate config children, only a deprecated one is selected. In mode {}, {} will not have a config child for {}", () -> XsdVersion.STRICT, () -> selected.getOwningElement().getFullName(), () -> selected.toString());
                }
            }
            if (!log.isTraceEnabled() || bucket.size() < 2) continue;
            for (ConfigChild omitted : bucket.subList(1, bucket.size())) {
                log.trace("Omitting config child {} because it is a duplicate of {}", (Object)omitted.toString(), (Object)selected.toString());
            }
        }
        return result;
    }

    @Override
    boolean specificOverrideIsMeaningful(ElementChild overriddenFrom) {
        ConfigChild match = (ConfigChild)overriddenFrom;
        return this.allowMultiple != match.allowMultiple;
    }

    public static Stream<ElementRole> getElementRoleStream(Collection<ConfigChild> configChildren) {
        return configChildren.stream().filter(c -> c instanceof ObjectConfigChild).map(c -> (ObjectConfigChild)c).map(ObjectConfigChild::getElementRole).distinct();
    }

    public static String toString(Collection<ConfigChild> configChildren) {
        return configChildren.stream().map(ElementChild::toString).collect(Collectors.joining(", "));
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public void setAllowMultiple(boolean allowMultiple) {
        this.allowMultiple = allowMultiple;
    }

    String getMethodName() {
        return this.methodName;
    }
}

