/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.model.TextConfigChild;

public enum ConfigChildGroupKind {
    OBJECT,
    TEXT,
    MIXED;


    public static ConfigChildGroupKind groupKind(Collection<ConfigChild> configChildren) {
        Set roleNames = configChildren.stream().map(ConfigChild::getRoleName).collect(Collectors.toSet());
        if (roleNames.size() >= 2) {
            throw new IllegalArgumentException(String.format("Expected config children [%s] to have the same role name, but got role names [%s]", configChildren.stream().map(ElementChild::toString).collect(Collectors.joining(", ")), roleNames.stream().collect(Collectors.joining(", "))));
        }
        boolean allObject = configChildren.stream().allMatch(c -> c instanceof ObjectConfigChild);
        boolean allSingleText = configChildren.stream().allMatch(c -> c instanceof TextConfigChild);
        if (allObject) {
            return OBJECT;
        }
        if (allSingleText) {
            return TEXT;
        }
        return MIXED;
    }
}

