/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ConfigChildGroupKind;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.util.LogUtil;

public class ConfigChildSet {
    private static Logger log = LogUtil.getLogger(ConfigChildSet.class);
    private final List<ConfigChild> configChildren;

    ConfigChildSet(List<ConfigChild> configChildren) {
        this.configChildren = configChildren;
        if (configChildren.isEmpty()) {
            throw new IllegalStateException("A config child cannot have an empty list of config childs");
        }
        if (configChildren.size() >= 2) {
            FrankElement owner = configChildren.get(0).getOwningElement();
            ConfigChild previous = configChildren.get(0);
            for (ConfigChild c : configChildren.subList(1, configChildren.size())) {
                boolean sameOwner = true;
                while (c.getOwningElement() != owner) {
                    if (owner == null) {
                        throw new IllegalStateException(String.format("Cumulative config children are not sorted by owning elements and their ancestor hierarchy: [%s] should not be followed by [%s]", previous.toString(), c.toString()));
                    }
                    owner = owner.getParent();
                    sameOwner = false;
                }
                if (sameOwner && previous.getOrder() > c.getOrder()) {
                    throw new IllegalStateException(String.format("Cumulative config children are not sorted by order. Offending config child [%s]", c.getKey().toString()));
                }
                previous = c;
            }
        }
    }

    public ConfigChildGroupKind getConfigChildGroupKind() {
        return ConfigChildGroupKind.groupKind(this.configChildren);
    }

    public Stream<ElementRole> getElementRoleStream() {
        return ConfigChild.getElementRoleStream(this.configChildren);
    }

    public String getRoleName() {
        return this.configChildren.get(0).getRoleName();
    }

    public List<ElementRole> getFilteredElementRoles(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        List<ConfigChild> filteredConfigChildren = this.filter(selector, rejector);
        return ConfigChild.getElementRoleStream(filteredConfigChildren).collect(Collectors.toList());
    }

    List<ConfigChild> filter(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        Set keys = this.configChildren.stream().map(ConfigChild::getKey).distinct().collect(Collectors.toSet());
        ArrayList<ConfigChild> result = new ArrayList<ConfigChild>();
        for (ConfigChild c : this.configChildren) {
            if (rejector.test(c)) {
                keys.remove(c.getKey());
                continue;
            }
            if (!selector.test(c)) continue;
            result.add(c);
            keys.remove(c.getKey());
        }
        return result;
    }

    public static Map<String, List<ConfigChild>> getMemberChildren(List<ElementRole> parents, Predicate<ElementChild> selector, Predicate<ElementChild> rejector, Predicate<FrankElement> elementFilter) {
        if (log.isTraceEnabled()) {
            log.trace("ConfigChildSet.getMemberChildren called with parents: [{}]", (Object)ConfigChildSet.elementRolesToString(parents));
        }
        List members = parents.stream().flatMap(role -> role.getMembers().stream()).filter(elementFilter).distinct().collect(Collectors.toList());
        if (log.isTraceEnabled()) {
            String elementsString = members.stream().map(FrankElement::getSimpleName).collect(Collectors.joining(", "));
            log.trace("Members of parents are: [{}]", (Object)elementsString);
        }
        Map<String, List<ConfigChild>> memberChildrenByRoleName = members.stream().flatMap(element -> element.getCumulativeConfigChildren(selector, rejector).stream()).distinct().collect(Collectors.groupingBy(ConfigChild::getRoleName));
        if (log.isTraceEnabled()) {
            log.trace("Found the following member children:");
            for (String roleName : memberChildrenByRoleName.keySet()) {
                List<ConfigChild> memberChildren = memberChildrenByRoleName.get(roleName);
                String memberChildrenString = memberChildren.stream().map(ElementChild::toString).collect(Collectors.joining(", "));
                log.trace("  [{}]: [{}]", (Object)roleName, (Object)memberChildrenString);
            }
        }
        return memberChildrenByRoleName;
    }

    private static String elementRolesToString(List<ElementRole> elementRoles) {
        return elementRoles.stream().map(ElementRole::toString).collect(Collectors.joining(", "));
    }

    public static Set<ElementRole.Key> getKey(List<ElementRole> roles) {
        return roles.stream().map(ElementRole::getKey).collect(Collectors.toSet());
    }

    public Optional<String> getGenericElementOptionDefault(Predicate<FrankElement> elementFilter) {
        List candidates = ConfigChild.getElementRoleStream(this.configChildren).flatMap(ConfigChildSet::getCandidatesForGenericElementOptionDefault).collect(Collectors.toList());
        if (candidates.size() == 1) {
            return Optional.of(candidates.get(0));
        }
        if (candidates.size() >= 2) {
            if (this.configChildren.stream().map(ConfigChild::getRoleName).anyMatch(roleName -> roleName.equals("child"))) {
                log.warn("ConfigChildSet [{}] has multiple candidates for the default element: [{}]", (Object)this.toString(), (Object)candidates.stream().collect(Collectors.joining(", ")));
            } else {
                log.error("ConfigChildSet [{}] has multiple candidates for the default element: [{}]", (Object)this.toString(), (Object)candidates.stream().collect(Collectors.joining(", ")));
            }
        }
        return Optional.empty();
    }

    private static Stream<String> getCandidatesForGenericElementOptionDefault(ElementRole e) {
        ArrayList<String> result = new ArrayList<String>();
        String forJavaDoc = e.getDefaultElement();
        if (forJavaDoc != null) {
            result.add(forJavaDoc);
        }
        FrankElement forConflictElement = e.getDefaultElementOptionConflict();
        Optional.ofNullable(forConflictElement).map(FrankElement::getFullName).ifPresent(result::add);
        return result.stream();
    }

    public String toString() {
        return "ConfigChildSet(" + this.configChildren.stream().map(ElementChild::toString).collect(Collectors.joining(", ")) + ")";
    }

    public List<ConfigChild> getConfigChildren() {
        return this.configChildren;
    }
}

