/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.DigesterRulesPattern;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.model.TextConfigChild;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankMethod;
import org.xml.sax.SAXException;

abstract class ConfigChildSetterDescriptor {
    private static Logger log = LogUtil.getLogger(ConfigChildSetterDescriptor.class);
    private String methodName;
    private boolean allowMultiple;
    private DigesterRulesPattern pattern;

    ConfigChildSetterDescriptor(String methodName, DigesterRulesPattern pattern) throws SAXException {
        this.methodName = methodName;
        this.pattern = pattern;
        if (methodName.startsWith("set")) {
            this.allowMultiple = false;
        } else if (methodName.startsWith("add") || methodName.startsWith("register")) {
            this.allowMultiple = true;
        } else {
            throw new SAXException(String.format("Do not know how many elements go in method [%s]", methodName));
        }
    }

    String getRoleName() {
        return this.pattern.getRoleName();
    }

    boolean matches(FrankElement frankElement) {
        return this.pattern.getMatcher() == null || this.pattern.getMatcher().matches(frankElement);
    }

    public String toString() {
        return String.format("%s(method = %s, roleName = %s, allowMultiple = %b, pattern = %s)", this.getClass().getSimpleName(), this.methodName, this.getRoleName(), this.allowMultiple, this.pattern.toString());
    }

    abstract ConfigChild createConfigChild(FrankElement var1, FrankMethod var2);

    abstract boolean isForObject();

    static ConfigChildSetterDescriptor find(FrankElement parent, List<ConfigChildSetterDescriptor> descriptors) {
        List<ConfigChildSetterDescriptor> matches = descriptors.stream().filter(d -> d.matches(parent)).collect(Collectors.toList());
        if (matches.isEmpty()) {
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("The following config child setter descriptors match the element role");
            matches.forEach(d -> log.trace("  {}", (Object)d.toString()));
        }
        return (ConfigChildSetterDescriptor)matches.get(0);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isAllowMultiple() {
        return this.allowMultiple;
    }

    public DigesterRulesPattern getPattern() {
        return this.pattern;
    }

    static class ForText
    extends ConfigChildSetterDescriptor {
        ForText(String methodName, DigesterRulesPattern pattern) throws SAXException {
            super(methodName, pattern);
        }

        @Override
        ConfigChild createConfigChild(FrankElement parent, FrankMethod method) {
            return new TextConfigChild(parent, method, this.getRoleName());
        }

        @Override
        boolean isForObject() {
            return false;
        }
    }

    static class ForObject
    extends ConfigChildSetterDescriptor {
        ForObject(String methodName, DigesterRulesPattern pattern) throws SAXException {
            super(methodName, pattern);
        }

        @Override
        ConfigChild createConfigChild(FrankElement parent, FrankMethod method) {
            return new ObjectConfigChild(parent, method);
        }

        @Override
        boolean isForObject() {
            return true;
        }
    }
}

