/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.DigesterRule;
import org.frankframework.frankdoc.util.LogUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class DigesterRulesHandler
extends DefaultHandler {
    protected final Logger log = LogUtil.getLogger(DigesterRulesHandler.class);

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("rule".equals(qName)) {
            DigesterRule rule = new DigesterRule();
            for (int i = 0; i < attributes.getLength(); ++i) {
                String method = attributes.getQName(i);
                String value = attributes.getValue(i);
                try {
                    this.invokeSetter(rule, method, value);
                    continue;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.log.error("unable to set method [" + method + "] with value [" + value + "]");
                    e.printStackTrace();
                }
            }
            this.handle(rule);
        }
    }

    private void invokeSetter(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException {
        Class<?> clazz = bean.getClass();
        try {
            PropertyDescriptor[] pds;
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                if (!pd.getName().equals(name)) continue;
                Object[] args = new Object[]{value};
                pd.getWriteMethod().invoke(bean, args);
            }
        }
        catch (IntrospectionException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected abstract void handle(DigesterRule var1) throws SAXException;
}

