/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.RootFrankElement;
import org.xml.sax.SAXException;

class DigesterRulesPattern {
    private final String originalPattern;
    private List<String> components;
    private Matcher matcher;

    DigesterRulesPattern(String pattern) throws SAXException {
        this.originalPattern = pattern;
        boolean matchesOnlyRoot = false;
        if (StringUtils.isBlank(pattern)) {
            throw new SAXException(String.format("digester-rules.xml: Pattern cannot be null and cannot be blank", new Object[0]));
        }
        this.components = Arrays.asList(pattern.split("/"));
        if (this.components.isEmpty()) {
            throw new SAXException(String.format("digester-rules.xml should not contain an empty pattern. The literal value was [%s]", this.originalPattern));
        }
        List<String> componentsThatShouldNotBeWildcard = this.components;
        if (this.components.get(0).equals("*")) {
            componentsThatShouldNotBeWildcard = this.components.subList(1, this.components.size());
        } else {
            matchesOnlyRoot = true;
        }
        if (componentsThatShouldNotBeWildcard.isEmpty()) {
            throw new SAXException(String.format("digester-rules.xml: A pattern that is only a wildcard is invalid. Encountered [%s]", this.originalPattern));
        }
        if (componentsThatShouldNotBeWildcard.stream().anyMatch(s -> s.equals("*"))) {
            throw new SAXException(String.format("digester-rules.xml: Only the first pattern component can be a wildcard. Encountered [%s]", this.originalPattern));
        }
        if (componentsThatShouldNotBeWildcard.size() >= 2) {
            ArrayList<String> violationCheckWords = new ArrayList<String>(componentsThatShouldNotBeWildcard.subList(0, componentsThatShouldNotBeWildcard.size() - 1));
            Collections.reverse(violationCheckWords);
            this.matcher = new Matcher(violationCheckWords);
            this.matcher.setPatternOnlyMatchesRoot(matchesOnlyRoot);
        }
    }

    String getRoleName() {
        return this.components.get(this.components.size() - 1);
    }

    public String toString() {
        return this.originalPattern;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    static class Matcher {
        private boolean patternOnlyMatchesRoot = false;
        private final List<String> backtrackRoleNames;

        Matcher(List<String> backtrackRoleNames) {
            this.backtrackRoleNames = backtrackRoleNames;
        }

        boolean matches(FrankElement frankElement) {
            return this.checkOwners(Arrays.asList(frankElement), this.backtrackRoleNames);
        }

        boolean checkChildren(List<ConfigChild> configChildren, List<String> remainingBacktrackRoleNames) {
            List<FrankElement> owners = configChildren.stream().map(ElementChild::getOwningElement).collect(Collectors.toList());
            return this.checkOwners(owners, remainingBacktrackRoleNames);
        }

        boolean checkOwners(List<FrankElement> owners, List<String> remainingBacktrackRoleNames) {
            List<ConfigChild> parents;
            boolean haveMatchForRoot = owners.stream().filter(f -> f instanceof RootFrankElement).map(f -> (RootFrankElement)f).anyMatch(f -> f.getRoleName().equals(remainingBacktrackRoleNames.get(0)));
            if (remainingBacktrackRoleNames.size() == 1) {
                if (haveMatchForRoot) {
                    return true;
                }
                if (this.patternOnlyMatchesRoot) {
                    return false;
                }
            }
            if ((parents = owners.stream().flatMap(f -> f.getConfigParents().stream()).filter(c -> c.getRoleName().equals(remainingBacktrackRoleNames.get(0))).collect(Collectors.toList())).isEmpty()) {
                return false;
            }
            if (remainingBacktrackRoleNames.size() == 1) {
                return true;
            }
            return this.checkChildren(parents, remainingBacktrackRoleNames.subList(1, remainingBacktrackRoleNames.size()));
        }

        public String toString() {
            String result = "Matcher backtracking(" + this.backtrackRoleNames.stream().collect(Collectors.joining(", ")) + ")";
            if (this.patternOnlyMatchesRoot) {
                result = result + " at root";
            }
            return result;
        }

        public boolean isPatternOnlyMatchesRoot() {
            return this.patternOnlyMatchesRoot;
        }

        public void setPatternOnlyMatchesRoot(boolean patternOnlyMatchesRoot) {
            this.patternOnlyMatchesRoot = patternOnlyMatchesRoot;
        }
    }
}

