/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.function.Predicate;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.Feature;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.MandatoryStatus;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankMethod;

public abstract class ElementChild {
    private static Logger log = LogUtil.getLogger(ElementChild.class);
    private FrankElement owningElement;
    private boolean deprecated = false;
    private boolean excluded = false;
    private MandatoryStatus mandatoryStatus = MandatoryStatus.OPTIONAL;
    private boolean documented;
    private FrankElement overriddenFrom;
    private boolean reintroduced = false;
    private boolean technicalOverride = false;
    private boolean isOverrideMeaningfulLogged = false;
    private int order = Integer.MAX_VALUE;
    private String description;
    private String defaultValue;
    public static Predicate<ElementChild> IN_XSD = c -> !c.isExcluded() && !c.isDeprecated() && (c.isDocumented() || !c.isTechnicalOverride());
    public static Predicate<ElementChild> IN_COMPATIBILITY_XSD = c -> !c.isExcluded() && (c.isDocumented() || !c.isTechnicalOverride());
    public static Predicate<ElementChild> REJECT_DEPRECATED = c -> c.isExcluded() || c.isDeprecated();
    static Predicate<ElementChild> ALL = c -> true;
    public static Predicate<ElementChild> ALL_NOT_EXCLUDED = c -> !c.isExcluded();
    public static Predicate<ElementChild> EXCLUDED = c -> c.isExcluded();
    public static Predicate<ElementChild> JSON_NOT_INHERITED = c -> c.isExcluded() && c.getOverriddenFrom() != null;
    public static Predicate<ElementChild> JSON_RELEVANT = IN_COMPATIBILITY_XSD.or(JSON_NOT_INHERITED);

    ElementChild(FrankElement owningElement) {
        this.owningElement = owningElement;
    }

    void setExcluded(FrankMethod method) {
        try {
            if (Feature.PROTECTED.isEffectivelySetOn(method)) {
                log.trace("Attribute or config child [{}] has feature PROTECTED, marking as excluded", () -> this.toString());
                this.excluded = true;
            }
        }
        catch (FrankDocException e) {
            log.error("Error checking PROTECTED feature on [{}]", () -> this.toString(), () -> e);
        }
    }

    void clearDefaultValue() {
        this.defaultValue = null;
    }

    void calculateOverriddenFrom() {
        FrankElement match = this.getOwningElement();
        while (match.getParent() != null) {
            ElementChild matchingChild = (match = match.getParent()).findElementChildMatch(this);
            if (matchingChild == null) continue;
            if (matchingChild.isDeprecated()) {
                log.warn("Element child overrides deprecated ElementChild: descendant [{}], super [{}]", () -> this.toString(), () -> matchingChild.toString());
            }
            this.overriddenFrom = match;
            if (!this.overrideIsMeaningful(matchingChild)) {
                this.technicalOverride = true;
            }
            log.trace("{} [{}] of FrankElement [{}] has overriddenFrom = [{}]", () -> this.getClass().getSimpleName(), () -> this.toString(), () -> this.owningElement.getFullName(), () -> this.overriddenFrom.getFullName());
            return;
        }
    }

    final boolean overrideIsMeaningful(ElementChild overriddenFrom) {
        boolean result = this.reintroduced || this.getMandatoryStatus() != overriddenFrom.getMandatoryStatus() || this.isExcluded() != overriddenFrom.isExcluded() || !Utils.equalsNullable(this.getDescription(), overriddenFrom.getDescription()) || !Utils.equalsNullable(this.getDefaultValue(), overriddenFrom.getDefaultValue());
        boolean bl = result = result || this.specificOverrideIsMeaningful(overriddenFrom);
        if (log.isTraceEnabled() && !this.isOverrideMeaningfulLogged && result) {
            this.isOverrideMeaningfulLogged = true;
            log.trace("ElementChld {} overrides {} and changes something relevant for the Frank!Doc", (Object)this.toString(), (Object)overriddenFrom.toString());
        }
        return result;
    }

    abstract boolean specificOverrideIsMeaningful(ElementChild var1);

    void setJavaDocBasedDescriptionAndDefault(FrankMethod method) {
        try {
            String value = method.getJavaDocIncludingInherited();
            if (value != null) {
                this.description = value;
            }
            if ((value = Feature.DEFAULT.valueOf(method)) != null) {
                this.defaultValue = value;
            }
        }
        catch (FrankDocException e) {
            log.error("A FrankDocException occurred when searching the (inherited) javadoc of {}", (Object)method.toString(), (Object)e);
        }
    }

    void parseIbisDocAnnotation(FrankAnnotation ibisDoc) throws FrankDocException {
        String[] ibisDocValues = null;
        try {
            ibisDocValues = (String[])ibisDoc.getValue();
        }
        catch (FrankDocException e) {
            throw new FrankDocException("Could not parse FrankAnnotation of @IbisDoc", e);
        }
        boolean isIbisDocHasOrder = false;
        try {
            Integer.parseInt(ibisDocValues[0]);
            isIbisDocHasOrder = true;
        }
        catch (NumberFormatException e) {
            isIbisDocHasOrder = false;
        }
        if (isIbisDocHasOrder) {
            if (ibisDocValues.length > 1) {
                this.description = ibisDocValues[1];
            }
            if (ibisDocValues.length > 2) {
                this.defaultValue = ibisDocValues[2];
            }
        } else {
            this.description = ibisDocValues[0];
            if (ibisDocValues.length > 1) {
                this.defaultValue = ibisDocValues[1];
            }
        }
    }

    public String toString() {
        return String.format("(Key %s, owner %s)", this.getKey().toString(), this.owningElement.getFullName());
    }

    abstract AbstractKey getKey();

    public FrankElement getOwningElement() {
        return this.owningElement;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public MandatoryStatus getMandatoryStatus() {
        return this.mandatoryStatus;
    }

    void setMandatoryStatus(MandatoryStatus mandatoryStatus) {
        this.mandatoryStatus = mandatoryStatus;
    }

    public boolean isDocumented() {
        return this.documented;
    }

    public void setDocumented(boolean documented) {
        this.documented = documented;
    }

    public FrankElement getOverriddenFrom() {
        return this.overriddenFrom;
    }

    public boolean isReintroduced() {
        return this.reintroduced;
    }

    public void setReintroduced(boolean reintroduced) {
        this.reintroduced = reintroduced;
    }

    public boolean isTechnicalOverride() {
        return this.technicalOverride;
    }

    public void setTechnicalOverride(boolean technicalOverride) {
        this.technicalOverride = technicalOverride;
    }

    int getOrder() {
        return this.order;
    }

    void setOrder(int order) {
        this.order = order;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    static abstract class AbstractKey {
        AbstractKey() {
        }
    }
}

