/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.ElementRoleSet;
import org.frankframework.frankdoc.model.ElementType;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.util.LogUtil;

public class ElementRole
implements Comparable<ElementRole> {
    private static Logger log = LogUtil.getLogger(ElementRole.class);
    private static final Comparator<ElementRole> COMPARATOR = Comparator.comparing(ElementRole::getRoleName).thenComparing(role -> role.getElementType().getFullName());
    private final ElementType elementType;
    private final String roleName;
    private final int roleNameSeq;
    private FrankElement defaultElementOptionConflict;
    private Set<FrankElement> nameConflicts;
    private Set<ElementRoleSet> participatesInRoleSets = new HashSet<ElementRoleSet>();
    private ElementRole highestCommonInterface;

    private ElementRole(ElementType elementType, String roleName, int roleNameSeq) {
        this.elementType = elementType;
        this.roleName = roleName;
        this.roleNameSeq = roleNameSeq;
        this.defaultElementOptionConflict = null;
    }

    public ElementRole getHighestCommonInterface() {
        return this.highestCommonInterface;
    }

    public FrankElement getDefaultElementOptionConflict() {
        return this.defaultElementOptionConflict;
    }

    void addParticipatingRoleSet(ElementRoleSet roleSet) {
        this.participatesInRoleSets.add(roleSet);
    }

    void initConflicts() {
        this.nameConflicts = new HashSet<FrankElement>();
        Map<String, List<FrankElement>> membersByXsdName = this.elementType.getMembers().stream().collect(Collectors.groupingBy(el -> el.getXsdElementName(this)));
        Set conflictNames = membersByXsdName.keySet().stream().filter(name -> ((List)membersByXsdName.get(name)).size() >= 2).collect(Collectors.toSet());
        for (String name2 : conflictNames) {
            Map<Boolean, List<FrankElement>> conflictingElementsByDeprecated = membersByXsdName.get(name2).stream().collect(Collectors.groupingBy(FrankElement::isDeprecated));
            if (conflictingElementsByDeprecated.get(false).size() != 1) {
                log.error("Cannot resolve XML name conflict for non-deprecated FrankElement-s [{}]", () -> FrankElement.describe((Collection)conflictingElementsByDeprecated.get(false)));
                this.nameConflicts.addAll((Collection<FrankElement>)membersByXsdName.get(name2));
                continue;
            }
            log.trace("Found name conflicts for FrankElement-s [{}]", () -> FrankElement.describe((Collection)conflictingElementsByDeprecated.get(true)));
            this.nameConflicts.addAll((Collection<FrankElement>)conflictingElementsByDeprecated.get(true));
        }
        List<FrankElement> defaultOptionConflictCandidates = membersByXsdName.get(this.getGenericOptionElementName());
        if (defaultOptionConflictCandidates != null) {
            HashSet<FrankElement> asSet = new HashSet<FrankElement>(defaultOptionConflictCandidates);
            asSet.removeAll(this.nameConflicts);
            if (asSet.size() == 1) {
                this.defaultElementOptionConflict = (FrankElement)asSet.iterator().next();
            } else if (asSet.size() >= 2) {
                throw new IllegalArgumentException("Programming error. Something went wrong resolving name conflicts, please debug");
            }
        }
    }

    public String getGenericOptionElementName() {
        return Utils.toUpperCamelCase(this.roleName);
    }

    List<FrankElement> getRawMembers() {
        return this.elementType.getMembers().stream().filter(el -> !this.nameConflicts.contains(el)).collect(Collectors.toList());
    }

    public List<FrankElement> getMembers() {
        return this.getRawMembers().stream().filter(frankElement -> this.noConflictingRoleSet((FrankElement)frankElement)).collect(Collectors.toList());
    }

    private boolean noConflictingRoleSet(FrankElement frankElement) {
        return this.participatesInRoleSets.stream().noneMatch(roleSet -> roleSet.conflictsWithGenericElementOptionElementName(frankElement));
    }

    public String createXsdElementName(String kindDifferentiatingWord) {
        return this.getGenericOptionElementName() + kindDifferentiatingWord + this.disambiguation();
    }

    public String getDefaultElement() {
        return this.elementType.getDefaultElement();
    }

    private String disambiguation() {
        if (this.roleNameSeq == 1) {
            return "";
        }
        return "_" + this.roleNameSeq;
    }

    public Key getKey() {
        return new Key(this.elementType.getFullName(), this.roleName);
    }

    @Override
    public int compareTo(ElementRole other) {
        return COMPARATOR.compare(this, other);
    }

    public static List<ElementRole> promoteIfConflict(List<ElementRole> roles) {
        if (roles.size() == 1) {
            return roles;
        }
        return roles.stream().map(ElementRole::getHighestCommonInterface).distinct().collect(Collectors.toList());
    }

    public String toString() {
        return this.getKey().toString();
    }

    public static String describeCollection(Collection<ElementRole> roles) {
        return roles.stream().map(ElementRole::toString).collect(Collectors.joining(", "));
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public String getRoleName() {
        return this.roleName;
    }

    void setHighestCommonInterface(ElementRole highestCommonInterface) {
        this.highestCommonInterface = highestCommonInterface;
    }

    public static final class Key {
        private final String elementTypeName;
        private final String elementTypeSimpleName;
        private final String roleName;

        public Key(String elementTypeName, String roleName) {
            this.elementTypeName = elementTypeName;
            this.roleName = roleName;
            int index = elementTypeName.lastIndexOf(".");
            this.elementTypeSimpleName = elementTypeName.substring(index + 1);
        }

        public Key(ObjectConfigChild configChild) {
            this(configChild.getElementType().getFullName(), configChild.getRoleName());
        }

        public String toString() {
            return "(" + this.elementTypeSimpleName + ", " + this.roleName + ")";
        }

        public static String describeCollection(Collection<Key> keys) {
            return keys.stream().map(key -> key.toString()).collect(Collectors.joining(", "));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            String this$elementTypeName = this.getElementTypeName();
            String other$elementTypeName = other.getElementTypeName();
            if (this$elementTypeName == null ? other$elementTypeName != null : !this$elementTypeName.equals(other$elementTypeName)) {
                return false;
            }
            String this$elementTypeSimpleName = this.getElementTypeSimpleName();
            String other$elementTypeSimpleName = other.getElementTypeSimpleName();
            if (this$elementTypeSimpleName == null ? other$elementTypeSimpleName != null : !this$elementTypeSimpleName.equals(other$elementTypeSimpleName)) {
                return false;
            }
            String this$roleName = this.getRoleName();
            String other$roleName = other.getRoleName();
            return !(this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $elementTypeName = this.getElementTypeName();
            result = result * 59 + ($elementTypeName == null ? 43 : $elementTypeName.hashCode());
            String $elementTypeSimpleName = this.getElementTypeSimpleName();
            result = result * 59 + ($elementTypeSimpleName == null ? 43 : $elementTypeSimpleName.hashCode());
            String $roleName = this.getRoleName();
            result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
            return result;
        }

        public String getElementTypeName() {
            return this.elementTypeName;
        }

        public String getElementTypeSimpleName() {
            return this.elementTypeSimpleName;
        }

        public String getRoleName() {
            return this.roleName;
        }
    }

    static class Factory {
        private final Map<String, Integer> numUsagePerRoleName = new HashMap<String, Integer>();

        Factory() {
        }

        ElementRole create(ElementType elementType, String roleName) {
            return new ElementRole(elementType, roleName, this.newRoleNameSeq(roleName));
        }

        private int newRoleNameSeq(String roleName) {
            int maxExistingRoleNameSeq = this.numUsagePerRoleName.getOrDefault(roleName, 0);
            int roleNameSeq = maxExistingRoleNameSeq + 1;
            this.numUsagePerRoleName.put(roleName, roleNameSeq);
            return roleNameSeq;
        }
    }
}

