/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.model.FrankElement;

class ElementRoleSet {
    private final Set<ElementRole> roles;
    private Set<FrankElement> conflicts;

    ElementRoleSet(Set<ElementRole> roles) {
        this.roles = roles;
        roles.forEach(role -> role.addParticipatingRoleSet(this));
    }

    void initConflicts() {
        HashMap<String, Set> byXsdElementName = new HashMap<String, Set>();
        for (ElementRole role : this.roles) {
            Map<String, List<FrankElement>> roleMembersByName = role.getRawMembers().stream().collect(Collectors.groupingBy(elem -> elem.getXsdElementName(role)));
            for (String name2 : roleMembersByName.keySet()) {
                byXsdElementName.merge(name2, new HashSet(roleMembersByName.get(name2)), FrankElement::join);
            }
        }
        Set nameConflicts = byXsdElementName.keySet().stream().filter(name -> ((Set)byXsdElementName.get(name)).size() >= 2).collect(Collectors.toSet());
        this.conflicts = nameConflicts.stream().flatMap(name -> ((Set)byXsdElementName.get(name)).stream()).collect(Collectors.toSet());
    }

    boolean conflictsWithGenericElementOptionElementName(FrankElement frankElement) {
        return this.conflicts.contains(frankElement);
    }

    public String toString() {
        return ElementRole.describeCollection(this.roles);
    }
}

