/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.FrankDocGroup;
import org.frankframework.frankdoc.model.FrankDocModel;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassRepository;
import org.frankframework.frankdoc.wrapper.FrankDocException;

public class ElementType
implements Comparable<ElementType> {
    private static Logger log = LogUtil.getLogger(ElementType.class);
    private static final String JAVADOC_DEFAULT_CLASSNAME = "@ff.defaultElement";
    private static final Comparator<ElementType> COMPARATOR = Comparator.comparing(ElementType::getSimpleName).thenComparing(ElementType::getFullName);
    private List<FrankElement> members;
    private boolean fromJavaInterface;
    private final InterfaceHierarchyItem interfaceHierarchy;
    private List<ElementType> commonInterfaceHierarchy;
    private final FrankDocGroup group;
    private final String defaultElement;

    ElementType(FrankClass clazz, FrankDocGroup group, FrankClassRepository repository) {
        this.interfaceHierarchy = new InterfaceHierarchyItem(clazz);
        this.members = new ArrayList<FrankElement>();
        this.fromJavaInterface = clazz.isInterface();
        this.group = group;
        this.defaultElement = ElementType.parseDefaultElementTag(clazz, repository);
    }

    private static String parseDefaultElementTag(FrankClass clazz, FrankClassRepository repository) {
        String result = null;
        String value = clazz.getJavaDocTag(JAVADOC_DEFAULT_CLASSNAME);
        if (StringUtils.isBlank(value)) {
            if (value != null) {
                log.error("JavaDoc tag {} of interface [{}] should have a parameter", (Object)JAVADOC_DEFAULT_CLASSNAME, (Object)clazz.getName());
            }
        } else {
            try {
                FrankClass defaultClass = repository.findClass(value);
                result = defaultClass.getName();
            }
            catch (FrankDocException e) {
                log.error("JavaDoc tag {} on interface [{}] does not point to a valid class: [{}]", (Object)JAVADOC_DEFAULT_CLASSNAME, (Object)clazz.getName(), (Object)value, (Object)e);
            }
        }
        return result;
    }

    public String getFullName() {
        return this.interfaceHierarchy.getFullName();
    }

    public String getSimpleName() {
        return this.interfaceHierarchy.getSimpleName();
    }

    String getGroupName() {
        String result = this.getSimpleName();
        if (result.startsWith("I")) {
            result = result.substring(1);
        }
        return result;
    }

    void addMember(FrankElement member) {
        Utils.addToSortedListNonUnique(this.members, member);
    }

    void calculateCommonInterfaceHierarchy(FrankDocModel model) {
        this.commonInterfaceHierarchy = new ArrayList<ElementType>();
        this.commonInterfaceHierarchy.add(this);
        ElementType nextCandidate = this.commonInterfaceHierarchy.get(this.commonInterfaceHierarchy.size() - 1).getNextCommonInterface(model);
        while (nextCandidate != null) {
            this.commonInterfaceHierarchy.add(nextCandidate);
            nextCandidate = this.commonInterfaceHierarchy.get(this.commonInterfaceHierarchy.size() - 1).getNextCommonInterface(model);
        }
        if (log.isTraceEnabled()) {
            String commonInterfaceHierarchyStr = this.commonInterfaceHierarchy.stream().map(ElementType::getFullName).collect(Collectors.joining(", "));
            log.trace("ElementType [{}] has common interface hierarchy [{}]", (Object)this.getFullName(), (Object)commonInterfaceHierarchyStr);
        }
    }

    public ElementType getHighestCommonInterface() {
        return this.commonInterfaceHierarchy.get(this.commonInterfaceHierarchy.size() - 1);
    }

    private ElementType getNextCommonInterface(FrankDocModel model) {
        if (!this.fromJavaInterface) {
            return null;
        }
        ArrayList<ElementType> candidates = new ArrayList<ElementType>();
        for (String key : this.interfaceHierarchy.getParentInterfaces().keySet()) {
            candidates.addAll(this.interfaceHierarchy.getParentInterfaces().get(key).findMatchingElementTypes(model));
        }
        if (candidates.isEmpty()) {
            return null;
        }
        ElementType result = (ElementType)candidates.get(0);
        if (candidates.size() >= 2) {
            log.error("There are multiple candidates for the next common interface of ElementType [{}], which are [{}]. Chose [{}]", () -> this.getFullName(), () -> candidates.stream().map(ElementType::getFullName).collect(Collectors.joining(", ")), () -> result.getFullName());
        }
        return result;
    }

    public List<FrankElement> getSyntax2Members() {
        return this.members.stream().filter(frankElement -> !frankElement.getXmlElementNames().isEmpty()).filter(f -> !f.syntax2ExcludedFromType(this.getFullName())).sorted().collect(Collectors.toList());
    }

    @Override
    public int compareTo(ElementType other) {
        return COMPARATOR.compare(this, other);
    }

    public String toString() {
        return "ElementType " + this.interfaceHierarchy.getFullName();
    }

    List<FrankElement> getMembers() {
        return this.members;
    }

    public boolean isFromJavaInterface() {
        return this.fromJavaInterface;
    }

    public List<ElementType> getCommonInterfaceHierarchy() {
        return this.commonInterfaceHierarchy;
    }

    public FrankDocGroup getGroup() {
        return this.group;
    }

    public String getDefaultElement() {
        return this.defaultElement;
    }

    private static class InterfaceHierarchyItem {
        private String fullName;
        private String simpleName;
        private Map<String, InterfaceHierarchyItem> parentInterfaces = new TreeMap<String, InterfaceHierarchyItem>();

        InterfaceHierarchyItem(FrankClass clazz) {
            this.fullName = clazz.getName();
            this.simpleName = clazz.getSimpleName();
            if (clazz.isInterface()) {
                for (FrankClass superInterface : clazz.getInterfaces()) {
                    InterfaceHierarchyItem superInterfaceHierarchyItem = new InterfaceHierarchyItem(superInterface);
                    this.parentInterfaces.put(superInterfaceHierarchyItem.getFullName(), superInterfaceHierarchyItem);
                }
            }
        }

        List<ElementType> findMatchingElementTypes(FrankDocModel model) {
            ElementType currentMatch = model.findElementType(this.fullName);
            if (currentMatch != null) {
                return Arrays.asList(currentMatch);
            }
            ArrayList<ElementType> result = new ArrayList<ElementType>();
            for (String parentKey : this.parentInterfaces.keySet()) {
                result.addAll(this.parentInterfaces.get(parentKey).findMatchingElementTypes(model));
            }
            return result;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public Map<String, InterfaceHierarchyItem> getParentInterfaces() {
            return this.parentInterfaces;
        }
    }
}

