/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.EnumSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.AttributeEnum;
import org.frankframework.frankdoc.model.AttributeType;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.MandatoryStatus;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankType;

public class FrankAttribute
extends ElementChild {
    private static Logger log = LogUtil.getLogger(FrankAttribute.class);
    static final String JAVADOC_ATTRIBUTE_REF = "@ff.ref";
    private String name;
    private FrankElement describingElement;
    private AttributeType attributeType;
    private AttributeEnum attributeEnum;

    public FrankAttribute(String name, FrankElement attributeOwner) {
        super(attributeOwner);
        this.name = name;
        this.describingElement = attributeOwner;
    }

    @Override
    public Key getKey() {
        return new Key(this.name);
    }

    @Override
    boolean specificOverrideIsMeaningful(ElementChild overriddenFrom) {
        return !Utils.equalsNullable(this.getAttributeEnum(), ((FrankAttribute)overriddenFrom).getAttributeEnum());
    }

    void handleDefaultExplicitNull(FrankType parameterType) {
        boolean isExplicitNull;
        if (this.getDefaultValue() == null) {
            return;
        }
        if (EnumSet.of(MandatoryStatus.MANDATORY, MandatoryStatus.BECOMES_MANDATORY).contains((Object)this.getMandatoryStatus())) {
            log.warn("Attribute [{}] is [{}], but it also has a default value: [{}]", (Object)this.toString(), (Object)this.getMandatoryStatus(), (Object)this.getDefaultValue());
        }
        boolean bl = isExplicitNull = StringUtils.isBlank(this.getDefaultValue()) || this.getDefaultValue().equals("null");
        if (isExplicitNull && parameterType.isPrimitive()) {
            log.error("Attribute [{}] is of primitive type [{}] but has default value null", (Object)this.toString(), (Object)parameterType.toString());
            return;
        }
        if (isExplicitNull) {
            log.trace("Attribute [{}] has explicit default value [{}], clearing the default value", () -> this.toString(), () -> this.getDefaultValue());
            this.clearDefaultValue();
        }
    }

    @Override
    public String toString() {
        return String.format("%s.%s", this.getOwningElement().getSimpleName(), this.name);
    }

    public String getName() {
        return this.name;
    }

    public FrankElement getDescribingElement() {
        return this.describingElement;
    }

    public void setDescribingElement(FrankElement describingElement) {
        this.describingElement = describingElement;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public AttributeEnum getAttributeEnum() {
        return this.attributeEnum;
    }

    public void setAttributeEnum(AttributeEnum attributeEnum) {
        this.attributeEnum = attributeEnum;
    }

    static class Key
    extends ElementChild.AbstractKey {
        private String name;

        Key(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.name;
            String other$name = other.name;
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Key;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.name;
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }
    }
}

