/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.ElementType;
import org.frankframework.frankdoc.util.LogUtil;

public class FrankDocGroup
implements Comparable<FrankDocGroup> {
    private static Logger log = LogUtil.getLogger(FrankDocGroup.class);
    private static final Comparator<FrankDocGroup> COMPARATOR = Comparator.comparingInt(FrankDocGroup::getOrder).thenComparing(FrankDocGroup::getName);
    public static String GROUP_NAME_OTHER = "Other";
    private final String name;
    private int order = Integer.MAX_VALUE;
    private List<ElementType> elementTypes = new ArrayList<ElementType>();

    FrankDocGroup(String name) {
        this.name = name;
    }

    void setOrder(int newOrder) {
        if (newOrder == Integer.MAX_VALUE) {
            return;
        }
        if (this.order == Integer.MAX_VALUE) {
            this.order = newOrder;
        } else if (newOrder != this.order) {
            int selectedOrder = Math.min(this.order, newOrder);
            log.error("Conflicting order values for group {}. Old {}, new {}, selected {}", (Object)this.name, (Object)this.order, (Object)newOrder, (Object)selectedOrder);
            this.order = selectedOrder;
        }
    }

    @Override
    public int compareTo(FrankDocGroup other) {
        return COMPARATOR.compare(this, other);
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public List<ElementType> getElementTypes() {
        return this.elementTypes;
    }

    void setElementTypes(List<ElementType> elementTypes) {
        this.elementTypes = elementTypes;
    }
}

