/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.model.FrankDocGroup;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankDocException;

class FrankDocGroupFactory {
    static final String JAVADOC_GROUP_ANNOTATION = "nl.nn.adapterframework.doc.FrankDocGroup";
    private static Logger log = LogUtil.getLogger(FrankDocGroupFactory.class);
    private final Map<String, FrankDocGroup> allGroups = new HashMap<String, FrankDocGroup>();

    FrankDocGroupFactory() {
        FrankDocGroup groupOther = new FrankDocGroup(FrankDocGroup.GROUP_NAME_OTHER);
        this.allGroups.put(groupOther.getName(), groupOther);
    }

    FrankDocGroup getGroup(FrankClass clazz) {
        FrankDocGroup result = null;
        try {
            FrankAnnotation annotation = clazz.getAnnotationIncludingInherited(JAVADOC_GROUP_ANNOTATION);
            if (annotation == null) {
                result = this.getGroup(FrankDocGroup.GROUP_NAME_OTHER);
            } else {
                String groupName = (String)annotation.getValueOf("name");
                Integer groupOrder = (Integer)annotation.getValueOf("order");
                log.trace("FrankDocGroup requested for group name {} with new order {}", () -> groupName, () -> groupOrder);
                result = this.getGroup(groupName, groupOrder);
            }
        }
        catch (FrankDocException e) {
            log.error("Class [{}] has invalid @FrankDocGroup: {}", (Object)clazz.getName(), (Object)e.getMessage());
            return this.getGroup(FrankDocGroup.GROUP_NAME_OTHER);
        }
        return result;
    }

    FrankDocGroup getGroup(String groupName, Integer groupOrder) {
        FrankDocGroup result = this.getGroup(groupName);
        if (groupOrder == null) {
            groupOrder = Integer.MAX_VALUE;
        }
        result.setOrder(groupOrder);
        return result;
    }

    private FrankDocGroup getGroup(String name) {
        if (this.allGroups.containsKey(name)) {
            return this.allGroups.get(name);
        }
        FrankDocGroup group = new FrankDocGroup(name);
        this.allGroups.put(name, group);
        return group;
    }

    List<FrankDocGroup> getAllGroups() {
        ArrayList<FrankDocGroup> result = new ArrayList<FrankDocGroup>(this.allGroups.values());
        Collections.sort(result);
        return result;
    }
}

