/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.AttributeEnum;
import org.frankframework.frankdoc.model.AttributeEnumFactory;
import org.frankframework.frankdoc.model.AttributeType;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ConfigChildGroupKind;
import org.frankframework.frankdoc.model.ConfigChildSet;
import org.frankframework.frankdoc.model.ConfigChildSetterDescriptor;
import org.frankframework.frankdoc.model.DigesterRule;
import org.frankframework.frankdoc.model.DigesterRulesHandler;
import org.frankframework.frankdoc.model.DigesterRulesPattern;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.model.ElementRoleSet;
import org.frankframework.frankdoc.model.ElementType;
import org.frankframework.frankdoc.model.Feature;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.model.FrankDocGroup;
import org.frankframework.frankdoc.model.FrankDocGroupFactory;
import org.frankframework.frankdoc.model.FrankElement;
import org.frankframework.frankdoc.model.MandatoryStatus;
import org.frankframework.frankdoc.model.ObjectConfigChild;
import org.frankframework.frankdoc.model.RootFrankElement;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassRepository;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankMethod;
import org.frankframework.frankdoc.wrapper.FrankProgramElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FrankDocModel {
    private static Logger log = LogUtil.getLogger(FrankDocModel.class);
    private static String ENUM = "Enum";
    private static List<String> EXPECTED_HTML_TAGS = Arrays.asList("a", "b", "br", "code", "h1", "h2", "h3", "h4", "i", "li", "ol", "p", "pre", "strong", "table", "td", "th", "tr", "ul");
    private FrankClassRepository classRepository;
    private Map<String, List<ConfigChildSetterDescriptor>> configChildDescriptors = new HashMap<String, List<ConfigChildSetterDescriptor>>();
    private FrankDocGroupFactory groupFactory = new FrankDocGroupFactory();
    private List<FrankDocGroup> groups;
    private Map<String, FrankElement> allElements = new LinkedHashMap<String, FrankElement>();
    private Map<String, ElementType> allTypes = new LinkedHashMap<String, ElementType>();
    private List<FrankElement> elementsOutsideConfigChildren;
    private Map<ElementRole.Key, ElementRole> allElementRoles = new HashMap<ElementRole.Key, ElementRole>();
    private final ElementRole.Factory elementRoleFactory = new ElementRole.Factory();
    private Map<Set<ElementRole.Key>, ElementRoleSet> allElementRoleSets = new HashMap<Set<ElementRole.Key>, ElementRoleSet>();
    private AttributeEnumFactory attributeEnumFactory = new AttributeEnumFactory();
    private String rootClassName;

    FrankDocModel(FrankClassRepository classRepository, String rootClassName) {
        this.classRepository = classRepository;
        this.rootClassName = rootClassName;
    }

    public static FrankDocModel populate(URL digesterRules, String rootClassName, FrankClassRepository classRepository) {
        FrankDocModel result = new FrankDocModel(classRepository, rootClassName);
        try {
            log.trace("Populating FrankDocModel");
            result.createConfigChildDescriptorsFrom(digesterRules);
            result.findOrCreateRootFrankElement(rootClassName);
            result.buildDescendants();
            result.allElements.values().forEach(f -> result.finishConfigChildrenFor((FrankElement)f));
            result.checkSuspiciousHtml();
            result.calculateTypeNameSeq();
            result.calculateInterfaceBased();
            result.calculateCommonInterfacesHierarchies();
            result.setHighestCommonInterface();
            result.setOverriddenFrom();
            result.createConfigChildSets();
            result.setElementNamesOfFrankElements(rootClassName);
            result.buildGroups();
        }
        catch (Exception e) {
            log.fatal("Could not populate FrankDocModel", (Throwable)e);
            return null;
        }
        log.trace("Done populating FrankDocModel");
        return result;
    }

    void createConfigChildDescriptorsFrom(URL digesterRules) throws IOException, SAXException {
        log.trace("Creating config child descriptors from file [{}]", () -> digesterRules.toString());
        InputSource digesterRulesInputSource = Utils.asInputSource(digesterRules);
        try {
            Utils.parseXml(digesterRulesInputSource, new Handler());
            log.trace("Successfully created config child descriptors");
        }
        catch (IOException e) {
            throw new IOException(String.format("An IOException occurred while parsing XML from [%s]", digesterRulesInputSource.getSystemId()), e);
        }
        catch (SAXException e) {
            throw new SAXException(String.format("A SAXException occurred while parsing XML from [%s]", digesterRulesInputSource.getSystemId()), e);
        }
    }

    public boolean hasType(String typeName) {
        return this.allTypes.containsKey(typeName);
    }

    void buildDescendants() throws Exception {
        boolean addedDescendants;
        log.trace("Enter");
        int pass = 1;
        do {
            addedDescendants = false;
            if (log.isTraceEnabled()) {
                log.trace("Pass [{}]", (Object)pass++);
            }
            for (FrankElement existing : new ArrayList<FrankElement>(this.allElements.values())) {
                if (!this.createConfigChildren(existing)) continue;
                addedDescendants = true;
            }
        } while (addedDescendants);
        log.trace("Leave");
    }

    FrankElement findOrCreateRootFrankElement(String fullClassName) throws FrankDocException {
        return this.findOrCreateFrankElement(fullClassName, new FrankElementCreationStrategyRoot());
    }

    FrankElement findOrCreateFrankElement(String fullClassName) throws FrankDocException {
        return this.findOrCreateFrankElement(fullClassName, new FrankElementCreationStrategyNonRoot());
    }

    FrankElement findOrCreateFrankElement(String fullClassName, FrankElementCreationStrategy creator) throws FrankDocException {
        FrankClass clazz = this.classRepository.findClass(fullClassName);
        log.trace("FrankElement requested for class name [{}]", () -> clazz.getName());
        if (this.allElements.containsKey(clazz.getName())) {
            log.trace("Already present");
            return this.allElements.get(clazz.getName());
        }
        log.trace("Creating FrankElement for class name [{}]", () -> clazz.getName());
        FrankElement current = creator.createFromClass(clazz);
        log.trace("Created [{}] [{}]", (Object)current.getClass().getSimpleName(), (Object)current.getFullName());
        this.allElements.put(clazz.getName(), current);
        FrankClass superClass = clazz.getSuperclass();
        FrankElement parent = superClass == null ? null : creator.recursiveFindOrCreate(superClass.getName());
        current.setParent(parent);
        current.setAttributes(this.createAttributes(clazz, current));
        log.trace("Done creating FrankElement for class name [{}]", () -> clazz.getName());
        return current;
    }

    public FrankElement findFrankElement(String fullName) {
        return this.allElements.get(fullName);
    }

    List<FrankAttribute> createAttributes(FrankClass clazz, FrankElement attributeOwner) throws FrankDocException {
        log.trace("Creating attributes for FrankElement [{}]", () -> attributeOwner.getFullName());
        this.checkForAttributeSetterOverloads(clazz);
        FrankMethod[] methods = clazz.getDeclaredMethodsAndMultiplyInheritedPlaceholders();
        Map<String, FrankMethod> enumGettersByAttributeName = FrankDocModel.getEnumGettersByAttributeName(clazz);
        LinkedHashMap<String, FrankMethod> setterAttributes = FrankDocModel.getAttributeToMethodMap(methods, "set");
        Map<String, FrankMethod> getterAttributes = this.getGetterAndIsserAttributes(methods, attributeOwner);
        ArrayList<FrankAttribute> result = new ArrayList<FrankAttribute>();
        for (Map.Entry<String, FrankMethod> entry : setterAttributes.entrySet()) {
            String attributeName = entry.getKey();
            log.trace("Attribute [{}]", () -> attributeName);
            FrankMethod method = entry.getValue();
            if (log.isTraceEnabled() && method.isMultiplyInheritedPlaceholder()) {
                log.trace("Attribute [{}] does not come from a declared method, but may be relevant because of multiple inheritance", (Object)attributeName);
            }
            if (getterAttributes.containsKey(attributeName)) {
                this.checkForTypeConflict(method, getterAttributes.get(attributeName), attributeOwner);
            }
            FrankAttribute attribute = new FrankAttribute(attributeName, attributeOwner);
            try {
                attribute.setMandatoryStatus(MandatoryStatus.fromMethod(method));
            }
            catch (FrankDocException e) {
                log.error("Could not calculate mandatoryStatus for attribute [{}]", (Object)attribute.getName(), (Object)e);
            }
            if (method.getParameterTypes()[0].isEnum()) {
                log.trace("Attribute [{}] has setter that takes enum: [{}]", () -> attribute.getName(), () -> method.getParameterTypes()[0].toString());
                attribute.setAttributeType(AttributeType.STRING);
                attribute.setAttributeEnum(this.findOrCreateAttributeEnum((FrankClass)method.getParameterTypes()[0]));
            } else {
                attribute.setAttributeType(AttributeType.fromJavaType(method.getParameterTypes()[0].getName()));
                log.trace("Attribute {} has type {}", () -> attributeName, () -> attribute.getAttributeType().toString());
                if (enumGettersByAttributeName.containsKey(attributeName)) {
                    log.trace("Attribute {} has enum values", () -> attributeName);
                    attribute.setAttributeEnum(this.findOrCreateAttributeEnum((FrankClass)enumGettersByAttributeName.get(attributeName).getReturnType()));
                }
            }
            attribute.setDeprecated(Feature.DEPRECATED.isSetOn(method));
            attribute.setReintroduced(Feature.REINTRODUCE.isSetOn(method));
            log.trace("Attribute {} deprecated={}, reintroduced={}", () -> attributeName, () -> attribute.isDeprecated(), () -> attribute.isReintroduced());
            this.documentAttribute(attribute, method, attributeOwner);
            log.trace("Default [{}]", () -> attribute.getDefaultValue());
            attribute.setExcluded(method);
            result.add(attribute);
            log.trace("Attribute [{}] done", () -> attributeName);
        }
        log.trace("Done creating attributes for {}", (Object)attributeOwner.getFullName());
        return result;
    }

    private void checkForAttributeSetterOverloads(FrankClass clazz) {
        List<FrankMethod> cumulativeAttributeSetters = FrankDocModel.getAttributeMethodList(clazz.getDeclaredAndInheritedMethods(), "set");
        Map<String, List<FrankMethod>> attributeSettersByAttributeName = cumulativeAttributeSetters.stream().collect(Collectors.groupingBy(m -> FrankDocModel.attributeOf(m.getName(), "set")));
        for (String attributeName : attributeSettersByAttributeName.keySet()) {
            List<FrankMethod> attributeSetterCandidates = attributeSettersByAttributeName.get(attributeName);
            List candidateTypes = attributeSetterCandidates.stream().map(m -> m.getParameterTypes()[0].getName()).distinct().sorted().collect(Collectors.toList());
            if (candidateTypes.size() < 2) continue;
            log.error("Class [{}] has overloaded declared or inherited attribute setters. Type of attribute [{}] can be any of [{}]", (Object)clazz.getName(), (Object)attributeName, (Object)candidateTypes.stream().collect(Collectors.joining(", ")));
        }
    }

    private Map<String, FrankMethod> getGetterAndIsserAttributes(FrankMethod[] methods, FrankElement attributeOwner) {
        LinkedHashMap<String, FrankMethod> getterAttributes = FrankDocModel.getAttributeToMethodMap(methods, "get");
        LinkedHashMap<String, FrankMethod> isserAttributes = FrankDocModel.getAttributeToMethodMap(methods, "is");
        for (String isserAttributeName : isserAttributes.keySet()) {
            if (getterAttributes.containsKey(isserAttributeName)) {
                log.warn("For FrankElement [{}], attribute [{}] has both a getX and an isX method", () -> attributeOwner.getSimpleName(), () -> isserAttributeName);
                continue;
            }
            getterAttributes.put(isserAttributeName, (FrankMethod)isserAttributes.get(isserAttributeName));
        }
        return getterAttributes;
    }

    static LinkedHashMap<String, FrankMethod> getAttributeToMethodMap(FrankMethod[] methods, String prefix) {
        LinkedHashMap<String, FrankMethod> result = new LinkedHashMap<String, FrankMethod>();
        for (FrankMethod method : FrankDocModel.getAttributeMethodList(methods, prefix)) {
            String attributeName = FrankDocModel.attributeOf(method.getName(), prefix);
            result.put(attributeName, method);
        }
        return result;
    }

    private static List<FrankMethod> getAttributeMethodList(FrankMethod[] methods, String prefix) {
        List<FrankMethod> methodList = Arrays.asList(methods);
        return methodList.stream().filter(FrankProgramElement::isPublic).filter(Utils::isAttributeGetterOrSetter).filter(m -> m.getName().startsWith(prefix) && m.getName().length() > prefix.length()).collect(Collectors.toList());
    }

    private static String attributeOf(String methodName, String prefix) {
        String strippedName = methodName.substring(prefix.length());
        String attributeName = strippedName.substring(0, 1).toLowerCase() + strippedName.substring(1);
        return attributeName;
    }

    static Map<String, FrankMethod> getEnumGettersByAttributeName(FrankClass clazz) {
        FrankMethod[] rawMethods = clazz.getDeclaredAndInheritedMethods();
        List methods = Arrays.asList(rawMethods).stream().filter(m -> m.getName().endsWith(ENUM)).filter(m -> m.getReturnType().isEnum()).filter(m -> m.getParameterCount() == 0).filter(FrankProgramElement::isPublic).collect(Collectors.toList());
        HashMap<String, FrankMethod> result = new HashMap<String, FrankMethod>();
        for (FrankMethod m2 : methods) {
            result.put(FrankDocModel.enumAttributeOf(m2), m2);
        }
        return result;
    }

    private static String enumAttributeOf(FrankMethod method) {
        String nameWithoutEnum = method.getName().substring(0, method.getName().length() - ENUM.length());
        return FrankDocModel.attributeOf(nameWithoutEnum, "get");
    }

    private void checkForTypeConflict(FrankMethod setter, FrankMethod getter, FrankElement attributeOwner) {
        log.trace("Checking for type conflict with getter or isser [{}]", () -> getter.getName());
        String setterType = setter.getParameterTypes()[0].getName();
        String getterType = getter.getReturnType().getName();
        if (getter.getName().startsWith("get")) {
            setterType = Utils.promoteIfPrimitive(setterType);
            getterType = Utils.promoteIfPrimitive(getterType);
        }
        if (!getterType.equals(setterType) && log.isWarnEnabled()) {
            log.error("In Frank element [{}]: setter [{}] has type [{}] while the getter has type [{}]", (Object)attributeOwner.getSimpleName(), (Object)setter.getName(), (Object)setterType, (Object)getterType);
        }
    }

    private void documentAttribute(FrankAttribute attribute, FrankMethod method, FrankElement attributeOwner) throws FrankDocException {
        FrankAnnotation ibisDoc;
        attribute.setDocumented(method.getAnnotation("nl.nn.adapterframework.doc.IbisDoc") != null || method.getAnnotation("nl.nn.adapterframework.doc.IbisDocRef") != null || method.getJavaDoc() != null || Feature.DEFAULT.isSetOn(method) || Feature.MANDATORY.isSetOn(method) || Feature.OPTIONAL.isSetOn(method) || method.getJavaDocTag("@ff.ref") != null);
        log.trace("Attribute: deprecated = [{}], documented = [{}]", () -> attribute.isDeprecated(), () -> attribute.isDocumented());
        String ffRefReference = method.getJavaDocTag("@ff.ref");
        if (ffRefReference != null) {
            if (StringUtils.isBlank(ffRefReference)) {
                log.error("JavaDoc tag {} should have a full class name or full method name as argument", (Object)"@ff.ref");
            } else {
                FrankMethod referred = this.getReferredMethod(ffRefReference, method);
                if (referred == null) {
                    log.error("Referred method [{}] does not exist", (Object)ffRefReference);
                } else {
                    attribute.setDescribingElement(this.findOrCreateFrankElement(referred.getDeclaringClass().getName()));
                    attribute.setJavaDocBasedDescriptionAndDefault(referred);
                }
            }
        }
        attribute.setJavaDocBasedDescriptionAndDefault(method);
        FrankAnnotation ibisDocRef = method.getAnnotationIncludingInherited("nl.nn.adapterframework.doc.IbisDocRef");
        if (ibisDocRef != null) {
            log.trace("Found @IbisDocRef annotation");
            ParsedIbisDocRef parsed = this.parseIbisDocRef(ibisDocRef, method);
            FrankAnnotation ibisDoc2 = null;
            if (parsed != null && parsed.getReferredMethod() != null) {
                attribute.setJavaDocBasedDescriptionAndDefault(parsed.getReferredMethod());
                ibisDoc2 = parsed.getReferredMethod().getAnnotationIncludingInherited("nl.nn.adapterframework.doc.IbisDoc");
                if (ibisDoc2 != null) {
                    attribute.setDescribingElement(this.findOrCreateFrankElement(parsed.getReferredMethod().getDeclaringClass().getName()));
                    log.trace("Describing element of attribute [{}].[{}] is [{}]", () -> attributeOwner.getFullName(), () -> attribute.getName(), () -> attribute.getDescribingElement().getFullName());
                    attribute.parseIbisDocAnnotation(ibisDoc2);
                    log.trace("Done documenting attribute [{}]", () -> attribute.getName());
                    return;
                }
            } else {
                log.error("@IbisDocRef of Frank elelement [{}] attribute [{}] points to non-existent method", () -> attributeOwner.getSimpleName(), () -> attribute.getName());
            }
        }
        if ((ibisDoc = method.getAnnotationIncludingInherited("nl.nn.adapterframework.doc.IbisDoc")) != null) {
            log.trace("For attribute [{}], have @IbisDoc without @IbisDocRef", (Object)attribute);
            attribute.parseIbisDocAnnotation(ibisDoc);
        }
        attribute.handleDefaultExplicitNull(method.getParameterTypes()[0]);
        log.trace("Done documenting attribute [{}]", () -> attribute.getName());
    }

    private ParsedIbisDocRef parseIbisDocRef(FrankAnnotation ibisDocRef, FrankMethod originalMethod) {
        ParsedIbisDocRef result = new ParsedIbisDocRef();
        result.setHasOrder(false);
        String[] values = null;
        try {
            values = (String[])ibisDocRef.getValue();
        }
        catch (FrankDocException e) {
            log.error("IbisDocRef annotation did not have a value", (Throwable)e);
            return result;
        }
        String methodString = null;
        if (values.length == 1) {
            methodString = values[0];
        } else if (values.length == 2) {
            methodString = values[1];
            try {
                result.setOrder(Integer.parseInt(values[0]));
                result.setHasOrder(true);
            }
            catch (Throwable t) {
                String[] finalValues = values;
                log.error("Could not parse order in @IbisDocRef annotation: [{}]", () -> finalValues[0]);
            }
        } else {
            log.error("Too many or zero parameters in @IbisDocRef annotation on method: [{}].[{}]", () -> originalMethod.getDeclaringClass().getName(), () -> originalMethod.getName());
            return null;
        }
        try {
            result.setReferredMethod(this.getReferredMethod(methodString, originalMethod));
        }
        catch (Exception e) {
            log.error("@IbisDocRef on [{}].[{}] annotation references invalid method [{}], ignoring @IbisDocRef annotation", (Object)originalMethod.getDeclaringClass().getName(), (Object)originalMethod.getName(), (Object)methodString);
            return null;
        }
        return result;
    }

    private FrankMethod getReferredMethod(String methodString, FrankMethod originalMethod) {
        String lastNameComponent = methodString.substring(methodString.lastIndexOf(".") + 1).trim();
        char firstLetter = lastNameComponent.toCharArray()[0];
        String fullClassName = methodString;
        String methodName = lastNameComponent;
        if (Character.isLowerCase(firstLetter)) {
            int index = methodString.lastIndexOf(".");
            fullClassName = methodString.substring(0, index);
        } else {
            methodName = originalMethod.getName();
        }
        return this.getParentMethod(fullClassName, methodName);
    }

    private FrankMethod getParentMethod(String className, String methodName) {
        try {
            FrankClass parentClass = this.classRepository.findClass(className);
            if (parentClass == null) {
                log.error("Class {} is unknown", (Object)className);
                return null;
            }
            for (FrankMethod parentMethod : parentClass.getDeclaredAndInheritedMethods()) {
                if (!parentMethod.getName().equals(methodName)) continue;
                return parentMethod;
            }
            return null;
        }
        catch (FrankDocException e) {
            log.error("Super class [{}] was not found!", (Object)className, (Object)e);
            return null;
        }
    }

    private boolean createConfigChildren(FrankElement parent) throws FrankDocException {
        log.trace("Creating config children of FrankElement [{}]", () -> parent.getFullName());
        boolean createdNewConfigChildren = false;
        List frankMethods = parent.getUnusedConfigChildSetterCandidates().keySet().stream().filter(m -> this.configChildDescriptors.containsKey(m.getName())).collect(Collectors.toList());
        for (FrankMethod frankMethod : frankMethods) {
            log.trace("Have config child setter candidate [{}]", () -> frankMethod.getName());
            List<ConfigChildSetterDescriptor> descriptorCandidates = this.configChildDescriptors.get(frankMethod.getName());
            ConfigChildSetterDescriptor configChildDescriptor = ConfigChildSetterDescriptor.find(parent, descriptorCandidates);
            if (configChildDescriptor == null) {
                log.trace("Not a config child, next");
                continue;
            }
            log.trace("Have ConfigChildSetterDescriptor [{}]", () -> configChildDescriptor.toString());
            ConfigChild configChild = configChildDescriptor.createConfigChild(parent, frankMethod);
            configChild.setExcluded(frankMethod);
            configChild.setAllowMultiple(configChildDescriptor.isAllowMultiple());
            try {
                configChild.setMandatoryStatus(MandatoryStatus.fromMethod(frankMethod));
            }
            catch (FrankDocException e) {
                log.error("Could not calculate mandatoryStatus for config child [{}]", (Object)configChild.toString(), (Object)e);
            }
            if (configChildDescriptor.isForObject()) {
                log.trace("For FrankElement [{}] method [{}], going to search element role", () -> parent.getFullName(), () -> frankMethod.getName());
                FrankClass elementTypeClass = (FrankClass)frankMethod.getParameterTypes()[0];
                ((ObjectConfigChild)configChild).setElementRole(this.findOrCreateElementRole(elementTypeClass, configChildDescriptor.getRoleName()));
                ((ObjectConfigChild)configChild).getElementRole().getElementType().getMembers().forEach(f -> f.addConfigParent(configChild));
                log.trace("For FrankElement [{}] method [{}], have the element role", () -> parent.getFullName(), () -> frankMethod.getName());
            }
            configChild.setOrder(parent.getUnusedConfigChildSetterCandidates().get(frankMethod));
            createdNewConfigChildren = true;
            parent.getConfigChildrenUnderConstruction().add(configChild);
            parent.getUnusedConfigChildSetterCandidates().remove(frankMethod);
            if (log.isTraceEnabled() && frankMethod.isMultiplyInheritedPlaceholder()) {
                log.trace("Config child [{}] is not based on a declared method, but was added because of possible multiple inheritance", (Object)configChild.toString());
            }
            log.trace("Done creating config child {}, the order is {}", () -> configChild.toString(), () -> configChild.getOrder());
        }
        log.trace("Done creating config children of FrankElement [{}]", () -> parent.getFullName());
        return createdNewConfigChildren;
    }

    void finishConfigChildrenFor(FrankElement parent) {
        log.trace("Removing duplicate config children of FrankElement [{}]", () -> parent.getFullName());
        List<ConfigChild> result = ConfigChild.removeDuplicates(parent.getConfigChildrenUnderConstruction());
        Collections.sort(result, Comparator.comparingInt(ElementChild::getOrder));
        parent.setConfigChildren(result);
        log.trace("The config children are (sequence follows sequence of Java methods):");
        if (log.isTraceEnabled()) {
            result.forEach(c -> log.trace("{}", (Object)c.toString()));
        }
    }

    ElementRole findOrCreateElementRole(FrankClass elementTypeClass, String roleName) throws FrankDocException {
        log.trace("ElementRole requested for elementTypeClass [{}] and roleName [{}]. Going to get the ElementType", () -> elementTypeClass.getName(), () -> roleName);
        ElementType elementType = this.findOrCreateElementType(elementTypeClass);
        ElementRole.Key key = new ElementRole.Key(elementTypeClass.getName(), roleName);
        if (this.allElementRoles.containsKey(key)) {
            log.trace("ElementRole already present");
            ElementRole result = this.allElementRoles.get(key);
            return result;
        }
        ElementRole result = this.elementRoleFactory.create(elementType, roleName);
        this.allElementRoles.put(key, result);
        log.trace("For ElementType [{}] and roleName [{}], created ElementRole [{}]", () -> elementType.getFullName(), () -> roleName, () -> result.createXsdElementName(""));
        return result;
    }

    public ElementRole findElementRole(ElementRole.Key key) {
        return this.allElementRoles.get(key);
    }

    public ElementRole findElementRole(ObjectConfigChild configChild) {
        return this.findElementRole(new ElementRole.Key(configChild));
    }

    ElementRole findElementRole(String fullElementTypeName, String roleName) {
        return this.allElementRoles.get(new ElementRole.Key(fullElementTypeName, roleName));
    }

    ElementType findOrCreateElementType(FrankClass clazz) throws FrankDocException {
        log.trace("Requested ElementType for class [{}]", () -> clazz.getName());
        if (this.allTypes.containsKey(clazz.getName())) {
            log.trace("Already present");
            return this.allTypes.get(clazz.getName());
        }
        FrankDocGroup group = this.groupFactory.getGroup(clazz);
        log.trace("Creating ElementType [{}] with group [{}]", () -> clazz.getName(), () -> group.getName());
        ElementType result = new ElementType(clazz, group, this.classRepository);
        this.allTypes.put(result.getFullName(), result);
        if (result.isFromJavaInterface()) {
            log.trace("Class [{}] is a Java interface, going to create all member FrankElement", () -> clazz.getName());
            List<FrankClass> memberClasses = clazz.getInterfaceImplementations();
            Collections.sort(memberClasses, Comparator.comparing(FrankProgramElement::getName));
            for (FrankClass memberClass : memberClasses) {
                this.addElementIfNotProtected(memberClass, result);
            }
        } else {
            log.trace("Class [{}] is not a Java interface, creating its FrankElement", () -> clazz.getName());
            FrankElement member = this.findOrCreateFrankElement(clazz.getName());
            result.addMember(member);
            member.addTypeMembership(result);
        }
        log.trace("Done creating ElementType for class [{}]", () -> clazz.getName());
        return result;
    }

    private void addElementIfNotProtected(FrankClass memberClass, ElementType result) throws FrankDocException {
        if (Feature.PROTECTED.isEffectivelySetOn(memberClass)) {
            log.info("Class [{}] has feature PROTECTED, not added to type [{}]", (Object)memberClass.getName(), (Object)result.getFullName());
        } else {
            FrankElement frankElement = this.findOrCreateFrankElement(memberClass.getName());
            result.addMember(frankElement);
            frankElement.addTypeMembership(result);
        }
    }

    public ElementType findElementType(String fullName) {
        return this.allTypes.get(fullName);
    }

    void calculateCommonInterfacesHierarchies() {
        log.trace("Going to calculate highest common interface for every ElementType");
        this.allTypes.values().forEach(et -> et.calculateCommonInterfaceHierarchy(this));
        log.trace("Done calculating highest common interface for every ElementType");
    }

    void setOverriddenFrom() {
        log.trace("Going to set property overriddenFrom for all config children and all attributes of all FrankElement");
        Set remainingElements = this.allElements.values().stream().map(FrankElement::getFullName).collect(Collectors.toSet());
        while (!remainingElements.isEmpty()) {
            FrankElement current = this.allElements.get(remainingElements.iterator().next());
            while (current.getParent() != null && remainingElements.contains(current.getParent().getFullName())) {
                current = current.getParent();
            }
            if (log.isTraceEnabled()) {
                log.trace("Seting property overriddenFrom for all config children and all attributes of FrankElement [{}]", (Object)current.getFullName());
            }
            current.getConfigChildren(ElementChild.ALL).forEach(c -> c.calculateOverriddenFrom());
            current.getAttributes(ElementChild.ALL).forEach(c -> c.calculateOverriddenFrom());
            current.getStatistics().finish();
            if (log.isTraceEnabled()) {
                log.trace("Done seting property overriddenFrom for FrankElement [{}]", (Object)current.getFullName());
            }
            remainingElements.remove(current.getFullName());
        }
        log.trace("Done setting property overriddenFrom");
    }

    void setElementNamesOfFrankElements(String rootClassName) {
        FrankElement root = this.allElements.get(rootClassName);
        root.addXmlElementName(root.getSimpleName());
        for (ElementRole role : this.allElementRoles.values()) {
            role.getMembers().forEach(frankElement -> frankElement.addXmlElementName(frankElement.getXsdElementName(role)));
        }
    }

    void setHighestCommonInterface() {
        log.trace("Doing FrankDocModel.setHighestCommonInterface");
        for (ElementRole role : this.allElementRoles.values()) {
            String roleName = role.getRoleName();
            ElementType et = role.getElementType().getHighestCommonInterface();
            ElementRole result = this.findElementRole(new ElementRole.Key(et.getFullName(), roleName));
            if (result == null) {
                log.trace("Promoting ElementRole [{}] results in ElementType [{}] and role name {}], but there is no corresponding ElementRole", () -> role.toString(), () -> et.getFullName(), () -> roleName);
                role.setHighestCommonInterface(role);
                continue;
            }
            role.setHighestCommonInterface(result);
            log.trace("Role [{}] has highest common interface [{}]", () -> role.toString(), () -> result.toString());
        }
        log.trace("Done FrankDocModel.setHighestCommonInterface");
    }

    void createConfigChildSets() {
        log.trace("Doing FrankDocModel.createConfigChildSets");
        this.allElementRoles.values().forEach(ElementRole::initConflicts);
        ArrayList<FrankElement> sortedFrankElements = new ArrayList<FrankElement>(this.allElements.values());
        Collections.sort(sortedFrankElements);
        sortedFrankElements.forEach(this::createConfigChildSets);
        ArrayList<ElementRole> sortedElementRoles = new ArrayList<ElementRole>(this.allElementRoles.values());
        Collections.sort(sortedElementRoles);
        sortedElementRoles.stream().filter(role -> role.getElementType().isFromJavaInterface()).forEach(role -> this.recursivelyCreateElementRoleSets(Arrays.asList(role), 1));
        this.allElementRoleSets.values().forEach(ElementRoleSet::initConflicts);
        log.trace("Done FrankDocModel.createConfigChildSets");
    }

    private void createConfigChildSets(FrankElement frankElement) {
        log.trace("Handling FrankElement [{}]", () -> frankElement.getFullName());
        Map<String, List<ConfigChild>> cumChildrenByRoleName = frankElement.getCumulativeConfigChildren(ElementChild.ALL_NOT_EXCLUDED, ElementChild.EXCLUDED).stream().collect(Collectors.groupingBy(c -> c.getRoleName()));
        for (String roleName : cumChildrenByRoleName.keySet()) {
            List<ConfigChild> configChildren = cumChildrenByRoleName.get(roleName);
            if (!configChildren.stream().map(ElementChild::getOwningElement).anyMatch(childOwner -> childOwner == frankElement)) continue;
            log.trace("Found ConfigChildSet for role name [{}]", (Object)roleName);
            ConfigChildSet configChildSet = new ConfigChildSet(configChildren);
            frankElement.addConfigChildSet(configChildSet);
            this.createElementRoleSetIfApplicable(configChildSet);
        }
        log.trace("Done handling FrankElement [{}]", () -> frankElement.getFullName());
    }

    private void createElementRoleSetIfApplicable(ConfigChildSet configChildSet) {
        switch (configChildSet.getConfigChildGroupKind()) {
            case TEXT: {
                log.trace("[{}] holds only TextConfigChild. No ElementRoleSet needed", () -> configChildSet.toString());
                break;
            }
            case MIXED: {
                log.error("[{}] combines ObjectConfigChild and TextConfigChild, which is not supported", (Object)configChildSet.toString());
                break;
            }
            case OBJECT: {
                this.createElementRoleSet(configChildSet);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot happen, switch should cover all enum values");
            }
        }
    }

    void createElementRoleSet(ConfigChildSet configChildSet) {
        Set<ElementRole> roles = configChildSet.getElementRoleStream().collect(Collectors.toSet());
        Set key = roles.stream().map(ElementRole::getKey).collect(Collectors.toSet());
        if (!this.allElementRoleSets.containsKey(key)) {
            log.trace("New ElementRoleSet for roles [{}]", () -> ElementRole.describeCollection(roles));
            this.allElementRoleSets.put(key, new ElementRoleSet(roles));
        }
        ElementRoleSet elementRoleSet = this.allElementRoleSets.get(key);
        log.trace("[{}] has ElementRoleSet [{}]", () -> configChildSet.toString(), () -> elementRoleSet.toString());
    }

    private void recursivelyCreateElementRoleSets(List<ElementRole> roleGroup, int recursionDepth) {
        log.trace("Enter with roles [{}] and recursion depth [{}]", () -> ElementRole.describeCollection(roleGroup), () -> recursionDepth);
        List rawMembers = roleGroup.stream().flatMap(role -> role.getRawMembers().stream()).distinct().collect(Collectors.toList());
        Map<String, List<ConfigChild>> configChildrenByRoleName = rawMembers.stream().flatMap(element -> element.getConfigChildren(ElementChild.ALL_NOT_EXCLUDED).stream()).collect(Collectors.groupingBy(ConfigChild::getRoleName));
        ArrayList<String> names = new ArrayList<String>(configChildrenByRoleName.keySet());
        Collections.sort(names);
        for (String name : names) {
            List<ConfigChild> configChildren = configChildrenByRoleName.get(name);
            this.handleMemberChildrenWithCommonRoleName(configChildren, recursionDepth);
        }
        log.trace("Leave for roles [{}] and recursion depth [{}]", () -> ElementRole.describeCollection(roleGroup), () -> recursionDepth);
    }

    void handleMemberChildrenWithCommonRoleName(List<ConfigChild> configChildren, int recursionDepth) {
        log.trace("Considering config children [{}]", () -> ConfigChild.toString(configChildren));
        switch (ConfigChildGroupKind.groupKind(configChildren)) {
            case TEXT: {
                log.trace("No ElementRoleSet needed for combination of TextConfigChild [{}]", () -> ConfigChild.toString(configChildren));
                break;
            }
            case MIXED: {
                log.error("Browsing member children produced a combination of ObjectConfigChild and TextConfigChild [{}], which is not supported", (Object)ConfigChild.toString(configChildren));
                break;
            }
            case OBJECT: {
                this.findOrCreateElementRoleSetForMemberChildren(configChildren, recursionDepth);
                break;
            }
            default: {
                throw new IllegalArgumentException("Should not happen, because switch statement should cover all enum values");
            }
        }
    }

    void findOrCreateElementRoleSetForMemberChildren(List<ConfigChild> configChildren, int recursionDepth) {
        Set<ElementRole> roles = ConfigChild.getElementRoleStream(configChildren).collect(Collectors.toSet());
        Set key = roles.stream().map(ElementRole::getKey).collect(Collectors.toSet());
        if (!this.allElementRoleSets.containsKey(key)) {
            this.allElementRoleSets.put(key, new ElementRoleSet(roles));
            log.trace("Added new ElementRoleSet [{}]", () -> this.allElementRoleSets.get(key).toString());
            List<ElementRole> recursionParents = new ArrayList<ElementRole>(roles);
            recursionParents = recursionParents.stream().collect(Collectors.toList());
            Collections.sort(recursionParents);
            this.recursivelyCreateElementRoleSets(recursionParents, recursionDepth + 1);
        }
    }

    AttributeEnum findOrCreateAttributeEnum(FrankClass clazz) {
        return this.attributeEnumFactory.findOrCreateAttributeEnum(clazz);
    }

    public AttributeEnum findAttributeEnum(String enumTypeFullName) {
        return this.attributeEnumFactory.findAttributeEnum(enumTypeFullName);
    }

    public List<AttributeEnum> getAllAttributeEnumInstances() {
        return this.attributeEnumFactory.getAll();
    }

    public void checkSuspiciousHtml() {
        HashSet<String> allSuspiciousHtmlTagsFound = new HashSet<String>();
        for (FrankElement frankElement : this.allElements.values()) {
            this.checkDescription(frankElement.getDescription(), "FrankElement", frankElement.getFullName(), allSuspiciousHtmlTagsFound);
            frankElement.getConfigChildren(ElementChild.ALL).stream().filter(c -> c.getDescription() != null).forEach(c -> this.checkDescription(c.getDescription(), "ConfigChild", c.toString(), allSuspiciousHtmlTagsFound));
            frankElement.getAttributes(ElementChild.ALL).stream().filter(a -> a.getDescription() != null).forEach(a -> this.checkDescription(a.getDescription(), "Attribute", a.toString(), allSuspiciousHtmlTagsFound));
        }
        if (!allSuspiciousHtmlTagsFound.isEmpty()) {
            log.warn("Searching over the descriptions of elements, config children and attributes, the following suspicious HTML tags were found: [{}]", (Object)this.formatSuspiciousHtmlTags(allSuspiciousHtmlTagsFound));
        }
    }

    private void checkDescription(String description, String item, String itemName, Set<String> allSuspiciousHtmlTagsFound) {
        List<String> htmlTags = Utils.getHtmlTags(description);
        HashSet<String> suspiciousHtmlTags = new HashSet<String>(htmlTags);
        suspiciousHtmlTags.removeAll(EXPECTED_HTML_TAGS);
        allSuspiciousHtmlTagsFound.addAll(suspiciousHtmlTags);
        if (!suspiciousHtmlTags.isEmpty()) {
            log.warn("{} [{}] has a description with suspicious HTML tags: [{}]", (Object)item, (Object)itemName, (Object)this.formatSuspiciousHtmlTags(suspiciousHtmlTags));
        }
    }

    private String formatSuspiciousHtmlTags(Set<String> suspiciousHtmlTags) {
        return suspiciousHtmlTags.stream().map(s -> "<" + s + ">").collect(Collectors.joining(", "));
    }

    void calculateTypeNameSeq() {
        Map<String, List<FrankElement>> elementsBySimpleName = this.allElements.values().stream().collect(Collectors.groupingBy(FrankElement::getSimpleName));
        for (String name : elementsBySimpleName.keySet()) {
            ArrayList nameGroup = new ArrayList(elementsBySimpleName.get(name));
            Collections.sort(nameGroup);
            for (int seq = 0; seq < nameGroup.size(); ++seq) {
                ((FrankElement)nameGroup.get(seq)).setTypeNameSeq(seq + 1);
            }
        }
    }

    void calculateInterfaceBased() {
        this.allTypes.values().stream().filter(ElementType::isFromJavaInterface).flatMap(et -> et.getMembers().stream()).forEach(f -> f.setInterfaceBased(true));
    }

    public void buildGroups() {
        Map<String, List<ElementType>> groupsElementTypes = this.allTypes.values().stream().collect(Collectors.groupingBy(f -> f.getGroup().getName()));
        this.groups = this.groupFactory.getAllGroups();
        for (FrankDocGroup group : this.groups) {
            ArrayList<ElementType> elementTypes = new ArrayList<ElementType>();
            if (groupsElementTypes.containsKey(group.getName())) {
                elementTypes = new ArrayList(groupsElementTypes.get(group.getName()));
            }
            Collections.sort(elementTypes);
            group.setElementTypes(elementTypes);
        }
        this.allElements.values().stream().filter(f -> f.getExplicitGroup() != null).forEach(f -> f.syntax2RestrictTo(f.getExplicitGroup().getElementTypes(), f.getExplicitGroup().getName()));
        HashMap<String, FrankElement> leftOvers = new HashMap<String, FrankElement>(this.allElements);
        this.allTypes.values().stream().flatMap(et -> et.getSyntax2Members().stream()).forEach(f -> {
            FrankElement cfr_ignored_0 = (FrankElement)leftOvers.remove(f.getFullName());
        });
        this.elementsOutsideConfigChildren = leftOvers.values().stream().filter(f -> !f.isAbstract()).filter(f -> !f.getXmlElementNames().isEmpty()).sorted().collect(Collectors.toList());
    }

    public Map<String, List<ConfigChildSetterDescriptor>> getConfigChildDescriptors() {
        return this.configChildDescriptors;
    }

    public List<FrankDocGroup> getGroups() {
        return this.groups;
    }

    public Map<String, FrankElement> getAllElements() {
        return this.allElements;
    }

    public Map<String, ElementType> getAllTypes() {
        return this.allTypes;
    }

    public List<FrankElement> getElementsOutsideConfigChildren() {
        return this.elementsOutsideConfigChildren;
    }

    public Map<ElementRole.Key, ElementRole> getAllElementRoles() {
        return this.allElementRoles;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    private class ParsedIbisDocRef {
        private boolean hasOrder;
        private int order;
        private FrankMethod referredMethod;

        private ParsedIbisDocRef() {
        }

        public boolean isHasOrder() {
            return this.hasOrder;
        }

        public void setHasOrder(boolean hasOrder) {
            this.hasOrder = hasOrder;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public FrankMethod getReferredMethod() {
            return this.referredMethod;
        }

        public void setReferredMethod(FrankMethod referredMethod) {
            this.referredMethod = referredMethod;
        }
    }

    private class FrankElementCreationStrategyNonRoot
    extends FrankElementCreationStrategy {
        private FrankElementCreationStrategyNonRoot() {
        }

        @Override
        FrankElement createFromClass(FrankClass clazz) {
            return new FrankElement(clazz, FrankDocModel.this.classRepository, FrankDocModel.this.groupFactory);
        }

        @Override
        FrankElement recursiveFindOrCreate(String fullClassName) throws FrankDocException {
            return FrankDocModel.this.findOrCreateFrankElement(fullClassName);
        }
    }

    private class FrankElementCreationStrategyRoot
    extends FrankElementCreationStrategy {
        private FrankElementCreationStrategyRoot() {
        }

        @Override
        FrankElement createFromClass(FrankClass clazz) {
            return new RootFrankElement(clazz, FrankDocModel.this.classRepository, FrankDocModel.this.groupFactory);
        }

        @Override
        FrankElement recursiveFindOrCreate(String fullClassName) throws FrankDocException {
            return FrankDocModel.this.findOrCreateRootFrankElement(fullClassName);
        }
    }

    private abstract class FrankElementCreationStrategy {
        private FrankElementCreationStrategy() {
        }

        abstract FrankElement createFromClass(FrankClass var1);

        abstract FrankElement recursiveFindOrCreate(String var1) throws FrankDocException;
    }

    private class Handler
    extends DigesterRulesHandler {
        private Handler() {
        }

        @Override
        protected void handle(DigesterRule rule) throws SAXException {
            DigesterRulesPattern pattern = new DigesterRulesPattern(rule.getPattern());
            String registerTextMethod = rule.getRegisterTextMethod();
            if (StringUtils.isNotEmpty(rule.getRegisterMethod())) {
                if (StringUtils.isNotEmpty(registerTextMethod)) {
                    this.log.warn("digester-rules.xml, role name {}: Have both registerMethod and registerTextMethod, ignoring the latter", (Object)pattern.getRoleName());
                }
                this.addTypeObject(rule.getRegisterMethod(), pattern);
            } else if (StringUtils.isNotEmpty(registerTextMethod)) {
                if (registerTextMethod.startsWith("set")) {
                    this.log.error("digester-rules.xml: Ignoring registerTextMethod {} because it starts with \"set\" to avoid confusion with attributes", (Object)registerTextMethod);
                } else {
                    this.addTypeText(registerTextMethod, pattern);
                }
            } else if (this.log.isTraceEnabled()) {
                this.log.trace("digester-rules.xml, ignoring role name {} because there is no registerMethod and no registerTextMethod attribute", (Object)pattern.getRoleName());
            }
        }

        private void addTypeObject(String registerMethod, DigesterRulesPattern pattern) throws SAXException {
            this.log.trace("Have ConfigChildSetterDescriptor for ObjectConfigChild: roleName = {}, registerMethod = {}", () -> pattern.getRoleName(), () -> registerMethod);
            ConfigChildSetterDescriptor.ForObject descriptor = new ConfigChildSetterDescriptor.ForObject(registerMethod, pattern);
            this.register(descriptor, pattern);
        }

        private void addTypeText(String registerMethod, DigesterRulesPattern pattern) throws SAXException {
            this.log.trace("Have ConfigChildSetterDescriptor for TextConfigChild: roleName = {}, registerMethod = {}", () -> pattern.getRoleName(), () -> registerMethod);
            ConfigChildSetterDescriptor.ForText descriptor = new ConfigChildSetterDescriptor.ForText(registerMethod, pattern);
            this.register(descriptor, pattern);
        }

        private void register(ConfigChildSetterDescriptor descriptor, DigesterRulesPattern pattern) {
            if (!FrankDocModel.this.configChildDescriptors.containsKey(descriptor.getMethodName())) {
                FrankDocModel.this.configChildDescriptors.put(descriptor.getMethodName(), new ArrayList());
            }
            ((List)FrankDocModel.this.configChildDescriptors.get(descriptor.getMethodName())).add(descriptor);
            DigesterRulesPattern.Matcher matcher = pattern.getMatcher();
            if (matcher != null) {
                this.log.trace("Role name [{}] has Matcher [{}]", () -> descriptor.getRoleName(), () -> matcher.toString());
            }
        }
    }
}

