/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.Utils;
import org.frankframework.frankdoc.model.AncestorChildNavigation;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ConfigChildSet;
import org.frankframework.frankdoc.model.CumulativeChildHandler;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.ElementRole;
import org.frankframework.frankdoc.model.ElementType;
import org.frankframework.frankdoc.model.Feature;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.model.FrankDocGroup;
import org.frankframework.frankdoc.model.FrankDocGroupFactory;
import org.frankframework.frankdoc.model.FrankElementStatistics;
import org.frankframework.frankdoc.model.ParsedJavaDocTag;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassRepository;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankMethod;
import org.frankframework.frankdoc.wrapper.FrankProgramElement;
import org.frankframework.frankdoc.wrapper.FrankType;

public class FrankElement
implements Comparable<FrankElement> {
    static final String JAVADOC_PARAMETERS = "@ff.parameters";
    public static final String JAVADOC_PARAMETER = "@ff.parameter";
    public static final String JAVADOC_FORWARD = "@ff.forward";
    public static final String JAVADOC_TAG = "@ff.tag";
    private static Logger log = LogUtil.getLogger(FrankElement.class);
    private static final Comparator<FrankElement> COMPARATOR = Comparator.comparing(FrankElement::getSimpleName).thenComparing(FrankElement::getFullName);
    private static final Pattern DESCRIPTION_HEADER_SPLIT = Pattern.compile("(\\. )|(\\.\\n)|(\\.\\r\\n)");
    private LinkedHashMap<FrankMethod, Integer> unusedConfigChildSetterCandidates = new LinkedHashMap();
    private List<ConfigChild> configChildrenUnderConstruction = new ArrayList<ConfigChild>();
    private final String fullName;
    private final String simpleName;
    private int typeNameSeq = 1;
    private final boolean isAbstract;
    private boolean isDeprecated = false;
    private boolean interfaceBased = false;
    private FrankElement parent;
    private List<ConfigChild> configParents = new ArrayList<ConfigChild>();
    private Map<Class<? extends ElementChild>, LinkedHashMap<? extends ElementChild.AbstractKey, ? extends ElementChild>> allChildren;
    private List<String> xmlElementNames;
    private FrankElementStatistics statistics;
    private LinkedHashMap<String, ConfigChildSet> configChildSets;
    private String description;
    private String descriptionHeader;
    private String meaningOfParameters;
    private List<ParsedJavaDocTag> specificParameters = new ArrayList<ParsedJavaDocTag>();
    private List<ParsedJavaDocTag> forwards = new ArrayList<ParsedJavaDocTag>();
    private List<ParsedJavaDocTag> tags = new ArrayList<ParsedJavaDocTag>();
    private FrankDocGroup explicitGroup = null;
    private Set<String> inTypes = new HashSet<String>();
    private Set<String> syntax2ExcludedFromTypes = new HashSet<String>();

    FrankElement(FrankClass clazz, FrankClassRepository repository, FrankDocGroupFactory groupFactory) {
        this(clazz.getName(), clazz.getSimpleName(), clazz.isAbstract());
        this.isDeprecated = Feature.DEPRECATED.isSetOn(clazz);
        this.configChildSets = new LinkedHashMap();
        this.completeFrankElement(clazz);
        this.handleConfigChildSetterCandidates(clazz);
        if (clazz.getAnnotation("nl.nn.adapterframework.doc.FrankDocGroup") != null) {
            this.explicitGroup = groupFactory.getGroup(clazz);
            log.trace("FrankElement [{}] has explicit @FrankDocGroup annotation with group name [{}]", () -> this.getFullName(), () -> this.explicitGroup.getName());
        }
        this.handlePossibleParameters(clazz);
        this.handlePossibleForwards(clazz);
        this.handlePossibleTags(clazz);
    }

    private void completeFrankElement(FrankClass clazz) {
        this.setDescription(clazz.getJavaDoc());
        if (this.getDescription() != null) {
            this.setDescriptionHeader(FrankElement.calculateDescriptionHeader(this.getDescription()));
        }
    }

    static String calculateDescriptionHeader(String description) {
        String descriptionHeader = DESCRIPTION_HEADER_SPLIT.split(description)[0];
        String remainder = description.substring(descriptionHeader.length());
        if (remainder.startsWith(".")) {
            descriptionHeader = descriptionHeader + ".";
        }
        return descriptionHeader;
    }

    private void handleConfigChildSetterCandidates(FrankClass clazz) {
        List methods = Arrays.asList(clazz.getDeclaredMethodsAndMultiplyInheritedPlaceholders()).stream().filter(FrankProgramElement::isPublic).filter(Utils::isConfigChildSetter).collect(Collectors.toList());
        for (int i = 0; i < methods.size(); ++i) {
            if (this.configChildCandidateHasProtectedArgument((FrankMethod)methods.get(i))) continue;
            this.unusedConfigChildSetterCandidates.put((FrankMethod)methods.get(i), i);
        }
    }

    private boolean configChildCandidateHasProtectedArgument(FrankMethod frankMethod) {
        log.trace("Checking method [{}]", () -> frankMethod.toString());
        FrankType argumentType = frankMethod.getParameterTypes()[0];
        if (!(argumentType instanceof FrankClass)) {
            return false;
        }
        FrankClass argument = (FrankClass)argumentType;
        if (argument.isInterface()) {
            return false;
        }
        try {
            if (Feature.PROTECTED.isEffectivelySetOn(argument)) {
                log.trace("Method [{}] is not a config child candidate because class [{}] has feature PROTECTED", () -> frankMethod.toString(), () -> argument.toString());
                return true;
            }
        }
        catch (FrankDocException e) {
            log.error("Failed to check PROTECTED feature on class [{}]", (Object)argument.toString(), (Object)e);
            return true;
        }
        return false;
    }

    private void handlePossibleParameters(FrankClass clazz) {
        this.meaningOfParameters = clazz.getJavaDocTag(JAVADOC_PARAMETERS);
        this.assembleParsedJavaDocTags(clazz, JAVADOC_PARAMETER, p -> this.specificParameters.add((ParsedJavaDocTag)p));
    }

    private void handlePossibleForwards(FrankClass clazz) {
        this.assembleParsedJavaDocTags(clazz, JAVADOC_FORWARD, p -> this.forwards.add((ParsedJavaDocTag)p));
    }

    private void handlePossibleTags(FrankClass clazz) {
        this.assembleParsedJavaDocTags(clazz, JAVADOC_TAG, p -> this.tags.add((ParsedJavaDocTag)p));
        Map<String, Long> tagCounts = this.tags.stream().collect(Collectors.groupingBy(ParsedJavaDocTag::getName, Collectors.counting()));
        List duplicates = tagCounts.entrySet().stream().filter(e -> (Long)e.getValue() >= 2L).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
        for (String duplicate : duplicates) {
            log.error("FrankElement [{}] has multiple values for tag [{}]", (Object)this.fullName, (Object)duplicate);
        }
    }

    private void assembleParsedJavaDocTags(FrankClass clazz, String tagName, Consumer<ParsedJavaDocTag> acceptor) {
        for (String arguments : clazz.getAllJavaDocTagsOf(tagName)) {
            ParsedJavaDocTag parsed = null;
            try {
                parsed = ParsedJavaDocTag.getInstance(arguments);
            }
            catch (FrankDocException e) {
                log.error("Error parsing a [{}] tag of class [{}]", (Object)tagName, (Object)this.fullName, (Object)e);
                continue;
            }
            if (parsed.getDescription() == null) {
                log.warn("FrankElement [{}] has a [{}] tag without a value: [{}]", (Object)this.fullName, (Object)tagName, (Object)arguments);
            }
            acceptor.accept(parsed);
        }
    }

    public FrankElement(String fullName, String simpleName, boolean isAbstract) {
        this.fullName = fullName;
        this.simpleName = simpleName;
        this.isAbstract = isAbstract;
        this.allChildren = new HashMap<Class<? extends ElementChild>, LinkedHashMap<? extends ElementChild.AbstractKey, ? extends ElementChild>>();
        this.allChildren.put(FrankAttribute.class, new LinkedHashMap());
        this.allChildren.put(ConfigChild.class, new LinkedHashMap());
        this.xmlElementNames = new ArrayList<String>();
    }

    public void setParent(FrankElement parent) {
        this.parent = parent;
        if (parent != null && this.explicitGroup == null) {
            this.explicitGroup = parent.explicitGroup;
            log.trace("FrankElement [{}] inherits @FrankDocGroup annotation with name [{}] from parent [{}]", () -> this.getFullName(), () -> this.explicitGroup == null ? "null" : this.explicitGroup.getName(), () -> parent.getFullName());
        }
        this.statistics = new FrankElementStatistics(this);
    }

    void addConfigParent(ConfigChild parent) {
        log.trace("To [{}] [{}] added config parent [{}]", (Object)this.getClass().getSimpleName(), (Object)this.fullName, (Object)parent.toString());
        this.configParents.add(parent);
    }

    public List<ConfigChild> getConfigParents() {
        ArrayList<ConfigChild> result = new ArrayList<ConfigChild>();
        result.addAll(this.configParents);
        return result;
    }

    public void addXmlElementName(String elementName) {
        Utils.addToSortedListUnique(this.xmlElementNames, elementName);
    }

    public boolean hasOnePossibleXmlElementName() {
        return this.xmlElementNames.size() == 1;
    }

    public String getTheSingleXmlElementName() {
        if (!this.hasOnePossibleXmlElementName()) {
            throw new IllegalStateException(String.format("FrankElement [%s] has more then one possible XML element name: [%s]", this.fullName, this.xmlElementNames.stream().collect(Collectors.joining(", "))));
        }
        return this.xmlElementNames.get(0);
    }

    public void setAttributes(List<FrankAttribute> inputAttributes) {
        this.setChildrenOfKind(inputAttributes, FrankAttribute.class);
    }

    private <C extends ElementChild> void setChildrenOfKind(List<C> inputChildren, Class<C> kind) {
        LinkedHashMap<ElementChild.AbstractKey, ElementChild> children = new LinkedHashMap<ElementChild.AbstractKey, ElementChild>();
        for (ElementChild c : inputChildren) {
            if (children.containsKey(c.getKey())) {
                log.error("Frank element [{}] has multiple attributes / config children with key [{}]", () -> this.fullName, () -> c.getKey().toString());
                continue;
            }
            children.put(c.getKey(), c);
        }
        this.allChildren.put(kind, children);
    }

    public List<FrankAttribute> getAttributes(Predicate<ElementChild> filter) {
        return this.getChildrenOfKind(filter, FrankAttribute.class);
    }

    public <T extends ElementChild> List<T> getChildrenOfKind(Predicate<ElementChild> selector, Class<T> kind) {
        Map lookup = this.allChildren.get(kind);
        return lookup.values().stream().filter(selector).map(c -> c).collect(Collectors.toList());
    }

    public void setConfigChildren(List<ConfigChild> children) {
        this.setChildrenOfKind(children, ConfigChild.class);
    }

    public List<ConfigChild> getConfigChildren(Predicate<ElementChild> filter) {
        return this.getChildrenOfKind(filter, ConfigChild.class);
    }

    <C extends ElementChild> ElementChild findElementChildMatch(C elementChild) {
        Class<Object> clazz = elementChild.getClass();
        if (elementChild instanceof ConfigChild) {
            clazz = ConfigChild.class;
        }
        Map lookup = this.allChildren.get(clazz);
        return (ElementChild)lookup.get(elementChild.getKey());
    }

    public FrankElement getNextAncestorThatHasChildren(Predicate<FrankElement> noChildren) {
        FrankElement ancestor;
        for (ancestor = this.parent; ancestor != null && noChildren.test(ancestor); ancestor = ancestor.getParent()) {
        }
        return ancestor;
    }

    public FrankElement getNextAncestorThatHasOrRejectsConfigChildren(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        FrankElement ancestorConfigChildren = this.getNextAncestorThatHasChildren(el -> el.getChildrenOfKind(selector, ConfigChild.class).isEmpty() && el.getChildrenOfKind(rejector, ConfigChild.class).isEmpty());
        return ancestorConfigChildren;
    }

    public FrankElement getNextAncestorThatHasOrRejectsAttributes(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        FrankElement ancestorAttributes = this.getNextAncestorThatHasChildren(el -> el.getChildrenOfKind(selector, FrankAttribute.class).isEmpty() && el.getChildrenOfKind(rejector, FrankAttribute.class).isEmpty());
        return ancestorAttributes;
    }

    public void walkCumulativeAttributes(CumulativeChildHandler<FrankAttribute> handler, Predicate<ElementChild> childSelector, Predicate<ElementChild> childRejector) {
        new AncestorChildNavigation<FrankAttribute>(handler, childSelector, childRejector, FrankAttribute.class).run(this);
    }

    public void walkCumulativeConfigChildren(CumulativeChildHandler<ConfigChild> handler, Predicate<ElementChild> childSelector, Predicate<ElementChild> childRejector) {
        new AncestorChildNavigation<ConfigChild>(handler, childSelector, childRejector, ConfigChild.class).run(this);
    }

    public List<ConfigChild> getCumulativeConfigChildren(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        return this.getCumulativeChildren(selector, rejector, ConfigChild.class).stream().map(c -> c).collect(Collectors.toList());
    }

    public List<FrankAttribute> getCumulativeAttributes(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        return this.getCumulativeChildren(selector, rejector, FrankAttribute.class).stream().map(c -> c).collect(Collectors.toList());
    }

    private <T extends ElementChild> List<T> getCumulativeChildren(final Predicate<ElementChild> selector, final Predicate<ElementChild> rejector, final Class<T> kind) {
        final ArrayList result = new ArrayList();
        new AncestorChildNavigation<T>(new CumulativeChildHandler<T>(){

            @Override
            public void handleSelectedChildren(List<T> children, FrankElement owner) {
                result.addAll(children);
            }

            @Override
            public void handleSelectedChildrenOfTopLevel(List<T> children, FrankElement owner) {
                this.handleSelectedChildren(children, owner);
            }

            @Override
            public void handleChildrenOf(FrankElement frankElement) {
                result.addAll(frankElement.getChildrenOfKind(selector, kind));
            }

            @Override
            public void handleCumulativeChildrenOf(FrankElement frankElement) {
                result.addAll(frankElement.getCumulativeChildren(selector, rejector, kind));
            }
        }, selector, rejector, kind).run(this);
        return result;
    }

    public String getXsdElementName(ElementRole elementRole) {
        return this.getXsdElementName(elementRole.getElementType(), elementRole.getRoleName());
    }

    String getXsdElementName(ElementType elementType, String roleName) {
        if (!elementType.isFromJavaInterface()) {
            return Utils.toUpperCamelCase(roleName);
        }
        List removablePostfixes = elementType.getCommonInterfaceHierarchy().stream().map(ElementType::getGroupName).collect(Collectors.toList());
        String result = this.simpleName;
        for (String removablePostfix : removablePostfixes) {
            if (!result.endsWith(removablePostfix)) continue;
            result = result.substring(0, result.lastIndexOf(removablePostfix));
            break;
        }
        result = result + Utils.toUpperCamelCase(roleName);
        return result;
    }

    void addConfigChildSet(ConfigChildSet configChildSet) {
        this.configChildSets.put(configChildSet.getRoleName(), configChildSet);
    }

    public ConfigChildSet getConfigChildSet(String roleName) {
        return this.configChildSets.get(roleName);
    }

    public List<ConfigChildSet> getCumulativeConfigChildSets() {
        HashMap<String, ConfigChildSet> resultAsMap = new HashMap<String, ConfigChildSet>();
        for (String string : this.configChildSets.keySet()) {
            resultAsMap.put(string, this.configChildSets.get(string));
        }
        if (this.parent != null) {
            List<ConfigChildSet> inheritedConfigChildSets = this.getParent().getCumulativeConfigChildSets();
            for (ConfigChildSet inherited : inheritedConfigChildSets) {
                resultAsMap.putIfAbsent(inherited.getRoleName(), inherited);
            }
        }
        ArrayList<ConfigChildSet> result = new ArrayList<ConfigChildSet>();
        ArrayList arrayList = new ArrayList(resultAsMap.keySet());
        Collections.sort(arrayList);
        for (String key : arrayList) {
            result.add((ConfigChildSet)resultAsMap.get(key));
        }
        return result;
    }

    public boolean hasFilledConfigChildSets(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        if (this.configChildSets.isEmpty()) {
            return false;
        }
        return this.configChildSets.values().stream().anyMatch(cs -> cs.getConfigChildren().stream().filter(selector.or(rejector)).collect(Collectors.counting()) >= 1L);
    }

    public FrankElement getNextPluralConfigChildrenAncestor(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        for (FrankElement ancestor = this.parent; ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.getParent().hasOrInheritsPluralConfigChildren(selector, rejector)) {
                return ancestor;
            }
            if (!ancestor.hasFilledConfigChildSets(selector, rejector)) continue;
            return ancestor;
        }
        return null;
    }

    public boolean hasOrInheritsPluralConfigChildren(Predicate<ElementChild> selector, Predicate<ElementChild> rejector) {
        boolean hasPluralConfigChildren = this.configChildSets.values().stream().anyMatch(c -> c.getFilteredElementRoles(selector, rejector).size() >= 2);
        boolean inheritsPluralConfigChildren = false;
        FrankElement ancestor = this.getNextAncestorThatHasOrRejectsConfigChildren(selector, rejector);
        if (ancestor != null) {
            inheritsPluralConfigChildren = ancestor.hasOrInheritsPluralConfigChildren(selector, rejector);
        }
        return hasPluralConfigChildren || inheritsPluralConfigChildren;
    }

    public String getTypeNameBase() {
        if (this.typeNameSeq <= 1) {
            return this.getSimpleName();
        }
        return this.getSimpleName() + Integer.valueOf(this.typeNameSeq).toString();
    }

    void addTypeMembership(ElementType elementType) {
        this.inTypes.add(elementType.getFullName());
    }

    void syntax2RestrictTo(Collection<ElementType> elementTypes, String groupName) {
        this.syntax2ExcludedFromTypes = new HashSet<String>(this.inTypes);
        this.syntax2ExcludedFromTypes.removeAll(elementTypes.stream().map(ElementType::getFullName).collect(Collectors.toSet()));
        if (this.syntax2ExcludedFromTypes.equals(this.inTypes) && !this.inTypes.isEmpty()) {
            log.error("It is not allowed to restrict class [{}] to group [{}], because that group does not have an ElementType that contains the mentioned class. This limitation exists to ensure that [{}] remains visible as a config child", (Object)this.fullName, (Object)groupName, (Object)this.fullName);
        }
    }

    boolean syntax2ExcludedFromType(String typeName) {
        return this.syntax2ExcludedFromTypes.contains(typeName);
    }

    @Override
    public int compareTo(FrankElement other) {
        return COMPARATOR.compare(this, other);
    }

    static String describe(Collection<FrankElement> collection) {
        return collection.stream().map(FrankElement::getFullName).collect(Collectors.joining(", "));
    }

    static Set<FrankElement> join(Set<FrankElement> s1, Set<FrankElement> s2) {
        HashSet<FrankElement> result = new HashSet<FrankElement>();
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    public String toString() {
        return this.fullName;
    }

    public LinkedHashMap<FrankMethod, Integer> getUnusedConfigChildSetterCandidates() {
        return this.unusedConfigChildSetterCandidates;
    }

    public List<ConfigChild> getConfigChildrenUnderConstruction() {
        return this.configChildrenUnderConstruction;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setTypeNameSeq(int typeNameSeq) {
        this.typeNameSeq = typeNameSeq;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isInterfaceBased() {
        return this.interfaceBased;
    }

    void setInterfaceBased(boolean interfaceBased) {
        this.interfaceBased = interfaceBased;
    }

    public FrankElement getParent() {
        return this.parent;
    }

    public List<String> getXmlElementNames() {
        return this.xmlElementNames;
    }

    public FrankElementStatistics getStatistics() {
        return this.statistics;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescriptionHeader() {
        return this.descriptionHeader;
    }

    public void setDescriptionHeader(String descriptionHeader) {
        this.descriptionHeader = descriptionHeader;
    }

    public String getMeaningOfParameters() {
        return this.meaningOfParameters;
    }

    public List<ParsedJavaDocTag> getSpecificParameters() {
        return this.specificParameters;
    }

    public List<ParsedJavaDocTag> getForwards() {
        return this.forwards;
    }

    public List<ParsedJavaDocTag> getTags() {
        return this.tags;
    }

    FrankDocGroup getExplicitGroup() {
        return this.explicitGroup;
    }
}

