/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.frankframework.frankdoc.model.ConfigChild;
import org.frankframework.frankdoc.model.ElementChild;
import org.frankframework.frankdoc.model.FrankAttribute;
import org.frankframework.frankdoc.model.FrankElement;

public class FrankElementStatistics {
    private FrankElement subject;
    private int numAncestors;
    private int numChildren;
    private int numDescendants;
    private int numConfigChildren;
    private int numAttributes;
    private int numOverriddenConfigChildren;
    private int numOverriddenAttributes;
    private int numConfigChildOverriders;
    private int numAttributeOverriders;
    private int minConfigChildOverriderDepth;
    private int maxConfigChildOverriderDepth;
    private int minAttributeOverriderDepth;
    private int maxAttributeOverriderDepth;

    FrankElementStatistics(FrankElement subject) {
        this.subject = subject;
        this.numAncestors = subject.getParent() == null ? 0 : subject.getParent().getStatistics().getNumAncestors() + 1;
    }

    public static String header() {
        return Arrays.asList("FullName", "numAncestors", "numChildren", "numDescendants", "numConfigChildren", "numAttributes", "numOverriddenConfigChildren", "numOverriddenAttributes", "numConfigChildOverriders", "numAttributeOverriders", "minConfigChildOverriderDepth", "maxConfigChildOverriderDepth", "minAttributeOverriderDepth", "maxAttributeOverriderDepth").stream().collect(Collectors.joining(", "));
    }

    public String toString() {
        return Arrays.asList(this.subject.getFullName(), new Integer(this.numAncestors).toString(), new Integer(this.numChildren).toString(), new Integer(this.numDescendants).toString(), new Integer(this.numConfigChildren).toString(), new Integer(this.numAttributes).toString(), new Integer(this.numOverriddenConfigChildren).toString(), new Integer(this.numOverriddenAttributes).toString(), new Integer(this.numConfigChildOverriders).toString(), new Integer(this.numAttributeOverriders).toString(), new Integer(this.minConfigChildOverriderDepth).toString(), new Integer(this.maxConfigChildOverriderDepth).toString(), new Integer(this.minAttributeOverriderDepth).toString(), new Integer(this.maxAttributeOverriderDepth).toString()).stream().collect(Collectors.joining(", "));
    }

    void finish() {
        this.finishDescendantStatistics();
        this.finishConfigChildOverrideStatistics();
        this.finishAttributeOverrideStatistics();
    }

    private void finishDescendantStatistics() {
        this.numConfigChildren = this.subject.getConfigChildren(ElementChild.ALL_NOT_EXCLUDED).size();
        this.numAttributes = this.subject.getAttributes(ElementChild.ALL_NOT_EXCLUDED).size();
        boolean isFirstAncestor = true;
        FrankElement ancestor = this.subject;
        while (ancestor.getParent() != null) {
            ancestor = ancestor.getParent();
            ++ancestor.getStatistics().numDescendants;
            if (!isFirstAncestor) continue;
            ++ancestor.getStatistics().numChildren;
            isFirstAncestor = false;
        }
    }

    private void finishConfigChildOverrideStatistics() {
        for (ConfigChild configChild : this.subject.getConfigChildren(ElementChild.ALL_NOT_EXCLUDED)) {
            if (configChild.getOverriddenFrom() == null) continue;
            ++this.numOverriddenConfigChildren;
            this.addConfigChildOverriddenFrom(configChild.getOverriddenFrom());
        }
    }

    private void addConfigChildOverriddenFrom(FrankElement overriddenFrom) {
        overriddenFrom.getStatistics().onConfigChildOverriderAtDepth(this.inheritanceDistance(overriddenFrom));
    }

    private int inheritanceDistance(FrankElement targetAncestor) {
        int depth = 0;
        FrankElement ancestor = this.subject;
        while (ancestor != targetAncestor) {
            ancestor = ancestor.getParent();
            ++depth;
        }
        return depth;
    }

    private void onConfigChildOverriderAtDepth(int depth) {
        ++this.numConfigChildOverriders;
        if (this.minConfigChildOverriderDepth == 0) {
            this.minConfigChildOverriderDepth = depth;
            this.maxConfigChildOverriderDepth = depth;
        } else {
            if (depth < this.minConfigChildOverriderDepth) {
                this.minConfigChildOverriderDepth = depth;
            }
            if (depth > this.maxConfigChildOverriderDepth) {
                this.maxConfigChildOverriderDepth = depth;
            }
        }
    }

    private void finishAttributeOverrideStatistics() {
        for (FrankAttribute attribute : this.subject.getAttributes(ElementChild.ALL_NOT_EXCLUDED)) {
            if (attribute.getOverriddenFrom() == null) continue;
            ++this.numOverriddenAttributes;
            this.addAttributeOverriddenFrom(attribute.getOverriddenFrom());
        }
    }

    private void addAttributeOverriddenFrom(FrankElement overriddenFrom) {
        overriddenFrom.getStatistics().onAttributeOverriderAtDepth(this.inheritanceDistance(overriddenFrom));
    }

    private void onAttributeOverriderAtDepth(int depth) {
        ++this.numAttributeOverriders;
        if (this.minAttributeOverriderDepth == 0) {
            this.minAttributeOverriderDepth = depth;
            this.maxAttributeOverriderDepth = depth;
        } else {
            if (depth < this.minAttributeOverriderDepth) {
                this.minAttributeOverriderDepth = depth;
            }
            if (depth > this.maxAttributeOverriderDepth) {
                this.maxAttributeOverriderDepth = depth;
            }
        }
    }

    public FrankElement getSubject() {
        return this.subject;
    }

    public int getNumAncestors() {
        return this.numAncestors;
    }

    public int getNumChildren() {
        return this.numChildren;
    }

    public int getNumDescendants() {
        return this.numDescendants;
    }

    public int getNumConfigChildren() {
        return this.numConfigChildren;
    }

    public int getNumAttributes() {
        return this.numAttributes;
    }

    public int getNumOverriddenConfigChildren() {
        return this.numOverriddenConfigChildren;
    }

    public int getNumOverriddenAttributes() {
        return this.numOverriddenAttributes;
    }

    public int getNumConfigChildOverriders() {
        return this.numConfigChildOverriders;
    }

    public int getNumAttributeOverriders() {
        return this.numAttributeOverriders;
    }

    public int getMinConfigChildOverriderDepth() {
        return this.minConfigChildOverriderDepth;
    }

    public int getMaxConfigChildOverriderDepth() {
        return this.maxConfigChildOverriderDepth;
    }

    public int getMinAttributeOverriderDepth() {
        return this.minAttributeOverriderDepth;
    }

    public int getMaxAttributeOverriderDepth() {
        return this.maxAttributeOverriderDepth;
    }
}

