/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.frankframework.frankdoc.model.Feature;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankMethod;

public enum MandatoryStatus {
    MANDATORY,
    BECOMES_MANDATORY,
    OPTIONAL;

    private static final Set<String> IGNORE_COMPATIBILITY;
    private static final Set<String> DONT_IGNORE_COMPATIBILITY;

    static MandatoryStatus fromMethod(FrankMethod method) throws FrankDocException {
        if (Feature.MANDATORY.isEffectivelySetOn(method)) {
            return MandatoryStatus.fromMethodProperties(Feature.OPTIONAL.isEffectivelySetOn(method), Feature.MANDATORY.isEffectivelySetOn(method), Feature.MANDATORY.valueOf(method));
        }
        return MandatoryStatus.fromMethodProperties(Feature.OPTIONAL.isEffectivelySetOn(method), Feature.MANDATORY.isEffectivelySetOn(method), null);
    }

    private static MandatoryStatus fromMethodProperties(boolean isOptional, boolean isMandatory, String valueOfMandatory) throws FrankDocException {
        if (isOptional) {
            return OPTIONAL;
        }
        if (isMandatory) {
            if (valueOfMandatory == null || DONT_IGNORE_COMPATIBILITY.contains(valueOfMandatory)) {
                return MANDATORY;
            }
            if (IGNORE_COMPATIBILITY.contains(valueOfMandatory)) {
                return BECOMES_MANDATORY;
            }
            throw new FrankDocException(String.format("Unknown value of JavaDoc tag %s: [%s]", "@ff.mandatory", valueOfMandatory), null);
        }
        return OPTIONAL;
    }

    static {
        IGNORE_COMPATIBILITY = new HashSet<String>(Arrays.asList("true", "ignoreInCompatibilityMode"));
        DONT_IGNORE_COMPATIBILITY = new HashSet<String>(Arrays.asList("", "false"));
    }
}

