/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankDocException;

public class ParsedJavaDocTag {
    private static Logger log = LogUtil.getLogger(ParsedJavaDocTag.class);
    private static String QUOTE = "\"";
    private final String name;
    private final String description;

    static ParsedJavaDocTag getInstance(String javaDocTagParameter) throws FrankDocException {
        if (StringUtils.isAllBlank(javaDocTagParameter)) {
            throw new FrankDocException("Tag has no arguments", null);
        }
        if (javaDocTagParameter.startsWith(QUOTE)) {
            return ParsedJavaDocTag.getInstanceQuoteDelimited(javaDocTagParameter);
        }
        return ParsedJavaDocTag.getInstanceSpaceDelimited(javaDocTagParameter);
    }

    private static ParsedJavaDocTag getInstanceQuoteDelimited(String javaDocTagParameter) {
        int startQuoteIdx = javaDocTagParameter.indexOf(QUOTE);
        int endQuoteIdx = javaDocTagParameter.indexOf(QUOTE, startQuoteIdx + 1);
        if (endQuoteIdx < 0) {
            log.error("Name of parameter or forward is quoted, but there is no end quote, text is [{}]", (Object)javaDocTagParameter);
            return ParsedJavaDocTag.getInstanceSpaceDelimited(javaDocTagParameter);
        }
        String name = javaDocTagParameter.substring(startQuoteIdx + 1, endQuoteIdx);
        if (endQuoteIdx >= javaDocTagParameter.length() - 1) {
            return new ParsedJavaDocTag(name, null);
        }
        String description = javaDocTagParameter.substring(endQuoteIdx + 1).trim();
        return new ParsedJavaDocTag(name, description);
    }

    private static ParsedJavaDocTag getInstanceSpaceDelimited(String javaDocTagParameter) {
        int idx = javaDocTagParameter.indexOf(" ");
        if (idx < 0) {
            return new ParsedJavaDocTag(javaDocTagParameter, null);
        }
        String name = javaDocTagParameter.substring(0, idx).trim();
        String description = javaDocTagParameter.substring(idx).trim();
        if (description.isEmpty()) {
            return new ParsedJavaDocTag(name, null);
        }
        return new ParsedJavaDocTag(name, description);
    }

    private ParsedJavaDocTag(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

