/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.util;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.util.LogUtil;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class XmlBuilder {
    static Logger log = LogUtil.getLogger(XmlBuilder.class);
    private final String CDATA_END = "]]>";
    private Element element;

    public XmlBuilder(String tagName) {
        this.element = new Element(tagName);
    }

    public XmlBuilder(String tagName, String prefix, String uri) {
        this.element = new Element(tagName, prefix, uri);
    }

    public void addAttribute(String name, String value) {
        if (value != null) {
            if (name.equalsIgnoreCase("xmlns")) {
                this.element.setNamespace(Namespace.getNamespace(value));
            } else if (StringUtils.startsWithIgnoreCase(name, "xmlns:")) {
                String prefix = name.substring(6);
                this.element.addNamespaceDeclaration(Namespace.getNamespace(prefix, value));
            } else {
                this.element.setAttribute(new Attribute(name, value));
            }
        }
    }

    public void addAttribute(String name, boolean value) {
        this.addAttribute(name, "" + value);
    }

    public void addAttribute(String name, long value) {
        this.addAttribute(name, "" + value);
    }

    public void addSubElement(XmlBuilder newElement) {
        this.addSubElement(newElement, true);
    }

    public void addSubElement(String name, String value) {
        XmlBuilder subElement = new XmlBuilder(name);
        subElement.setValue(value);
        this.addSubElement(subElement, true);
    }

    public void addSubElement(XmlBuilder newElement, boolean adoptNamespace) {
        if (newElement != null) {
            if (adoptNamespace && StringUtils.isNotEmpty(this.element.getNamespaceURI())) {
                this.addNamespaceRecursive(newElement.element, this.element.getNamespace());
            }
            this.element.addContent(newElement.element);
        }
    }

    private void addNamespaceRecursive(Element element, Namespace namespace) {
        if (StringUtils.isEmpty(element.getNamespaceURI())) {
            element.setNamespace(namespace);
            List<Element> childList = element.getChildren();
            if (!childList.isEmpty()) {
                for (Element child : childList) {
                    this.addNamespaceRecursive(child, namespace);
                }
            }
        }
    }

    public void setCdataValue(String value) {
        if (value != null) {
            if (value.contains("]]>")) {
                int cdata_end_pos;
                while ((cdata_end_pos = value.indexOf("]]>")) >= 0) {
                    this.element.addContent(new CDATA(value.substring(0, cdata_end_pos + 1)));
                    value = value.substring(cdata_end_pos + 1);
                }
                this.element.addContent(new CDATA(value));
            } else {
                this.element.setContent(new CDATA(value));
            }
        }
    }

    public void setValue(String value) {
        if (value != null) {
            this.element.setText(value);
        }
    }

    public String toXML() {
        return this.toXML(false);
    }

    public String toXML(boolean xmlHeader) {
        Document document = new Document(this.element.detach());
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat().setOmitDeclaration(!xmlHeader));
        return xmlOutputter.outputString(document);
    }
}

