/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationValue;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankDocException;

class FrankAnnotationDoclet
implements FrankAnnotation {
    private final AnnotationDesc annotation;

    FrankAnnotationDoclet(AnnotationDesc annotation) {
        this.annotation = annotation;
    }

    @Override
    public String getName() {
        return this.annotation.annotationType().qualifiedName();
    }

    @Override
    public boolean isPublic() {
        return this.annotation.annotationType().isPublic();
    }

    @Override
    public Object getValue() throws FrankDocException {
        List<Object> candidates = this.getField("value");
        return this.getValueFromFieldRemovingRepetition(candidates);
    }

    @Override
    public Object getValueOf(String fieldName) throws FrankDocException {
        List<Object> candidates = this.getField(fieldName);
        return this.getValueFromFieldRemovingRepetition(candidates);
    }

    private List<Object> getField(String fieldName) {
        List<Object> candidates = Arrays.asList(this.annotation.elementValues()).stream().filter(ev -> ev.element().name().equals(fieldName)).map(ev -> ev.value().value()).collect(Collectors.toList());
        return candidates;
    }

    private Object getValueFromFieldRemovingRepetition(List<Object> candidates) throws FrankDocException {
        if (candidates.isEmpty()) {
            return null;
        }
        Object raw = candidates.get(0);
        if (raw instanceof Integer || raw instanceof String || raw instanceof Boolean) {
            return raw;
        }
        return this.parseAnnotationValueAsStringArray(raw);
    }

    private Object parseAnnotationValueAsStringArray(Object rawValue) throws FrankDocException {
        AnnotationValue[] valueAsArray = null;
        try {
            valueAsArray = (AnnotationValue[])rawValue;
        }
        catch (ClassCastException e) {
            throw new FrankDocException(String.format("Annotation has unknown type: [%s]", this.getName()), e);
        }
        List valueAsStringList = Arrays.asList(valueAsArray).stream().map(v -> v.value().toString()).collect(Collectors.toList());
        String[] result = new String[valueAsStringList.size()];
        for (int i = 0; i < valueAsStringList.size(); ++i) {
            result[i] = (String)valueAsStringList.get(i);
        }
        return result;
    }
}

