/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankAnnotation;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassRepository;
import org.frankframework.frankdoc.wrapper.FrankClassRepositoryDoclet;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.FrankDocletUtils;
import org.frankframework.frankdoc.wrapper.FrankEnumConstant;
import org.frankframework.frankdoc.wrapper.FrankEnumConstantDoclet;
import org.frankframework.frankdoc.wrapper.FrankMethod;
import org.frankframework.frankdoc.wrapper.FrankMethodDoclet;
import org.frankframework.frankdoc.wrapper.FrankMethodDocletBase;
import org.frankframework.frankdoc.wrapper.FrankProgramElement;
import org.frankframework.frankdoc.wrapper.MultiplyInheritedMethodPlaceholder;
import org.frankframework.frankdoc.wrapper.TransitiveImplementedInterfaceBrowser;

class FrankClassDoclet
implements FrankClass {
    private static Logger log = LogUtil.getLogger(FrankClassDoclet.class);
    private final FrankClassRepository repository;
    private final ClassDoc clazz;
    private final Set<String> childClassNames = new HashSet<String>();
    private final Map<String, FrankClass> interfaceImplementationsByName = new HashMap<String, FrankClass>();
    private final LinkedHashMap<MethodDoc, FrankMethod> frankMethodsByDocletMethod = new LinkedHashMap();
    private final Map<String, FrankMethodDoclet> methodsBySignature = new HashMap<String, FrankMethodDoclet>();
    private final Map<String, FrankAnnotation> frankAnnotationsByName;
    private List<MultiplyInheritedMethodPlaceholder> multiplyInheritedMethodPlaceholders = new ArrayList<MultiplyInheritedMethodPlaceholder>();

    FrankClassDoclet(ClassDoc clazz, FrankClassRepository repository) {
        this.repository = repository;
        this.clazz = clazz;
        for (MethodDoc methodDoc : clazz.methods()) {
            FrankMethodDoclet frankMethod = new FrankMethodDoclet(methodDoc, this);
            this.frankMethodsByDocletMethod.put(methodDoc, frankMethod);
            this.methodsBySignature.put(frankMethod.getSignature(), frankMethod);
        }
        AnnotationDesc[] annotationDescs = clazz.annotations();
        this.frankAnnotationsByName = FrankDocletUtils.getFrankAnnotationsByName(annotationDescs);
    }

    void addChild(String className) {
        this.childClassNames.add(className);
    }

    void recursivelyAddInterfaceImplementation(FrankClassDoclet implementation) throws FrankDocException {
        if (((FrankClassRepositoryDoclet)this.repository).classIsAllowedAsInterfaceImplementation(implementation)) {
            log.trace("Interface {} is implemented by {}", () -> this.getName(), () -> implementation.getName());
            this.interfaceImplementationsByName.put(implementation.getName(), implementation);
        } else {
            log.trace("From interface {} omitted implementation because of filtering {}", () -> this.getName(), () -> implementation.getName());
        }
        for (String implementationChildClassName : implementation.childClassNames) {
            FrankClassDoclet implementationChild = (FrankClassDoclet)this.repository.findClass(implementationChildClassName);
            this.recursivelyAddInterfaceImplementation(implementationChild);
        }
    }

    @Override
    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Override
    public String getName() {
        return this.clazz.qualifiedName();
    }

    @Override
    public FrankAnnotation[] getAnnotations() {
        ArrayList<FrankAnnotation> values = new ArrayList<FrankAnnotation>(this.frankAnnotationsByName.values());
        return values.toArray(new FrankAnnotation[0]);
    }

    @Override
    public FrankAnnotation getAnnotation(String name) {
        return this.frankAnnotationsByName.get(name);
    }

    @Override
    public String getSimpleName() {
        String result = this.clazz.name();
        if (result.contains(".")) {
            result = result.substring(result.lastIndexOf(".") + 1);
        }
        return result;
    }

    @Override
    public String getPackageName() {
        return this.clazz.containingPackage().name();
    }

    @Override
    public FrankClass getSuperclass() {
        FrankClass result = null;
        ClassDoc superClazz = this.clazz.superclass();
        if (superClazz != null) {
            try {
                String superclassQualifiedName = superClazz.qualifiedName();
                boolean omit = ((FrankClassRepositoryDoclet)this.repository).getExcludeFiltersForSuperclass().stream().anyMatch(exclude -> superclassQualifiedName.startsWith((String)exclude));
                if (omit) {
                    return null;
                }
                result = this.repository.findClass(superclassQualifiedName);
            }
            catch (FrankDocException e) {
                log.error("Could not get superclass of {}", (Object)this.getName(), (Object)e);
            }
        }
        return result;
    }

    @Override
    public FrankClass[] getInterfaces() {
        List<FrankClass> resultList = this.getInterfacesAsList();
        return resultList.toArray(new FrankClass[0]);
    }

    List<FrankClass> getInterfacesAsList() {
        ClassDoc[] interfaceDocs = this.clazz.interfaces();
        ArrayList<FrankClass> resultList = new ArrayList<FrankClass>();
        for (ClassDoc interfaceDoc : interfaceDocs) {
            try {
                FrankClass interfaze = this.repository.findClass(interfaceDoc.qualifiedName());
                if (interfaze == null) continue;
                resultList.add(interfaze);
            }
            catch (FrankDocException e) {
                log.error("Error searching for {}", (Object)interfaceDoc.name(), (Object)e);
            }
        }
        return resultList;
    }

    @Override
    public boolean isAbstract() {
        return this.clazz.isAbstract();
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isPublic() {
        return this.clazz.isPublic();
    }

    @Override
    public List<FrankClass> getInterfaceImplementations() throws FrankDocException {
        if (!this.isInterface()) {
            throw new FrankDocException(String.format("Cannot get implementations of non-interface [%s]", this.getName()), null);
        }
        return this.interfaceImplementationsByName.values().stream().filter(c -> !c.isAbstract()).collect(Collectors.toList());
    }

    @Override
    public FrankMethod[] getDeclaredMethods() {
        ArrayList<FrankMethod> resultList = new ArrayList<FrankMethod>(this.frankMethodsByDocletMethod.values());
        return resultList.toArray(new FrankMethod[0]);
    }

    @Override
    public FrankMethod[] getDeclaredAndInheritedMethods() {
        List resultList = this.getDeclaredAndInheritedMethodsAsMap().values().stream().filter(FrankProgramElement::isPublic).collect(Collectors.toList());
        FrankMethod[] result = new FrankMethod[resultList.size()];
        for (int i = 0; i < resultList.size(); ++i) {
            result[i] = (FrankMethod)resultList.get(i);
        }
        return result;
    }

    private Map<MethodDoc, FrankMethod> getDeclaredAndInheritedMethodsAsMap() {
        HashMap<MethodDoc, FrankMethod> result = new HashMap<MethodDoc, FrankMethod>();
        if (this.getSuperclass() != null) {
            result.putAll(((FrankClassDoclet)this.getSuperclass()).getDeclaredAndInheritedMethodsAsMap());
        }
        List<FrankMethod> declaredMethodList = Arrays.asList(this.getDeclaredMethods());
        for (FrankMethod declaredMethod : declaredMethodList) {
            ((FrankMethodDoclet)declaredMethod).removeOverriddenFrom(result);
        }
        declaredMethodList.forEach(dm -> ((FrankMethodDoclet)dm).addToRepository(result));
        return result;
    }

    @Override
    public FrankEnumConstant[] getEnumConstants() {
        FieldDoc[] fieldDocs = this.clazz.enumConstants();
        FrankEnumConstant[] result = new FrankEnumConstant[fieldDocs.length];
        for (int i = 0; i < fieldDocs.length; ++i) {
            result[i] = new FrankEnumConstantDoclet(fieldDocs[i]);
        }
        return result;
    }

    FrankClassRepositoryDoclet getRepository() {
        return (FrankClassRepositoryDoclet)this.repository;
    }

    FrankMethod recursivelyFindFrankMethod(MethodDoc methodDoc) {
        if (this.frankMethodsByDocletMethod.containsKey(methodDoc)) {
            return this.frankMethodsByDocletMethod.get(methodDoc);
        }
        if (this.getSuperclass() != null) {
            return ((FrankClassDoclet)this.getSuperclass()).recursivelyFindFrankMethod(methodDoc);
        }
        return null;
    }

    FrankMethodDoclet getMethodFromSignature(String signature) {
        return this.methodsBySignature.get(signature);
    }

    <T> T getMethodItemFromSignature(String methodSignature, Function<FrankMethodDocletBase, T> getter) {
        FrankMethodDoclet frankMethod = this.getMethodFromSignature(methodSignature);
        if (frankMethod != null) {
            return getter.apply(frankMethod);
        }
        return null;
    }

    boolean isTopLevel() {
        return this.clazz.containingClass() == null;
    }

    @Override
    public String getJavaDoc() {
        return this.clazz.commentText();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public FrankAnnotation getAnnotationIncludingInherited(String annotationFullName) throws FrankDocException {
        FrankAnnotation result = this.getAnnotationExcludingImplementedInterfaces(annotationFullName);
        if (result == null) {
            result = this.getAnnotationFromImplementedInterfaces(annotationFullName);
        }
        return result;
    }

    private FrankAnnotation getAnnotationExcludingImplementedInterfaces(String annotationFullName) throws FrankDocException {
        FrankAnnotation result = this.getAnnotation(annotationFullName);
        if (result == null && this.getSuperclass() != null) {
            result = ((FrankClassDoclet)this.getSuperclass()).getAnnotationExcludingImplementedInterfaces(annotationFullName);
        }
        return result;
    }

    private FrankAnnotation getAnnotationFromImplementedInterfaces(String annotationFullName) throws FrankDocException {
        TransitiveImplementedInterfaceBrowser<FrankAnnotation> browser = new TransitiveImplementedInterfaceBrowser<FrankAnnotation>(this);
        FrankAnnotation result = browser.search(c -> ((FrankClassDoclet)c).getAnnotation(annotationFullName));
        if (result == null && this.getSuperclass() != null) {
            result = ((FrankClassDoclet)this.getSuperclass()).getAnnotationFromImplementedInterfaces(annotationFullName);
        }
        return result;
    }

    @Override
    public String getJavaDocTag(String tagName) {
        Tag[] tags = this.clazz.tags(tagName);
        if (tags == null || tags.length == 0) {
            return null;
        }
        return tags[0].text();
    }

    @Override
    public List<String> getAllJavaDocTagsOf(String tagName) {
        Tag[] tags = this.clazz.tags(tagName);
        if (tags == null) {
            return new ArrayList<String>();
        }
        return Arrays.asList(tags).stream().map(Tag::text).collect(Collectors.toList());
    }

    @Override
    public String getJavaDocTagIncludingInherited(String tagName) throws FrankDocException {
        String result = this.getJavaDocTagExcludingImplementedInterfaces(tagName);
        if (result == null) {
            result = this.getJavaDocTagFromImplementedInterfaces(tagName);
        }
        return result;
    }

    private String getJavaDocTagExcludingImplementedInterfaces(String tagName) throws FrankDocException {
        String result = this.getJavaDocTag(tagName);
        if (result == null && this.getSuperclass() != null) {
            result = ((FrankClassDoclet)this.getSuperclass()).getJavaDocTagExcludingImplementedInterfaces(tagName);
        }
        return result;
    }

    private String getJavaDocTagFromImplementedInterfaces(String tagName) throws FrankDocException {
        TransitiveImplementedInterfaceBrowser<String> browser = new TransitiveImplementedInterfaceBrowser<String>(this);
        String result = browser.search(c -> ((FrankClassDoclet)c).getJavaDocTag(tagName));
        if (result == null && this.getSuperclass() != null) {
            result = ((FrankClassDoclet)this.getSuperclass()).getJavaDocTagFromImplementedInterfaces(tagName);
        }
        return result;
    }

    @Override
    public FrankMethod[] getDeclaredMethodsAndMultiplyInheritedPlaceholders() {
        ArrayList<FrankMethod> result = new ArrayList<FrankMethod>();
        result.addAll(this.frankMethodsByDocletMethod.values());
        result.addAll(this.multiplyInheritedMethodPlaceholders);
        return result.toArray(new FrankMethod[0]);
    }

    void addMultiplyInheritedMethodPlaceholders() {
        try {
            List<FrankClass> interfaces = new TransitiveImplementedInterfaceBrowser(this).getInterfacesAndTheirAncestors();
            if (!interfaces.isEmpty()) {
                this.multiplyInheritedMethodPlaceholders = this.getReinheritedMethods(interfaces).stream().map(m -> (FrankMethodDoclet)m).map(m -> new MultiplyInheritedMethodPlaceholder((FrankMethodDoclet)m, this)).collect(Collectors.toList());
                if (log.isTraceEnabled()) {
                    String placeholderMethodNames = this.multiplyInheritedMethodPlaceholders.stream().map(FrankProgramElement::getName).collect(Collectors.joining(", "));
                    log.trace("Class [{}] has multiply inherited methods: [{}]", (Object)this.getName(), (Object)placeholderMethodNames);
                }
            }
        }
        catch (FrankDocException e) {
            log.error("Failed to add multiply inherited method placeholders for FrankClass [{}]", (Object)this.getName(), (Object)e);
        }
    }

    List<FrankMethod> getReinheritedMethods(List<FrankClass> interfaces) {
        ArrayList<FrankMethod> result = new ArrayList<FrankMethod>();
        Set declaredMethodSignatures = Arrays.asList(this.getDeclaredMethods()).stream().map(FrankMethod::getSignature).collect(Collectors.toSet());
        Set methodSignaturesFromImplementedInterfaces = interfaces.stream().flatMap(FrankClassDoclet::methodSignaturesOf).collect(Collectors.toSet());
        for (FrankMethod candidate : this.getDeclaredAndInheritedMethods()) {
            String candidateSignature = candidate.getSignature();
            boolean notDeclared = !declaredMethodSignatures.contains(candidateSignature);
            boolean reinherited = methodSignaturesFromImplementedInterfaces.contains(candidateSignature);
            if (!notDeclared || !reinherited) continue;
            result.add(candidate);
        }
        return result;
    }

    private static Stream<String> methodSignaturesOf(FrankClass intf) {
        return Arrays.asList(intf.getDeclaredMethods()).stream().map(FrankMethod::getSignature);
    }

    List<MultiplyInheritedMethodPlaceholder> getMultiplyInheritedMethodPlaceholders() {
        return this.multiplyInheritedMethodPlaceholders;
    }
}

