/*
 * Decompiled with CFR 0.152.
 */
package org.frankframework.frankdoc.wrapper;

import com.sun.javadoc.ClassDoc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.frankframework.frankdoc.util.LogUtil;
import org.frankframework.frankdoc.wrapper.FrankClass;
import org.frankframework.frankdoc.wrapper.FrankClassDoclet;
import org.frankframework.frankdoc.wrapper.FrankClassRepository;
import org.frankframework.frankdoc.wrapper.FrankDocException;
import org.frankframework.frankdoc.wrapper.TransitiveImplementedInterfaceBrowser;

class FrankClassRepositoryDoclet
implements FrankClassRepository {
    private static Logger log = LogUtil.getLogger(FrankClassRepositoryDoclet.class);
    private Set<String> excludeFiltersForSuperclass;
    private final Map<String, FrankClassDoclet> classesByName = new HashMap<String, FrankClassDoclet>();
    private final Set<FrankClassDoclet> filteredClassesForInterfaceImplementations;

    FrankClassRepositoryDoclet(ClassDoc[] classDocs, Set<String> includeFilters, Set<String> excludeFilters, Set<String> excludeFiltersForSuperclass) {
        this.excludeFiltersForSuperclass = new HashSet<String>(excludeFiltersForSuperclass);
        for (ClassDoc classDoc : classDocs) {
            this.findOrCreateClass(classDoc);
        }
        Set correctedIncludeFilters = includeFilters.stream().map(FrankClassRepository::removeTrailingDot).collect(Collectors.toSet());
        this.filteredClassesForInterfaceImplementations = this.classesByName.values().stream().filter(c -> correctedIncludeFilters.stream().anyMatch(i -> c.getPackageName().startsWith((String)i))).filter(c -> !excludeFilters.contains(c.getName())).filter(c -> c.isTopLevel()).collect(Collectors.toSet());
        for (FrankClassDoclet c2 : this.filteredClassesForInterfaceImplementations) {
            log.trace("Examining what interfaces are implemented by class [{}]", () -> c2.getName());
            this.setInterfaceImplementations(c2);
            log.trace("Done examining what interfaces are implemented by class [{}]", () -> c2.getName());
        }
        this.classesByName.values().forEach(FrankClassDoclet::addMultiplyInheritedMethodPlaceholders);
    }

    private FrankClassDoclet findOrCreateClass(ClassDoc classDoc) {
        if (this.classesByName.containsKey(classDoc.qualifiedName())) {
            return this.classesByName.get(classDoc.qualifiedName());
        }
        FrankClassDoclet result = new FrankClassDoclet(classDoc, this);
        this.classesByName.put(result.getName(), result);
        ClassDoc superClassDoc = classDoc.superclass();
        if (superClassDoc != null) {
            FrankClassDoclet superClazz = this.findOrCreateClass(superClassDoc);
            superClazz.addChild(result.getName());
        }
        return result;
    }

    private void setInterfaceImplementations(FrankClassDoclet clazz) {
        List implementedInterfaces = clazz.getInterfacesAsList().stream().distinct().map(c -> (FrankClassDoclet)c).collect(Collectors.toList());
        log.trace("Directly implemented interfaces: [{}]", () -> implementedInterfaces.stream().map(FrankClass::getSimpleName).collect(Collectors.joining(", ")));
        try {
            for (FrankClassDoclet interfaze : implementedInterfaces) {
                interfaze.recursivelyAddInterfaceImplementation(clazz);
                new TransitiveImplementedInterfaceBrowser<FrankClassDoclet>(interfaze).search(i -> this.loggedAddInterfaceImplementation((FrankClass)i, clazz));
            }
        }
        catch (FrankDocException e) {
            log.error("Error setting implemented interfaces of class {}", (Object)clazz.getName(), (Object)e);
        }
    }

    private FrankClassDoclet loggedAddInterfaceImplementation(FrankClass interfaze, FrankClassDoclet clazz) {
        log.trace("Considering ancestor interface {}", () -> interfaze.getName());
        try {
            ((FrankClassDoclet)interfaze).recursivelyAddInterfaceImplementation(clazz);
        }
        catch (FrankDocException e) {
            log.error("Could not recurse over chidren of {} to set them as implementations of {}", (Object)clazz.getName(), (Object)interfaze.getName(), (Object)e);
        }
        return null;
    }

    boolean classIsAllowedAsInterfaceImplementation(FrankClassDoclet clazz) {
        return this.filteredClassesForInterfaceImplementations.contains(clazz);
    }

    @Override
    public FrankClass findClass(String fullName) throws FrankDocException {
        return this.classesByName.get(fullName);
    }

    Set<String> getExcludeFiltersForSuperclass() {
        return this.excludeFiltersForSuperclass;
    }
}

